/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.minecraft;

import cc.cassian.raspberry.client.renderer.LeashFilteringBufferSource;
import cc.cassian.raspberry.compat.vanillabackport.leash.LeashRenderer;
import cc.cassian.raspberry.compat.vanillabackport.leash.Leashable;
import cc.cassian.raspberry.config.ModConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin<T extends Entity> {
    @Unique
    private LeashRenderer<T> raspberry$leashRenderer;
    @Shadow
    @Final
    protected EntityRenderDispatcher f_114476_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void raspberry$init(EntityRendererProvider.Context context, CallbackInfo ci) {
        this.raspberry$leashRenderer = new LeashRenderer(this.f_114476_);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void raspberry$renderLeash(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        if (entity instanceof Leashable) {
            MultiBufferSource renderBuffer = buffer;
            if (buffer instanceof LeashFilteringBufferSource) {
                LeashFilteringBufferSource wrapped = (LeashFilteringBufferSource)buffer;
                renderBuffer = wrapped.getDelegate();
            }
            this.raspberry$leashRenderer.render(entity, partialTick, poseStack, renderBuffer);
        }
    }

    @Inject(method={"shouldRender"}, at={@At(value="TAIL")}, cancellable=true)
    private void raspberry$shouldRenderLeash(T entity, Frustum camera, double camX, double camY, double camZ, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof Leashable) {
            cir.setReturnValue((Object)this.raspberry$leashRenderer.shouldRender(entity, camera, (Boolean)cir.getReturnValue()));
        }
    }
}

