/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.minecraft;

import cc.cassian.raspberry.compat.vanillabackport.leash.KnotInteractionHelper;
import cc.cassian.raspberry.config.ModConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FenceBlock.class})
public abstract class FenceBlockMixin
extends Block {
    public FenceBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        LeashFenceKnotEntity knot;
        if (!ModConfig.get().backportLeash) {
            return;
        }
        KnotInteractionHelper.HeldEntities held = new KnotInteractionHelper.HeldEntities((Entity)player);
        if (held.isEmpty()) {
            return;
        }
        if (level.f_46443_) {
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
        List knots = level.m_45976_(LeashFenceKnotEntity.class, new AABB(pos));
        LeashFenceKnotEntity leashFenceKnotEntity = knot = knots.isEmpty() ? null : (LeashFenceKnotEntity)knots.get(0);
        if (knot == null) {
            knot = LeashFenceKnotEntity.m_31844_((Level)level, (BlockPos)pos);
            knot.m_7084_();
        }
        InteractionResult result = KnotInteractionHelper.handleKnotInteraction(player, hand, knot);
        cir.setReturnValue((Object)result);
    }
}

