/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.minecraft;

import cc.cassian.raspberry.compat.vanillabackport.leash.KnotConnectionAccess;
import cc.cassian.raspberry.compat.vanillabackport.leash.KnotConnectionManager;
import cc.cassian.raspberry.compat.vanillabackport.leash.KnotInteractionHelper;
import cc.cassian.raspberry.compat.vanillabackport.leash.Leashable;
import cc.cassian.raspberry.config.ModConfig;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LeashFenceKnotEntity.class})
public abstract class LeashKnotEntityMixin
extends HangingEntity
implements Leashable,
KnotConnectionAccess {
    @Unique
    private static final EntityDataAccessor<OptionalInt> raspberry$DATA_ID_LEASH_HOLDER_ID = SynchedEntityData.m_135353_(LeashKnotEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    @Unique
    private int raspberry$delayedLeashHolderId;
    @Unique
    @Nullable
    private Entity raspberry$leashHolder;
    @Unique
    @Nullable
    private CompoundTag raspberry$pendingLeashTag;
    @Unique
    private final KnotConnectionManager raspberry$connectionManager = new KnotConnectionManager();

    protected LeashKnotEntityMixin(EntityType<? extends HangingEntity> type, Level level) {
        super(type, level);
    }

    @Override
    public KnotConnectionManager raspberry$getConnectionManager() {
        return this.raspberry$connectionManager;
    }

    protected void m_8097_() {
        super.m_8097_();
        if (ModConfig.get().backportLeash) {
            this.f_19804_.m_135372_(raspberry$DATA_ID_LEASH_HOLDER_ID, (Object)OptionalInt.empty());
        }
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        if (!ModConfig.get().backportLeash) {
            return;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.raspberry$leashHolder != null && !this.raspberry$leashHolder.m_6084_()) {
                this.raspberry$dropLeash(true, false);
            }
            Leashable.tickLeash(this);
            this.raspberry$connectionManager.checkDistance((LeashFenceKnotEntity)this);
        }
        if (this.raspberry$delayedLeashHolderId != 0 && this.raspberry$getLeashHolder() == null && (entity = this.f_19853_.m_6815_(this.raspberry$delayedLeashHolderId)) != null) {
            this.raspberry$setLeashedTo(entity, false);
            this.raspberry$delayedLeashHolderId = 0;
        }
    }

    @Override
    public void raspberry$onLeashRemoved() {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        LeashFenceKnotEntity self = (LeashFenceKnotEntity)this;
        boolean hasVanilla = !Leashable.leashableLeashedTo((Entity)self).isEmpty();
        boolean hasCustom = this.raspberry$connectionManager.hasConnections();
        boolean isLeashed = this.raspberry$isLeashed();
        if (!(hasVanilla || hasCustom || isLeashed)) {
            self.m_146870_();
        }
    }

    @Override
    public void raspberry$dropLeash(boolean broadcast, boolean dropItem) {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        boolean wasLeashed = this.raspberry$leashHolder != null;
        this.raspberry$leashHolder = null;
        this.raspberry$pendingLeashTag = null;
        this.raspberry$delayedLeashHolderId = 0;
        this.f_19804_.m_135381_(raspberry$DATA_ID_LEASH_HOLDER_ID, (Object)OptionalInt.empty());
        if (!this.f_19853_.f_46443_ && wasLeashed) {
            Level level;
            if (dropItem) {
                this.m_19998_((ItemLike)Items.f_42655_);
            }
            if (broadcast && (level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, null));
            }
            this.raspberry$onLeashRemoved();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void raspberry$onSave(CompoundTag compound, CallbackInfo ci) {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        if (this.raspberry$leashHolder != null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("UUID", this.raspberry$leashHolder.m_20148_());
            compound.m_128365_("Leash", (Tag)tag);
        } else if (this.raspberry$pendingLeashTag != null) {
            compound.m_128365_("Leash", (Tag)this.raspberry$pendingLeashTag.m_6426_());
        }
        this.raspberry$connectionManager.writeToNbt(compound);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void raspberry$onLoad(CompoundTag compound, CallbackInfo ci) {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        if (compound.m_128425_("Leash", 10)) {
            this.raspberry$pendingLeashTag = compound.m_128469_("Leash");
        }
        this.raspberry$connectionManager.readFromNbt(compound);
    }

    @Override
    public boolean raspberry$isLeashed() {
        if (!ModConfig.get().backportLeash) {
            return false;
        }
        return ((OptionalInt)this.f_19804_.m_135370_(raspberry$DATA_ID_LEASH_HOLDER_ID)).isPresent();
    }

    @Override
    @Nullable
    public Entity raspberry$getLeashHolder() {
        Level level;
        if (!ModConfig.get().backportLeash) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            OptionalInt holderId = (OptionalInt)this.f_19804_.m_135370_(raspberry$DATA_ID_LEASH_HOLDER_ID);
            if (holderId.isEmpty()) {
                this.raspberry$leashHolder = null;
            } else if (this.raspberry$leashHolder == null || this.raspberry$leashHolder.m_19879_() != holderId.getAsInt()) {
                this.raspberry$leashHolder = this.f_19853_.m_6815_(holderId.getAsInt());
            }
            return this.raspberry$leashHolder;
        }
        if (this.raspberry$leashHolder == null && this.raspberry$pendingLeashTag != null && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.raspberry$pendingLeashTag.m_128403_("UUID")) {
                UUID uuid = this.raspberry$pendingLeashTag.m_128342_("UUID");
                Entity entity = serverLevel.m_8791_(uuid);
                if (entity != null) {
                    this.raspberry$setLeashedTo(entity, true);
                    this.raspberry$pendingLeashTag = null;
                }
            } else {
                this.raspberry$pendingLeashTag = null;
            }
        }
        return this.raspberry$leashHolder;
    }

    @Override
    public void raspberry$setLeashedTo(Entity entity, boolean sendPacket) {
        Level level;
        if (!ModConfig.get().backportLeash) {
            return;
        }
        this.raspberry$leashHolder = entity;
        this.raspberry$pendingLeashTag = null;
        this.raspberry$delayedLeashHolderId = 0;
        this.f_19804_.m_135381_(raspberry$DATA_ID_LEASH_HOLDER_ID, (Object)OptionalInt.of(entity.m_19879_()));
        if (sendPacket && !this.f_19853_.f_46443_ && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, entity));
        }
    }

    @Override
    public void raspberry$setDelayedLeashHolderId(int id) {
        Entity entity;
        if (!ModConfig.get().backportLeash) {
            return;
        }
        this.raspberry$delayedLeashHolderId = id;
        this.raspberry$leashHolder = null;
        this.f_19804_.m_135381_(raspberry$DATA_ID_LEASH_HOLDER_ID, (Object)OptionalInt.empty());
        if (id != 0 && (entity = this.f_19853_.m_6815_(id)) != null) {
            this.raspberry$setLeashedTo(entity, false);
            this.raspberry$delayedLeashHolderId = 0;
        }
    }

    @Override
    public Vec3 raspberry$getLeashOffset(float partialTick) {
        return new Vec3(0.0, 0.2, 0.0);
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void raspberry$onInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        if (this.f_19853_.f_46443_) {
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
        LeashFenceKnotEntity knot = (LeashFenceKnotEntity)this;
        InteractionResult result = KnotInteractionHelper.handleKnotInteraction(player, hand, knot);
        this.raspberry$onLeashRemoved();
        cir.setReturnValue((Object)result);
    }

    @Inject(method={"dropItem"}, at={@At(value="HEAD")})
    private void raspberry$onDropItem(Entity breaker, CallbackInfo ci) {
        if (ModConfig.get().backportLeash && !this.f_19853_.f_46443_) {
            LeashFenceKnotEntity knot = (LeashFenceKnotEntity)this;
            this.raspberry$connectionManager.clearAllConnections(this.f_19853_, knot);
            if (this.raspberry$isLeashed()) {
                this.raspberry$dropLeash(true, true);
            }
        }
    }
}

