/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.minecraft;

import cc.cassian.raspberry.compat.vanillabackport.leash.KnotConnectionManager;
import cc.cassian.raspberry.compat.vanillabackport.leash.Leashable;
import cc.cassian.raspberry.config.ModConfig;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin {
    @Inject(method={"canBeLeashed"}, at={@At(value="HEAD")}, cancellable=true)
    private void raspberry$canBeLeashed(Player player, CallbackInfoReturnable<Boolean> cir) {
        if (ModConfig.get().backportLeash) {
            cir.setReturnValue((Object)(!(this instanceof Enemy) ? 1 : 0));
        }
    }

    @Inject(method={"dropLeash"}, at={@At(value="HEAD")})
    private void raspberry$checkKnotOnUnleash(boolean broadcast, boolean dropItem, CallbackInfo ci) {
        if (!ModConfig.get().backportLeash) {
            return;
        }
        Mob mob = (Mob)this;
        Entity holder = mob.m_21524_();
        if (holder instanceof LeashFenceKnotEntity) {
            LeashFenceKnotEntity knot = (LeashFenceKnotEntity)holder;
            List<Leashable> leashedEntities = Leashable.leashableLeashedTo((Entity)knot);
            boolean hasOtherVanilla = leashedEntities.stream().anyMatch(entity -> entity != mob);
            boolean hasCustom = KnotConnectionManager.getManager(knot).hasConnections();
            if (!hasOtherVanilla && !hasCustom) {
                knot.m_146870_();
            }
        }
    }
}

