/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.emi;

import cc.cassian.raspberry.ModCompat;
import cc.cassian.raspberry.config.ModConfig;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllMenuTypes;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.compat.emi.BlueprintTransferHandler;
import com.simibubi.create.compat.emi.DoubleItemIcon;
import com.simibubi.create.compat.emi.GhostIngredientHandler;
import com.simibubi.create.compat.emi.recipes.AutomaticPackingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.BlockCuttingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.CrushingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.DeployingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.DrainEmiRecipe;
import com.simibubi.create.compat.emi.recipes.ManualItemApplicationEmiRecipe;
import com.simibubi.create.compat.emi.recipes.MechanicalCraftingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.MillingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.MysteriousConversionEmiRecipe;
import com.simibubi.create.compat.emi.recipes.PolishingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.PressingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.SawingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.SequencedAssemblyEmiRecipe;
import com.simibubi.create.compat.emi.recipes.SpoutEmiRecipe;
import com.simibubi.create.compat.emi.recipes.basin.MixingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.basin.PackingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.basin.ShapelessEmiRecipe;
import com.simibubi.create.compat.emi.recipes.fan.FanBlastingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.fan.FanEmiRecipe;
import com.simibubi.create.compat.emi.recipes.fan.FanHauntingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.fan.FanSmokingEmiRecipe;
import com.simibubi.create.compat.emi.recipes.fan.FanWashingEmiRecipe;
import com.simibubi.create.compat.jei.ConversionRecipe;
import com.simibubi.create.compat.jei.ToolboxColoringRecipeMaker;
import com.simibubi.create.compat.recipeViewerCommon.HiddenItems;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.equipment.blueprint.BlueprintScreen;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlock;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.potion.PotionMixingRecipes;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.simibubi.create.content.kinetics.crusher.CrushingRecipe;
import com.simibubi.create.content.kinetics.millstone.MillingRecipe;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.logistics.filter.AttributeFilterScreen;
import com.simibubi.create.content.logistics.filter.FilterScreen;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerScreen;
import com.simibubi.create.content.trains.schedule.ScheduleScreen;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.item.TagDependentIngredientItem;
import com.tterrag.registrate.util.entry.FluidEntry;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;

@EmiEntrypoint
public class CreateEmiPlugin
implements EmiPlugin {
    public static final Map<ResourceLocation, EmiRecipeCategory> ALL = new LinkedHashMap<ResourceLocation, EmiRecipeCategory>();
    public static final EmiRecipeCategory MILLING = CreateEmiPlugin.register("milling", DoubleItemIcon.of((ItemLike)AllBlocks.MILLSTONE.get(), (ItemLike)AllItems.WHEAT_FLOUR.get()));
    public static final EmiRecipeCategory CRUSHING = CreateEmiPlugin.register("crushing", DoubleItemIcon.of((ItemLike)AllBlocks.CRUSHING_WHEEL.get(), (ItemLike)AllItems.CRUSHED_GOLD.get()));
    public static final EmiRecipeCategory PRESSING = CreateEmiPlugin.register("pressing", DoubleItemIcon.of((ItemLike)AllBlocks.MECHANICAL_PRESS.get(), (ItemLike)AllItems.IRON_SHEET.get()));
    public static final EmiRecipeCategory FAN_WASHING = CreateEmiPlugin.register("fan_washing", DoubleItemIcon.of((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42447_));
    public static final EmiRecipeCategory FAN_SMOKING = CreateEmiPlugin.register("fan_smoking", DoubleItemIcon.of((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42781_));
    public static final EmiRecipeCategory FAN_BLASTING = CreateEmiPlugin.register("fan_blasting", DoubleItemIcon.of((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42448_));
    public static final EmiRecipeCategory FAN_HAUNTING = CreateEmiPlugin.register("fan_haunting", DoubleItemIcon.of((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42782_));
    public static final EmiRecipeCategory MIXING = CreateEmiPlugin.register("mixing", DoubleItemIcon.of((ItemLike)AllBlocks.MECHANICAL_MIXER.get(), (ItemLike)AllBlocks.BASIN.get()));
    public static final EmiRecipeCategory AUTOMATIC_SHAPELESS = CreateEmiPlugin.register("automatic_shapeless", DoubleItemIcon.of((ItemLike)AllBlocks.MECHANICAL_MIXER.get(), (ItemLike)Items.f_41960_));
    public static final EmiRecipeCategory AUTOMATIC_BREWING = CreateEmiPlugin.register("automatic_brewing", DoubleItemIcon.of((ItemLike)AllBlocks.MECHANICAL_MIXER.get(), (ItemLike)Blocks.f_50255_));
    public static final EmiRecipeCategory PACKING = CreateEmiPlugin.register("packing", DoubleItemIcon.of((ItemLike)AllBlocks.MECHANICAL_PRESS.get(), (ItemLike)AllBlocks.BASIN.get()));
    public static final EmiRecipeCategory AUTOMATIC_PACKING = CreateEmiPlugin.register("automatic_packing", DoubleItemIcon.of((ItemLike)AllBlocks.MECHANICAL_PRESS.get(), (ItemLike)Blocks.f_50091_));
    public static final EmiRecipeCategory SAWING = CreateEmiPlugin.register("sawing", DoubleItemIcon.of((ItemLike)AllBlocks.MECHANICAL_SAW.get(), (ItemLike)Items.f_41837_));
    public static final EmiRecipeCategory BLOCK_CUTTING = CreateEmiPlugin.register("block_cutting", DoubleItemIcon.of((ItemLike)AllBlocks.MECHANICAL_SAW.get(), (ItemLike)Items.f_42092_));
    public static final EmiRecipeCategory WOOD_CUTTING = CreateEmiPlugin.register("wood_cutting", DoubleItemIcon.of((ItemLike)AllBlocks.MECHANICAL_SAW.get(), (ItemLike)Items.f_42008_));
    public static final EmiRecipeCategory SANDPAPER_POLISHING = CreateEmiPlugin.register("sandpaper_polishing", (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AllItems.SAND_PAPER.get())));
    public static final EmiRecipeCategory ITEM_APPLICATION = CreateEmiPlugin.register("item_application", (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AllItems.BRASS_HAND.get())));
    public static final EmiRecipeCategory DEPLOYING = CreateEmiPlugin.register("deploying", (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AllBlocks.DEPLOYER.get())));
    public static final EmiRecipeCategory SPOUT_FILLING = CreateEmiPlugin.register("spout_filling", DoubleItemIcon.of((ItemLike)AllBlocks.SPOUT.get(), (ItemLike)Items.f_42447_));
    public static final EmiRecipeCategory DRAINING = CreateEmiPlugin.register("draining", DoubleItemIcon.of((ItemLike)AllBlocks.ITEM_DRAIN.get(), (ItemLike)Items.f_42447_));
    public static final EmiRecipeCategory AUTOMATIC_SHAPED = CreateEmiPlugin.register("automatic_shaped", (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_CRAFTER.get())));
    public static final EmiRecipeCategory MECHANICAL_CRAFTING = CreateEmiPlugin.register("mechanical_crafting", (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_CRAFTER.get())));
    public static final EmiRecipeCategory SEQUENCED_ASSEMBLY = CreateEmiPlugin.register("sequenced_assembly", (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AllItems.PRECISION_MECHANISM.get())));
    public static final EmiRecipeCategory MYSTERY_CONVERSION = CreateEmiPlugin.register("mystery_conversion", (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)AllBlocks.PECULIAR_BELL.get())));

    public void register(EmiRegistry registry) {
        if (!ModConfig.get().create_emi && ModCompat.CREATE) {
            return;
        }
        registry.removeEmiStacks(s -> {
            TagDependentIngredientItem tagDependent;
            Object key = s.getKey();
            Item item = s.getItemStack().m_41720_();
            if (key instanceof TagDependentIngredientItem && (tagDependent = (TagDependentIngredientItem)key).shouldHide()) {
                return true;
            }
            if (HiddenItems.getHiddenPredicate().test(item)) {
                return true;
            }
            return key instanceof VirtualFluid;
        });
        registry.addGenericExclusionArea((screen, consumer) -> {
            if (screen instanceof AbstractSimiContainerScreen) {
                AbstractSimiContainerScreen simi = (AbstractSimiContainerScreen)screen;
                simi.getExtraAreas().forEach(r -> consumer.accept(new Bounds(r.m_110085_(), r.m_110086_(), r.m_110090_(), r.m_110091_())));
            }
        });
        registry.addRecipeHandler((MenuType)AllMenuTypes.CRAFTING_BLUEPRINT.get(), (EmiRecipeHandler)new BlueprintTransferHandler());
        registry.addDragDropHandler(FilterScreen.class, new GhostIngredientHandler());
        registry.addDragDropHandler(AttributeFilterScreen.class, new GhostIngredientHandler());
        registry.addDragDropHandler(BlueprintScreen.class, new GhostIngredientHandler());
        registry.addDragDropHandler(LinkedControllerScreen.class, new GhostIngredientHandler());
        registry.addDragDropHandler(ScheduleScreen.class, new GhostIngredientHandler());
        this.registerGeneratedRecipes(registry);
        ALL.forEach((id, category) -> registry.addCategory(category));
        registry.addWorkstation(MILLING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MILLSTONE.get())));
        registry.addWorkstation(CRUSHING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.CRUSHING_WHEEL.get())));
        registry.addWorkstation(SANDPAPER_POLISHING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllItems.SAND_PAPER.get())));
        registry.addWorkstation(SANDPAPER_POLISHING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllItems.RED_SAND_PAPER.get())));
        registry.addWorkstation(PRESSING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_PRESS.get())));
        registry.addWorkstation(FAN_WASHING, (EmiIngredient)FanEmiRecipe.getFan("fan_washing"));
        registry.addWorkstation(FAN_SMOKING, (EmiIngredient)FanEmiRecipe.getFan("fan_smoking"));
        registry.addWorkstation(FAN_BLASTING, (EmiIngredient)FanEmiRecipe.getFan("fan_blasting"));
        registry.addWorkstation(FAN_HAUNTING, (EmiIngredient)FanEmiRecipe.getFan("fan_haunting"));
        registry.addWorkstation(MIXING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_MIXER.get())));
        registry.addWorkstation(MIXING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.BASIN.get())));
        registry.addWorkstation(AUTOMATIC_SHAPELESS, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_MIXER.get())));
        registry.addWorkstation(AUTOMATIC_SHAPELESS, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.BASIN.get())));
        registry.addWorkstation(AUTOMATIC_BREWING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_MIXER.get())));
        registry.addWorkstation(AUTOMATIC_BREWING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.BASIN.get())));
        registry.addWorkstation(SAWING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_SAW.get())));
        registry.addWorkstation(BLOCK_CUTTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_SAW.get())));
        registry.addWorkstation(WOOD_CUTTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_SAW.get())));
        registry.addWorkstation(PACKING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_PRESS.get())));
        registry.addWorkstation(PACKING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.BASIN.get())));
        registry.addWorkstation(AUTOMATIC_PACKING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_PRESS.get())));
        registry.addWorkstation(AUTOMATIC_PACKING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.BASIN.get())));
        registry.addWorkstation(DEPLOYING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.DEPLOYER.get())));
        registry.addWorkstation(SPOUT_FILLING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.SPOUT.get())));
        registry.addWorkstation(DRAINING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.ITEM_DRAIN.get())));
        registry.addWorkstation(AUTOMATIC_SHAPED, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_CRAFTER.get())));
        registry.addWorkstation(MECHANICAL_CRAFTING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AllBlocks.MECHANICAL_CRAFTER.get())));
        RecipeManager manager = registry.getRecipeManager();
        List millingRecipes = manager.m_44013_(AllRecipeTypes.MILLING.getType());
        List crushingRecipes = manager.m_44013_(AllRecipeTypes.CRUSHING.getType());
        List smokingRecipes = manager.m_44013_(RecipeType.f_44110_);
        List blastingRecipes = manager.m_44013_(RecipeType.f_44109_);
        for (CrushingRecipe crushingRecipe : crushingRecipes) {
            registry.addRecipe((EmiRecipe)new CrushingEmiRecipe((AbstractCrushingRecipe)crushingRecipe));
        }
        block1: for (MillingRecipe millingRecipe : millingRecipes) {
            registry.addRecipe((EmiRecipe)new MillingEmiRecipe(millingRecipe));
            for (CrushingRecipe crush : crushingRecipes) {
                if (!CreateEmiPlugin.doInputsMatch(millingRecipe, crush)) continue;
                continue block1;
            }
            registry.addRecipe((EmiRecipe)new CrushingEmiRecipe((AbstractCrushingRecipe)millingRecipe));
        }
        this.addAll(registry, AllRecipeTypes.SANDPAPER_POLISHING, PolishingEmiRecipe::new);
        this.addAll(registry, AllRecipeTypes.PRESSING, PressingEmiRecipe::new);
        for (SmokingRecipe smokingRecipe : smokingRecipes) {
            registry.addRecipe((EmiRecipe)new FanSmokingEmiRecipe(smokingRecipe));
        }
        block4: for (AbstractCookingRecipe abstractCookingRecipe : manager.m_44013_(RecipeType.f_44108_)) {
            for (AbstractCookingRecipe smoking : smokingRecipes) {
                if (!CreateEmiPlugin.doInputsMatch(abstractCookingRecipe, smoking)) continue;
                continue block4;
            }
            for (AbstractCookingRecipe blasting : blastingRecipes) {
                if (!CreateEmiPlugin.doInputsMatch(abstractCookingRecipe, blasting)) continue;
                continue block4;
            }
            registry.addRecipe((EmiRecipe)new FanBlastingEmiRecipe(abstractCookingRecipe));
        }
        for (AbstractCookingRecipe abstractCookingRecipe : blastingRecipes) {
            registry.addRecipe((EmiRecipe)new FanBlastingEmiRecipe(abstractCookingRecipe));
        }
        this.addAll(registry, AllRecipeTypes.SPLASHING, FanWashingEmiRecipe::new);
        this.addAll(registry, AllRecipeTypes.HAUNTING, FanHauntingEmiRecipe::new);
        this.addAll(registry, AllRecipeTypes.MIXING, MIXING, MixingEmiRecipe::new);
        for (CraftingRecipe craftingRecipe : manager.m_44013_(RecipeType.f_44107_)) {
            if (!(craftingRecipe instanceof ShapelessRecipe) || MechanicalPressBlockEntity.canCompress((Recipe)craftingRecipe) || AllRecipeTypes.shouldIgnoreInAutomation((Recipe)craftingRecipe) || craftingRecipe.m_7527_().size() <= 1) continue;
            registry.addRecipe((EmiRecipe)new ShapelessEmiRecipe(AUTOMATIC_SHAPELESS, BasinRecipe.convertShapeless((Recipe)craftingRecipe)));
        }
        for (MixingRecipe mixingRecipe : PotionMixingRecipes.ALL) {
            registry.addRecipe((EmiRecipe)new MixingEmiRecipe(AUTOMATIC_BREWING, (BasinRecipe)mixingRecipe));
        }
        this.addAll(registry, AllRecipeTypes.CUTTING, SawingEmiRecipe::new);
        for (BlockCuttingEmiRecipe.CondensedBlockCuttingRecipe condensedBlockCuttingRecipe : BlockCuttingEmiRecipe.CondensedBlockCuttingRecipe.condenseRecipes(manager.m_44013_(RecipeType.f_44112_).stream().filter(r -> !AllRecipeTypes.shouldIgnoreInAutomation((Recipe)r)).toList(), "block_cutting")) {
            registry.addRecipe((EmiRecipe)new BlockCuttingEmiRecipe(BLOCK_CUTTING, condensedBlockCuttingRecipe));
        }
        this.addAll(registry, AllRecipeTypes.COMPACTING, PackingEmiRecipe::new);
        for (CraftingRecipe craftingRecipe : manager.m_44013_(RecipeType.f_44107_)) {
            if (craftingRecipe instanceof MechanicalCraftingRecipe || !MechanicalPressBlockEntity.canCompress((Recipe)craftingRecipe) || AllRecipeTypes.shouldIgnoreInAutomation((Recipe)craftingRecipe)) continue;
            registry.addRecipe((EmiRecipe)new AutomaticPackingEmiRecipe(BasinRecipe.convertShapeless((Recipe)craftingRecipe)));
        }
        this.addAll(registry, AllRecipeTypes.DEPLOYING, DeployingEmiRecipe::new);
        this.addAll(registry, AllRecipeTypes.SANDPAPER_POLISHING, DeployingEmiRecipe::fromSandpaper);
        this.addAll(registry, AllRecipeTypes.ITEM_APPLICATION, DeployingEmiRecipe::fromItemApplication);
        for (ConversionRecipe conversionRecipe : MysteriousConversionEmiRecipe.RECIPES) {
            registry.addRecipe((EmiRecipe)new MysteriousConversionEmiRecipe(conversionRecipe));
        }
        this.addAll(registry, AllRecipeTypes.FILLING, SpoutEmiRecipe::new);
        this.addAll(registry, AllRecipeTypes.EMPTYING, DrainEmiRecipe::new);
        this.addAll(registry, AllRecipeTypes.SEQUENCED_ASSEMBLY, SequencedAssemblyEmiRecipe::new);
        this.addAll(registry, AllRecipeTypes.ITEM_APPLICATION, ManualItemApplicationEmiRecipe::new);
        this.addAll(registry, AllRecipeTypes.MECHANICAL_CRAFTING, MECHANICAL_CRAFTING, MechanicalCraftingEmiRecipe::new);
        this.addLavaCollision(registry, AllFluids.HONEY, AllPaletteStoneTypes.LIMESTONE);
        this.addLavaCollision(registry, AllFluids.CHOCOLATE, AllPaletteStoneTypes.SCORIA);
        registry.addDeferredRecipes(this::addDeferredRecipes);
    }

    private <T extends Recipe<?>> void addAll(EmiRegistry registry, AllRecipeTypes type, Function<T, EmiRecipe> constructor) {
        for (Recipe recipe : registry.getRecipeManager().m_44013_(type.getType())) {
            registry.addRecipe(constructor.apply(recipe));
        }
    }

    private <T extends Recipe<?>> void addAll(EmiRegistry registry, AllRecipeTypes type, EmiRecipeCategory category, BiFunction<EmiRecipeCategory, T, EmiRecipe> constructor) {
        for (Recipe recipe : registry.getRecipeManager().m_44013_(type.getType())) {
            registry.addRecipe(constructor.apply(category, (EmiRecipeCategory)recipe));
        }
    }

    private void addLavaCollision(EmiRegistry registry, FluidEntry<?> fluid, AllPaletteStoneTypes outputType) {
        EmiStack lava = EmiStack.of((Fluid)Fluids.f_76195_);
        lava = lava.setRemainder(lava);
        EmiStack fluidStack = EmiStack.of((Fluid)((ForgeFlowingFluid)fluid.get()).m_5613_());
        fluidStack = fluidStack.setRemainder(fluidStack);
        Block block = (Block)outputType.getBaseBlock().get();
        EmiStack output = EmiStack.of((ItemLike)block);
        String blockName = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(CreateEmiPlugin.synthetic("emi/fluid_interaction/" + blockName)).leftInput((EmiIngredient)fluidStack).rightInput((EmiIngredient)lava, false).output(output).build());
    }

    private static ResourceLocation synthetic(String path) {
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("Starting slash is added automatically");
        }
        return Create.asResource((String)("/" + path));
    }

    private void addDeferredRecipes(Consumer<EmiRecipe> consumer) {
        List<Fluid> fluids = EmiApi.getIndexStacks().stream().filter(s -> s.getKey() instanceof Fluid).map(s -> (Fluid)s.getKey()).distinct().toList();
        for (EmiStack stack : EmiApi.getIndexStacks()) {
            Object object = stack.getKey();
            if (!(object instanceof Item)) continue;
            Item i = (Item)object;
            ItemStack is = stack.getItemStack();
            if (!(i instanceof PotionItem)) continue;
            FluidStack potion = PotionFluidHandler.getFluidFromPotionItem((ItemStack)is);
            Ingredient bottle = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_});
            ResourceLocation iid = Registry.f_122827_.m_7981_((Object)i);
            ResourceLocation pid = Registry.f_122828_.m_7981_((Object)PotionUtils.m_43579_((ItemStack)is));
            consumer.accept(new SpoutEmiRecipe((FillingRecipe)new ProcessingRecipeBuilder(FillingRecipe::new, new ResourceLocation("emi", "create/potion_filling/" + pid.m_135827_() + "/" + pid.m_135815_() + "/from/" + iid.m_135827_() + "/" + iid.m_135815_())).withItemIngredients(new Ingredient[]{bottle}).withFluidIngredients(new FluidIngredient[]{FluidIngredient.fromFluidStack((FluidStack)potion)}).withSingleItemOutput(is.m_41777_()).build()));
            consumer.accept(new DrainEmiRecipe((EmptyingRecipe)new ProcessingRecipeBuilder(EmptyingRecipe::new, new ResourceLocation("emi", "create/potion_draining/" + pid.m_135827_() + "/" + pid.m_135815_() + "/from/" + iid.m_135827_() + "/" + iid.m_135815_())).withItemIngredients(new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{is})}).withFluidOutputs(new FluidStack[]{potion}).withSingleItemOutput(new ItemStack((ItemLike)Items.f_42590_)).build()));
        }
    }

    public void registerGeneratedRecipes(EmiRegistry registry) {
        ToolboxColoringRecipeMaker.createRecipes().forEach(r -> {
            ItemStack toolbox = null;
            ItemStack dye = null;
            block0: for (Ingredient ingredient : r.m_7527_()) {
                for (ItemStack stack : ingredient.m_43908_()) {
                    BlockItem block;
                    Item patt0$temp;
                    if (toolbox == null && (patt0$temp = stack.m_41720_()) instanceof BlockItem && (block = (BlockItem)patt0$temp).m_40614_() instanceof ToolboxBlock) {
                        toolbox = stack;
                    } else if (dye == null && stack.m_41720_() instanceof DyeItem) {
                        dye = stack;
                    }
                    if (toolbox != null && dye != null) continue block0;
                }
            }
            if (toolbox == null || dye == null) {
                return;
            }
            ResourceLocation toolboxId = Registry.f_122827_.m_7981_((Object)toolbox.m_41720_());
            ResourceLocation dyeId = Registry.f_122827_.m_7981_((Object)dye.m_41720_());
            String recipeName = "create/toolboxes/%s/%s/%s/%s".formatted(toolboxId.m_135827_(), toolboxId.m_135815_(), dyeId.m_135827_(), dyeId.m_135815_());
            registry.addRecipe((EmiRecipe)new EmiCraftingRecipe(r.m_7527_().stream().map(EmiIngredient::of).toList(), EmiStack.of((ItemStack)r.m_8043_()), new ResourceLocation("emi", recipeName)));
        });
    }

    public static boolean doInputsMatch(Recipe<?> a, Recipe<?> b) {
        ItemStack[] matchingStacks;
        return !a.m_7527_().isEmpty() && !b.m_7527_().isEmpty() && (matchingStacks = ((Ingredient)a.m_7527_().get(0)).m_43908_()).length != 0 && ((Ingredient)b.m_7527_().get(0)).test(matchingStacks[0]);
    }

    private static EmiRecipeCategory register(String name, EmiRenderable icon) {
        ResourceLocation id = Create.asResource((String)name);
        EmiRecipeCategory category = new EmiRecipeCategory(id, icon);
        ALL.put(id, category);
        return category;
    }
}

