/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.emi;

import com.simibubi.create.compat.emi.CreateEmiAnimations;
import com.simibubi.create.compat.emi.recipes.CreateEmiRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.Lang;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EmiSequencedAssemblySubCategory {
    private final int width;

    public EmiSequencedAssemblySubCategory(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public abstract void addWidgets(WidgetHolder var1, int var2, int var3, SequencedRecipe<?> var4, int var5);

    @Nullable
    public EmiIngredient getAppliedIngredient(SequencedRecipe<?> recipe) {
        return null;
    }

    public static BiFunction<Integer, Integer, List<ClientTooltipComponent>> getTooltip(SequencedRecipe<?> recipe, int index) {
        return (mouseX, mouseY) -> List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Lang.translateDirect((String)"recipe.assembly.step", (Object[])new Object[]{index + 1}).m_7532_()), ClientTooltipComponent.m_169948_((FormattedCharSequence)recipe.getAsAssemblyRecipe().getDescriptionForAssembly().m_6879_().m_130940_(ChatFormatting.DARK_GREEN).m_7532_()));
    }

    public static class AssemblyCutting
    extends EmiSequencedAssemblySubCategory {
        public AssemblyCutting() {
            super(25);
        }

        @Override
        public void addWidgets(WidgetHolder widgets, int x, int y, SequencedRecipe<?> recipe, int index) {
            widgets.addDrawable(x, y, this.getWidth(), 96, (matrices, mouseX, mouseY, delta) -> {
                matrices.m_85837_(0.0, 54.5, 0.0);
                float scale = 0.6f;
                matrices.m_85841_(scale, scale, scale);
                matrices.m_85837_((double)(this.getWidth() / 2), 30.0, 0.0);
                CreateEmiAnimations.renderSaw(matrices, index);
            }).tooltip(AssemblyCutting.getTooltip(recipe, index));
        }
    }

    public static class AssemblyDeploying
    extends EmiSequencedAssemblySubCategory {
        public AssemblyDeploying() {
            super(25);
        }

        @Override
        @NotNull
        public EmiIngredient getAppliedIngredient(SequencedRecipe<?> recipe) {
            return EmiIngredient.of((Ingredient)((Ingredient)recipe.getRecipe().m_7527_().get(1)));
        }

        @Override
        public void addWidgets(WidgetHolder widgets, int x, int y, SequencedRecipe<?> recipe, int index) {
            DeployerApplicationRecipe deploy;
            EmiIngredient ingredient = this.getAppliedIngredient(recipe);
            IAssemblyRecipe iAssemblyRecipe = recipe.getAsAssemblyRecipe();
            if (iAssemblyRecipe instanceof DeployerApplicationRecipe && (deploy = (DeployerApplicationRecipe)iAssemblyRecipe).shouldKeepHeldItem()) {
                for (EmiStack stack : ingredient.getEmiStacks()) {
                    stack.setRemainder(stack);
                }
            }
            CreateEmiRecipe.addSlot(widgets, ingredient, x + 3, y + 13);
            widgets.addDrawable(x, y, this.getWidth(), 96, (matrices, mouseX, mouseY, delta) -> {
                float scale = 0.75f;
                matrices.m_85837_(3.0, 54.0, 0.0);
                matrices.m_85841_(scale, scale, scale);
                CreateEmiAnimations.renderDeployer(matrices, index);
            }).tooltip(AssemblyDeploying.getTooltip(recipe, index));
        }
    }

    public static class AssemblySpouting
    extends EmiSequencedAssemblySubCategory {
        public AssemblySpouting() {
            super(25);
        }

        @Override
        @NotNull
        public EmiIngredient getAppliedIngredient(SequencedRecipe<?> recipe) {
            FluidStack fluid = (FluidStack)((FluidIngredient)recipe.getRecipe().getFluidIngredients().get(0)).getMatchingFluidStacks().get(0);
            return CreateEmiRecipe.fluidStack(fluid);
        }

        @Override
        public void addWidgets(WidgetHolder widgets, int x, int y, SequencedRecipe<?> recipe, int index) {
            CreateEmiRecipe.addSlot(widgets, this.getAppliedIngredient(recipe), x + 3, y + 13);
            widgets.addDrawable(x, y, this.getWidth(), 96, (matrices, mouseX, mouseY, delta) -> {
                float scale = 0.75f;
                matrices.m_85837_(3.0, 54.0, 0.0);
                matrices.m_85841_(scale, scale, scale);
                CreateEmiAnimations.renderSpout(matrices, index, ((FluidIngredient)recipe.getRecipe().getFluidIngredients().get(0)).getMatchingFluidStacks());
            }).tooltip(AssemblySpouting.getTooltip(recipe, index));
        }
    }

    public static class AssemblyPressing
    extends EmiSequencedAssemblySubCategory {
        public AssemblyPressing() {
            super(25);
        }

        @Override
        public void addWidgets(WidgetHolder widgets, int x, int y, SequencedRecipe<?> recipe, int index) {
            widgets.addDrawable(x, y, this.getWidth(), 96, (matrices, mouseX, mouseY, delta) -> {
                float scale = 0.6f;
                matrices.m_85837_(3.0, 54.0, 0.0);
                matrices.m_85841_(scale, scale, scale);
                CreateEmiAnimations.renderPress(matrices, index, false);
            }).tooltip(AssemblyPressing.getTooltip(recipe, index));
        }
    }
}

