/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry;

import cc.cassian.raspberry.ModCompat;
import cc.cassian.raspberry.client.config.ModConfigFactory;
import cc.cassian.raspberry.compat.AquacultureCompat;
import cc.cassian.raspberry.compat.CopperizedCompat;
import cc.cassian.raspberry.compat.EnvironmentalCompat;
import cc.cassian.raspberry.compat.NeapolitanCompat;
import cc.cassian.raspberry.compat.QuarkCompat;
import cc.cassian.raspberry.compat.oreganized.OreganizedEvents;
import cc.cassian.raspberry.compat.oreganized.network.RaspberryOreganizedNetwork;
import cc.cassian.raspberry.config.ModConfig;
import cc.cassian.raspberry.registry.RaspberryAttributes;
import cc.cassian.raspberry.registry.RaspberryBlocks;
import cc.cassian.raspberry.registry.RaspberryItems;
import cc.cassian.raspberry.registry.RasperryMobEffects;
import com.teamabnormals.blueprint.common.world.storage.tracking.DataProcessors;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataProcessor;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.tuples.Pair;

@Mod(value="raspberry")
public final class RaspberryMod {
    public static final String MOD_ID = "raspberry";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"raspberry");
    public static final TrackedData<Integer> WORM_HUNTING_TIME = TrackedData.Builder.create((IDataProcessor)DataProcessors.INT, () -> 0).enableSaving().build();
    public static final TrackedData<Integer> SNIFF_SOUND_TIME = TrackedData.Builder.create((IDataProcessor)DataProcessors.INT, () -> 0).build();
    public static final TrackedData<BlockPos> WORM_POS = TrackedData.Builder.create((IDataProcessor)DataProcessors.POS, () -> BlockPos.f_121853_).enableSaving().build();
    public static final TrackedData<Boolean> HAS_WORM_TARGET = TrackedData.Builder.create((IDataProcessor)DataProcessors.BOOLEAN, () -> false).enableSaving().build();
    public static final TrackedData<Boolean> LOOKING_FOR_WORM = TrackedData.Builder.create((IDataProcessor)DataProcessors.BOOLEAN, () -> false).build();

    public RaspberryMod(FMLJavaModLoadingContext context) {
        IEventBus eventBus = context.getModEventBus();
        ModConfig.load();
        RaspberryBlocks.register(eventBus);
        RaspberryItems.ITEMS.register(eventBus);
        RasperryMobEffects.MOB_EFFECTS.register(eventBus);
        MinecraftForge.EVENT_BUS.addListener(this::onItemTooltipEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteract);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinLevel);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingUpdate);
        eventBus.addListener(RaspberryMod::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(RaspberryMod::playerTick);
        MinecraftForge.EVENT_BUS.addListener(RaspberryMod::lightningTick);
        if (ModCompat.OREGANIZED) {
            RaspberryAttributes.ATTRIBUTES.register(eventBus);
            RaspberryOreganizedNetwork.register();
            MinecraftForge.EVENT_BUS.addListener(OreganizedEvents::onItemAttributes);
        }
        if (FMLEnvironment.dist.isClient()) {
            RaspberryMod.registerModsPage(context);
        }
        TrackedDataManager.INSTANCE.registerData(RaspberryMod.locate("truffle_hunting_time"), WORM_HUNTING_TIME);
        TrackedDataManager.INSTANCE.registerData(RaspberryMod.locate("sniff_sound_time"), SNIFF_SOUND_TIME);
        TrackedDataManager.INSTANCE.registerData(RaspberryMod.locate("truffle_pos"), WORM_POS);
        TrackedDataManager.INSTANCE.registerData(RaspberryMod.locate("has_truffle_target"), HAS_WORM_TARGET);
        TrackedDataManager.INSTANCE.registerData(RaspberryMod.locate("looking_for_truffle"), LOOKING_FOR_WORM);
    }

    public static ResourceLocation locate(String id) {
        return RaspberryMod.identifier(MOD_ID, id);
    }

    public static ResourceLocation identifier(String namespace, String id) {
        return new ResourceLocation(namespace, id);
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        if (ModCompat.NEAPOLITAN) {
            NeapolitanCompat.boostAgility();
        }
        if (ModCompat.QUARK) {
            QuarkCompat.register();
        }
        for (Pair<RegistryObject<Block>, RegistryObject<BlockItem>> foliageBlock : RaspberryBlocks.FOLIAGE_BLOCKS) {
            ComposterBlock.f_51914_.put((Object)((ItemLike)((RegistryObject)foliageBlock.getB()).get()), 0.3f);
        }
    }

    @SubscribeEvent
    public static void lightningTick(EntityStruckByLightningEvent event) {
        if (ModCompat.COPPERIZED && !ModCompat.COFH_CORE && ModConfig.get().aftershock) {
            CopperizedCompat.electrify(event);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (ModCompat.COPPERIZED && ModCompat.COFH_CORE) {
            CopperizedCompat.resist(event);
        }
    }

    public static void registerModsPage(FMLJavaModLoadingContext context) {
        if (ModCompat.CLOTH_CONFIG) {
            context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(ModConfigFactory::createScreen));
        }
    }

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        if (ModCompat.AQUACULTURE) {
            AquacultureCompat.checkAndAddTooltip(event);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (ModCompat.ENVIRONMENTAL) {
            EnvironmentalCompat.onEntityInteract(event);
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (ModCompat.ENVIRONMENTAL) {
            EnvironmentalCompat.onEntityJoinWorld(event);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (ModCompat.ENVIRONMENTAL) {
            EnvironmentalCompat.onLivingUpdate(event);
        }
    }
}

