/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat;

import cc.cassian.raspberry.RaspberryMod;
import cc.cassian.raspberry.entity.ai.goal.HuntWormGoal;
import cc.cassian.raspberry.registry.RaspberryBlocks;
import cc.cassian.raspberry.registry.RaspberryTags;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.environmental.core.other.EnvironmentalProperties;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.RegistryObject;

public class EnvironmentalCompat {
    public static BlockBehaviour.Properties getTruffleProperties() {
        return EnvironmentalProperties.BURIED_TRUFFLE;
    }

    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Level level = event.getLevel();
        RandomSource random = level.m_213780_();
        if (target.m_6095_().m_204039_(RaspberryTags.WORM_SEEKERS) && target.m_6084_() && target instanceof Animal) {
            Animal seeker = (Animal)target;
            IDataManager data = (IDataManager)target;
            if (!seeker.m_21523_() && stack.m_204117_(RaspberryTags.WORM_SEEKER_ITEMS) && !seeker.m_6162_() && (Integer)data.getValue(RaspberryMod.WORM_HUNTING_TIME) == 0) {
                if (level.m_6042_().f_63858_()) {
                    data.setValue(RaspberryMod.WORM_HUNTING_TIME, (Object)4800);
                    if (!event.getEntity().m_7500_()) {
                        stack.m_41774_(1);
                    }
                    if (level.m_5776_()) {
                        for (int i = 0; i < 7; ++i) {
                            double d0 = random.m_188583_() * 0.02;
                            double d1 = random.m_188583_() * 0.02;
                            double d2 = random.m_188583_() * 0.02;
                            level.m_7106_((ParticleOptions)EnvironmentalParticleTypes.PIG_FINDS_TRUFFLE.get(), target.m_20208_(1.0), target.m_20187_() + 0.5, target.m_20262_(1.0), d0, d1, d2);
                        }
                    }
                } else if (level.m_5776_()) {
                    for (int i = 0; i < 7; ++i) {
                        double d0 = random.m_188583_() * 0.02;
                        double d1 = random.m_188583_() * 0.02;
                        double d2 = random.m_188583_() * 0.02;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, target.m_20208_(1.0), target.m_20187_() + 0.5, target.m_20262_(1.0), d0, d1, d2);
                    }
                }
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                event.setCanceled(true);
            }
        }
    }

    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_6095_().m_204039_(RaspberryTags.WORM_SEEKERS) && entity instanceof Animal) {
            Animal seeker = (Animal)entity;
            Set goals = seeker.f_21345_.m_148105_();
            if (goals.stream().noneMatch(goal -> goal.m_26015_() instanceof HuntWormGoal)) {
                seeker.f_21345_.m_25352_(2, (Goal)new HuntWormGoal(seeker));
            }
        }
    }

    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_20193_();
        RandomSource random = level.m_213780_();
        if (entity.m_6095_().m_204039_(RaspberryTags.WORM_SEEKERS) && entity.m_6084_()) {
            IDataManager data = (IDataManager)entity;
            int huntingtime = (Integer)data.getValue(RaspberryMod.WORM_HUNTING_TIME);
            BlockPos wormpos = (BlockPos)data.getValue(RaspberryMod.WORM_POS);
            if (huntingtime == 0 || ((Boolean)data.getValue(RaspberryMod.HAS_WORM_TARGET)).booleanValue() && level.m_8055_(wormpos).m_60734_() != ((RegistryObject)RaspberryBlocks.WORMY_DIRT.getA()).get()) {
                data.setValue(RaspberryMod.HAS_WORM_TARGET, (Object)false);
                if (huntingtime > 0) {
                    data.setValue(RaspberryMod.WORM_HUNTING_TIME, (Object)Math.max(-400, -huntingtime));
                }
            } else if (huntingtime > 0) {
                data.setValue(RaspberryMod.WORM_HUNTING_TIME, (Object)(huntingtime - 1));
            } else {
                data.setValue(RaspberryMod.WORM_HUNTING_TIME, (Object)(huntingtime + 1));
                if (level.m_5776_() && ((Boolean)data.getValue(RaspberryMod.HAS_WORM_TARGET)).booleanValue() && huntingtime % 10 == 0) {
                    double d0 = random.m_188583_() * 0.02;
                    double d1 = random.m_188583_() * 0.02;
                    double d2 = random.m_188583_() * 0.02;
                    level.m_7106_((ParticleOptions)EnvironmentalParticleTypes.PIG_FINDS_TRUFFLE.get(), entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
                }
            }
            int sniffsoundtime = (Integer)data.getValue(RaspberryMod.SNIFF_SOUND_TIME);
            data.setValue(RaspberryMod.SNIFF_SOUND_TIME, (Object)(sniffsoundtime + 1));
            if (!level.m_5776_() && ((Boolean)data.getValue(RaspberryMod.LOOKING_FOR_WORM)).booleanValue() && random.m_188503_(90) < sniffsoundtime) {
                ((Mob)entity).m_8032_();
                data.setValue(RaspberryMod.SNIFF_SOUND_TIME, (Object)-90);
            }
        }
    }
}

