/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.emi;

import cc.cassian.raspberry.RaspberryMod;
import cofh.ensorcellation.init.EnsorcEnchantments;
import com.brokenkeyboard.usefulspyglass.UsefulSpyglass;
import com.github.alexthe668.domesticationinnovation.server.enchantment.DIEnchantmentRegistry;
import com.github.alexthe668.domesticationinnovation.server.item.DIItemRegistry;
import com.simibubi.create.AllItems;
import com.teamabnormals.allurement.core.registry.AllurementEnchantments;
import de.cadentem.additional_enchantments.registry.AEEnchantments;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.miningmaster.init.MMEnchantments;
import vectorwing.farmersdelight.common.registry.ModEnchantments;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class EmiSmithingRecipe
implements EmiRecipe {
    private final EmiIngredient input1;
    private final EmiStack input2;
    private final EmiStack output;
    private final ResourceLocation id;
    private final int uniq = EmiUtil.RANDOM.nextInt();

    public EmiSmithingRecipe(EmiIngredient input1, EmiStack input2, EmiStack output, ResourceLocation id) {
        this.input1 = input1;
        this.input2 = input2;
        this.output = output;
        this.id = id;
    }

    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.SMITHING;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input1, this.input2);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public int getDisplayWidth() {
        return 125;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.PLUS, 27, 3);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 75, 1);
        widgets.addGeneratedSlot(r -> this.input1, this.uniq, 0, 0);
        widgets.addSlot((EmiIngredient)this.input2, 49, 0);
        widgets.addGeneratedSlot(r -> this.output, this.uniq, 107, 0).recipeContext((EmiRecipe)this);
    }

    public static void addEnchantments(EmiRegistry emiRegistry) {
        Item EVERLASTING = EmiSmithingRecipe.get("everlasting");
        Item AQUATIC = EmiSmithingRecipe.get("aquatic");
        Item BEASTLY = EmiSmithingRecipe.get("beastly");
        Item CYCLIC = EmiSmithingRecipe.get("cyclic");
        Item FLINGING = EmiSmithingRecipe.get("flinging");
        Item ENDURING = EmiSmithingRecipe.get("enduring");
        Item FROST = EmiSmithingRecipe.get("glacial");
        Item HALLOWED = EmiSmithingRecipe.get("hallowed");
        Item HAUNTED = EmiSmithingRecipe.get("haunted");
        Item HEAVY = EmiSmithingRecipe.get("heavy");
        Item INFESTED = EmiSmithingRecipe.get("infested");
        Item OTHERWORLDLY = EmiSmithingRecipe.get("otherworldly");
        Item PIERCING = EmiSmithingRecipe.get("piercing");
        Item PULLING = EmiSmithingRecipe.get("pulling");
        Item SILENT = EmiSmithingRecipe.get("silent");
        Item SWIFT = EmiSmithingRecipe.get("swift");
        Enchantment GUARD_BREAK = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_214293_((String)"kubejs", (String)"guard_break"));
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getArmour(), (TagKey<Item>)Tags.Items.ARMORS, Enchantments.f_44986_, EVERLASTING, "everlasting_armour");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getTools(), (TagKey<Item>)Tags.Items.TOOLS, Enchantments.f_44986_, EVERLASTING, "everlasting_tools");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42468_, Items.f_42468_, Enchantments.f_44970_, AQUATIC, "respiration_helmet");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)AllItems.COPPER_BACKTANK.get(), (Item)AllItems.COPPER_BACKTANK.get(), Enchantments.f_44970_, AQUATIC, "respiration_backtank");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getBoots(), (TagKey<Item>)Tags.Items.ARMORS_BOOTS, Enchantments.f_44973_, AQUATIC, "depth_strider_boots");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)DIItemRegistry.COLLAR_TAG.get(), (Item)DIItemRegistry.COLLAR_TAG.get(), (Enchantment)DIEnchantmentRegistry.AMPHIBIOUS, AQUATIC, "amphibious");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getSword(), (TagKey<Item>)Tags.Items.TOOLS_SWORDS, (Enchantment)EnsorcEnchantments.CAVALIER.get(), BEASTLY, "cavalier_sword");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42391_, (TagKey<Item>)Tags.Items.TOOLS_AXES, (Enchantment)EnsorcEnchantments.CAVALIER.get(), BEASTLY, "cavalier_axe");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getLeggings(), (TagKey<Item>)Tags.Items.ARMORS_LEGGINGS, (Enchantment)MMEnchantments.KNIGHT_JUMP.get(), BEASTLY, "multi_leap");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)DIItemRegistry.COLLAR_TAG.get(), (Item)DIItemRegistry.COLLAR_TAG.get(), (Enchantment)DIEnchantmentRegistry.INTIMIDATION, BEASTLY, "intimidation");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getSword(), (TagKey<Item>)Tags.Items.TOOLS_SWORDS, Enchantments.f_44983_, CYCLIC, "sweeping_edge");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42713_, (TagKey<Item>)Tags.Items.TOOLS_TRIDENTS, Enchantments.f_44957_, CYCLIC, "riptide");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getArmour(), (TagKey<Item>)Tags.Items.ARMORS, (Enchantment)AllurementEnchantments.VENGEANCE.get(), CYCLIC, "vengeance");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getArmour(), (TagKey<Item>)Tags.Items.ARMORS, (Enchantment)EnsorcEnchantments.VITALITY.get(), ENDURING, "vitality");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)DIItemRegistry.COLLAR_TAG.get(), (Item)DIItemRegistry.COLLAR_TAG.get(), (Enchantment)DIEnchantmentRegistry.HEALTH_BOOST, ENDURING, "health_boost");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getSword(), (TagKey<Item>)Tags.Items.TOOLS_SWORDS, (Enchantment)AllurementEnchantments.LAUNCH.get(), FLINGING, "launch_sword");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42391_, (TagKey<Item>)Tags.Items.TOOLS_AXES, (Enchantment)AllurementEnchantments.LAUNCH.get(), FLINGING, "launch_axe");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42411_, (TagKey<Item>)Tags.Items.TOOLS_BOWS, (Enchantment)EnsorcEnchantments.VOLLEY.get(), FLINGING, "volley_bow");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42717_, (TagKey<Item>)Tags.Items.TOOLS_CROSSBOWS, (Enchantment)EnsorcEnchantments.VOLLEY.get(), FLINGING, "volley_crossbow");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)DIItemRegistry.COLLAR_TAG.get(), (Item)DIItemRegistry.COLLAR_TAG.get(), (Enchantment)DIEnchantmentRegistry.DEFLECTION, FLINGING, "deflection");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getBoots(), (TagKey<Item>)Tags.Items.ARMORS_BOOTS, Enchantments.f_44974_, FROST, "frost_walker_boots");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42653_, Items.f_42653_, Enchantments.f_44974_, FROST, "frost_walker_horse_armour");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)DIItemRegistry.COLLAR_TAG.get(), (Item)DIItemRegistry.COLLAR_TAG.get(), (Enchantment)DIEnchantmentRegistry.FROST_FANG, FROST, "frost_fang");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getSword(), (TagKey<Item>)Tags.Items.TOOLS_SWORDS, Enchantments.f_44978_, HALLOWED, "smite_sword");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42391_, (TagKey<Item>)Tags.Items.TOOLS_AXES, Enchantments.f_44978_, HALLOWED, "smite_axe");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42713_, (TagKey<Item>)Tags.Items.TOOLS_TRIDENTS, Enchantments.f_44958_, HALLOWED, "channeling");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_151059_, Items.f_151059_, (Enchantment)UsefulSpyglass.MARKING.get(), HALLOWED, "silver_eye");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42411_, (TagKey<Item>)Tags.Items.TOOLS_BOWS, (Enchantment)AEEnchantments.HOMING.get(), HAUNTED, "soul_chaser_bow");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42717_, (TagKey<Item>)Tags.Items.TOOLS_CROSSBOWS, (Enchantment)AEEnchantments.HOMING.get(), HAUNTED, "soul_chaser_crossbow");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getBoots(), (TagKey<Item>)Tags.Items.ARMORS_BOOTS, Enchantments.f_44976_, HAUNTED, "soul_speed");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)DIItemRegistry.COLLAR_TAG.get(), (Item)DIItemRegistry.COLLAR_TAG.get(), (Enchantment)DIEnchantmentRegistry.TOTAL_RECALL, HAUNTED, "total_recall");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getSword(), (TagKey<Item>)Tags.Items.TOOLS_SWORDS, GUARD_BREAK, HEAVY, "guard_break_sword");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42391_, (TagKey<Item>)Tags.Items.TOOLS_AXES, GUARD_BREAK, HEAVY, "guard_break_axe");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getLeggings(), (TagKey<Item>)Tags.Items.ARMORS_LEGGINGS, (Enchantment)AEEnchantments.BRACEWALK.get(), HEAVY, "bracewalk");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getBoots(), (TagKey<Item>)Tags.Items.ARMORS_BOOTS, (Enchantment)AllurementEnchantments.SHOCKWAVE.get(), HEAVY, "shockwave");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getSword(), (TagKey<Item>)Tags.Items.TOOLS_SWORDS, Enchantments.f_44979_, INFESTED, "bane_sword");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42391_, (TagKey<Item>)Tags.Items.TOOLS_AXES, Enchantments.f_44979_, INFESTED, "bane_axe");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42717_, (TagKey<Item>)Tags.Items.TOOLS_CROSSBOWS, (Enchantment)AllurementEnchantments.SPREAD_OF_AILMENTS.get(), INFESTED, "spread_of_ailments");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42411_, Items.f_42411_, (Enchantment)ModRegistry.STASIS_ENCHANTMENT.get(), OTHERWORLDLY, "bracewalk_bow");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42717_, Items.f_42717_, (Enchantment)ModRegistry.STASIS_ENCHANTMENT.get(), OTHERWORLDLY, "bracewalk_crossbow");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)ModRegistry.BUBBLE_BLOWER.get(), (Item)ModRegistry.BUBBLE_BLOWER.get(), (Enchantment)ModRegistry.STASIS_ENCHANTMENT.get(), OTHERWORLDLY, "bracewalk_bubble");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42473_, (TagKey<Item>)Tags.Items.ARMORS_CHESTPLATES, (Enchantment)EnsorcEnchantments.DISPLACEMENT.get(), OTHERWORLDLY, "displacement");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)DIItemRegistry.COLLAR_TAG.get(), (Item)DIItemRegistry.COLLAR_TAG.get(), (Enchantment)DIEnchantmentRegistry.TETHERED_TELEPORT, OTHERWORLDLY, "tethered_teleport");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42411_, (TagKey<Item>)Tags.Items.TOOLS_BOWS, (Enchantment)EnsorcEnchantments.TRUESHOT.get(), PIERCING, "trueshot_bow");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42717_, (TagKey<Item>)Tags.Items.TOOLS_CROSSBOWS, (Enchantment)EnsorcEnchantments.TRUESHOT.get(), PIERCING, "trueshot_crossbow");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42713_, (TagKey<Item>)Tags.Items.TOOLS_TRIDENTS, Enchantments.f_44956_, PIERCING, "impaling");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42717_, (TagKey<Item>)Tags.Items.TOOLS_CROSSBOWS, (Enchantment)AllurementEnchantments.REELING.get(), PULLING, "reeling");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42473_, (TagKey<Item>)Tags.Items.ARMORS_CHESTPLATES, (Enchantment)EnsorcEnchantments.REACH.get(), PULLING, "reach");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)ModItems.DIAMOND_KNIFE.get(), (TagKey<Item>)ForgeTags.TOOLS_KNIVES, (Enchantment)ModEnchantments.BACKSTABBING.get(), SILENT, "backstabbing");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getLeggings(), (TagKey<Item>)Tags.Items.ARMORS_LEGGINGS, Enchantments.f_220304_, SILENT, "swift_sneak");
        EmiSmithingRecipe.addRecipe(emiRegistry, (Item)DIItemRegistry.COLLAR_TAG.get(), (Item)DIItemRegistry.COLLAR_TAG.get(), (Enchantment)DIEnchantmentRegistry.MUFFLED, SILENT, "muffled");
        EmiSmithingRecipe.addRecipe(emiRegistry, EmiSmithingRecipe.getSword(), (TagKey<Item>)Tags.Items.TOOLS_SWORDS, (Enchantment)AEEnchantments.FASTER_ATTACKS.get(), SWIFT, "swift_sword");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42391_, (TagKey<Item>)Tags.Items.TOOLS_AXES, (Enchantment)AEEnchantments.FASTER_ATTACKS.get(), SWIFT, "swift_axe");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42411_, (TagKey<Item>)Tags.Items.TOOLS_BOWS, (Enchantment)EnsorcEnchantments.QUICK_DRAW.get(), SWIFT, "swift_bow");
        EmiSmithingRecipe.addRecipe(emiRegistry, Items.f_42717_, (TagKey<Item>)Tags.Items.TOOLS_CROSSBOWS, (Enchantment)EnsorcEnchantments.QUICK_DRAW.get(), SWIFT, "swift_crossbow");
    }

    private static Item getLeggings() {
        return Items.f_42474_;
    }

    private static Item getBoots() {
        return Items.f_42475_;
    }

    private static Item getSword() {
        return Items.f_42388_;
    }

    private static Item getArmour() {
        return Items.f_42473_;
    }

    private static Item getTools() {
        return Items.f_42390_;
    }

    public static void addRecipe(EmiRegistry emiRegistry, Item item, TagKey<Item> tag, Enchantment enchantment, Item tablet, String id) {
        ItemStack enchantedGear = new ItemStack((ItemLike)item);
        enchantedGear.m_41663_(enchantment, 1);
        emiRegistry.addRecipe((EmiRecipe)new EmiSmithingRecipe(EmiIngredient.of(tag), EmiStack.of((ItemStack)new ItemStack((ItemLike)tablet)), EmiStack.of((ItemStack)enchantedGear), RaspberryMod.locate("/smithing/" + id)));
    }

    public static void addRecipe(EmiRegistry emiRegistry, Item item, Item tag, Enchantment enchantment, Item tablet, String id) {
        ItemStack enchantedGear = new ItemStack((ItemLike)item);
        enchantedGear.m_41663_(enchantment, 1);
        emiRegistry.addRecipe((EmiRecipe)new EmiSmithingRecipe(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{tag})), EmiStack.of((ItemStack)new ItemStack((ItemLike)tablet)), EmiStack.of((ItemStack)enchantedGear), RaspberryMod.locate("/smithing/" + id)));
    }

    public static ResourceLocation tablet(String id) {
        return new ResourceLocation("kubejs", id + "_tablet");
    }

    public static Item get(String id) {
        return (Item)Registry.f_122827_.m_7745_(EmiSmithingRecipe.tablet(id));
    }
}

