/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.entity.ai.goal;

import cc.cassian.raspberry.RaspberryMod;
import cc.cassian.raspberry.config.ModConfig;
import cc.cassian.raspberry.registry.RaspberryBlocks;
import com.google.common.collect.Lists;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class HuntWormGoal
extends Goal {
    private final Animal seeker;
    private final IDataManager data;
    private int runDelay;
    private int lookTimer;
    private Vec3 lookVector;

    public HuntWormGoal(Animal seekerIn) {
        this.seeker = seekerIn;
        this.data = (IDataManager)this.seeker;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = this.m_183277_(20);
        if (((Boolean)this.data.getValue(RaspberryMod.HAS_WORM_TARGET)).booleanValue()) {
            return true;
        }
        return (Integer)this.data.getValue(RaspberryMod.WORM_HUNTING_TIME) > 0 && this.findWorm();
    }

    public boolean m_8045_() {
        return (Boolean)this.data.getValue(RaspberryMod.HAS_WORM_TARGET) != false && (Integer)this.data.getValue(RaspberryMod.WORM_HUNTING_TIME) != 0;
    }

    public void m_8056_() {
        this.lookVector = new Vec3(1.0, 0.0, 1.0);
        this.moveToWorm();
        this.data.setValue(RaspberryMod.LOOKING_FOR_WORM, (Object)true);
    }

    public void m_8041_() {
        this.data.setValue(RaspberryMod.LOOKING_FOR_WORM, (Object)false);
    }

    public void m_8037_() {
        int wormhuntingtime = (Integer)this.data.getValue(RaspberryMod.WORM_HUNTING_TIME);
        BlockPos blockpos = (BlockPos)this.data.getValue(RaspberryMod.WORM_POS);
        Vec3 seekerpos = this.seeker.m_20182_();
        Vec3 vector3d = new Vec3((double)blockpos.m_123341_() + 0.5 - seekerpos.m_7096_(), 0.0, (double)blockpos.m_123343_() + 0.5 - seekerpos.m_7094_()).m_82541_();
        this.seeker.m_21563_().m_24950_(seekerpos.m_7096_() + vector3d.m_7096_() * this.lookVector.m_7096_(), this.seeker.m_20186_() - 0.6 + this.lookVector.m_7098_(), seekerpos.m_7094_() + vector3d.m_7094_() * this.lookVector.m_7094_(), (float)(this.seeker.m_8085_() + 20), (float)this.seeker.m_8132_());
        if (blockpos.m_123314_((Vec3i)this.seeker.m_20183_(), 4.0)) {
            if (wormhuntingtime > 0) {
                this.data.setValue(RaspberryMod.WORM_HUNTING_TIME, (Object)-800);
            }
        } else {
            if (this.lookTimer-- <= 0) {
                this.lookTimer = this.m_183277_(18 + this.seeker.m_217043_().m_188503_(9));
                this.lookVector = new Vec3((double)this.seeker.m_217043_().m_188501_() * 1.2, (double)this.seeker.m_217043_().m_188501_() * 0.4, (double)this.seeker.m_217043_().m_188501_() * 1.2);
            }
            this.moveToWorm();
        }
    }

    private void moveToWorm() {
        BlockPos blockpos = (BlockPos)this.data.getValue(RaspberryMod.WORM_POS);
        this.seeker.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)(blockpos.m_123342_() + 1), (double)blockpos.m_123343_() + 0.5, 1.1);
    }

    private boolean findWorm() {
        if (!this.seeker.f_19853_.m_6042_().f_63858_()) {
            return false;
        }
        int range = ModConfig.get().aquaculture_wormDiscoveryRange;
        int height = 16;
        BlockPos blockpos = this.seeker.m_20183_();
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        ArrayList wormblocks = Lists.newArrayList();
        for (int i = 0; i < range; ++i) {
            boolean flag = false;
            for (int y = -height; y < height; ++y) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        blockpos$mutable.m_122154_((Vec3i)blockpos, x, y - 1, z);
                        if (this.seeker.m_21444_((BlockPos)blockpos$mutable)) {
                            if (this.isWorm(this.seeker.f_19853_, (BlockPos)blockpos$mutable)) {
                                this.data.setValue(RaspberryMod.HAS_WORM_TARGET, (Object)true);
                                this.data.setValue(RaspberryMod.WORM_POS, (Object)blockpos$mutable);
                                return true;
                            }
                            if (this.isSuitableForWorm(this.seeker.f_19853_, (BlockPos)blockpos$mutable)) {
                                if (i <= 48 && !flag) {
                                    flag = true;
                                    wormblocks.clear();
                                }
                                wormblocks.add(blockpos$mutable.m_7949_());
                            }
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
        }
        if (wormblocks.size() > 0) {
            BlockPos wormpos = (BlockPos)wormblocks.get(this.seeker.m_217043_().m_188503_(wormblocks.size()));
            this.seeker.f_19853_.m_7731_(wormpos, ((Block)((RegistryObject)RaspberryBlocks.WORMY_DIRT.getA()).get()).m_49966_(), 3);
            this.data.setValue(RaspberryMod.HAS_WORM_TARGET, (Object)true);
            this.data.setValue(RaspberryMod.WORM_POS, (Object)wormpos);
            return true;
        }
        return false;
    }

    private boolean isWorm(Level worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos).m_60734_() == ((RegistryObject)RaspberryBlocks.WORMY_DIRT.getA()).get();
    }

    private boolean isSuitableForWorm(Level worldIn, BlockPos pos) {
        if (worldIn.m_8055_(pos).m_60734_() != Blocks.f_50493_) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.m_8055_(pos.m_121945_(direction));
            if (!(direction == Direction.UP ? !blockstate.m_204336_(EnvironmentalBlockTags.GRASS_LIKE) && (!blockstate.m_204336_(BlockTags.f_144274_) || !worldIn.m_8055_(pos.m_7494_()).m_204336_(EnvironmentalBlockTags.GRASS_LIKE)) : !blockstate.m_204336_(BlockTags.f_144274_))) continue;
            return false;
        }
        return true;
    }
}

