/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.aquaculture;

import cc.cassian.raspberry.registry.RaspberryTags;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.inventory.container.TackleBoxContainer;
import com.teammetallurgy.aquaculture.inventory.container.slot.SlotFishingRod;
import com.teammetallurgy.aquaculture.inventory.container.slot.SlotHidable;
import com.teammetallurgy.aquaculture.item.HookItem;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={TackleBoxContainer.class})
public abstract class TackleBoxContainerMixin
extends AbstractContainerMenu {
    @Shadow
    public Slot slotHook;
    @Shadow
    public Slot slotBait;
    @Shadow
    public Slot slotLine;
    @Shadow
    public Slot slotBobber;
    @Shadow
    private int rows;
    @Shadow
    private int collumns;

    protected TackleBoxContainerMixin(@Nullable MenuType<?> arg, int i) {
        super(arg, i);
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/common/util/LazyOptional;ifPresent(Lnet/minecraftforge/common/util/NonNullConsumer;)V")})
    private void modifyTackleBoxContainer(LazyOptional<IItemHandler> instance, NonNullConsumer<? super IItemHandler> consumer, Operation<Void> original) {
        instance.ifPresent(handler -> {
            SlotFishingRod fishingRod = (SlotFishingRod)this.m_38897_((Slot)new SlotFishingRod(handler, 0, 117, 21));
            this.slotHook = this.m_38897_((Slot)new SlotHidable(fishingRod, 0, 106, 44){

                public boolean m_5857_(@Nonnull ItemStack stack) {
                    return stack.m_41720_() instanceof HookItem && super.m_5857_(stack);
                }
            });
            this.slotBait = this.m_38897_((Slot)new SlotHidable(fishingRod, 1, 129, 44){

                public boolean m_5857_(@Nonnull ItemStack stack) {
                    return stack.m_204117_(RaspberryTags.BAIT) && super.m_5857_(stack);
                }
            });
            this.slotLine = this.m_38897_((Slot)new SlotHidable(fishingRod, 2, 106, 67){

                public boolean m_5857_(@Nonnull ItemStack stack) {
                    boolean isDyeable = stack.m_41720_() instanceof DyeableLeatherItem;
                    return stack.m_204117_(AquacultureAPI.Tags.FISHING_LINE) && isDyeable && super.m_5857_(stack);
                }
            });
            this.slotBobber = this.m_38897_((Slot)new SlotHidable(fishingRod, 3, 129, 67){

                public boolean m_5857_(@Nonnull ItemStack stack) {
                    boolean isDyeable = stack.m_41720_() instanceof DyeableLeatherItem;
                    return stack.m_204117_(AquacultureAPI.Tags.BOBBER) && isDyeable && super.m_5857_(stack);
                }
            });
            for (int column = 0; column < this.collumns; ++column) {
                for (int row = 0; row < this.rows; ++row) {
                    this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1 + row + column * this.collumns, 8 + row * 18, 8 + column * 18){

                        public boolean m_5857_(@Nonnull ItemStack stack) {
                            return TackleBoxBlockEntity.canBePutInTackleBox((ItemStack)stack);
                        }
                    });
                }
            }
        });
    }

    @Inject(method={"clicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeBaitNormal(int slotId, int dragType, ClickType clickType, Player player, CallbackInfo ci) {
        super.m_150399_(slotId, dragType, clickType, player);
        ci.cancel();
    }
}

