/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.registry;

import cc.cassian.raspberry.blocks.RaspberryGravelBlock;
import cc.cassian.raspberry.compat.CopperBackportCompat;
import cc.cassian.raspberry.compat.EnvironmentalCompat;
import cc.cassian.raspberry.registry.RaspberryItems;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RakedGravelBlock;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class RaspberryBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"raspberry");
    public static Pair<RegistryObject<Block>, RegistryObject<BlockItem>> SILT_STOVE = RaspberryBlocks.registerBlock("silt_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModBlocks.STOVE.get()))), FarmersDelight.CREATIVE_TAB);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockItem>> ASH_STOVE = RaspberryBlocks.registerBlock("ash_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModBlocks.STOVE.get()))), FarmersDelight.CREATIVE_TAB);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockItem>> LEAD_GRATE = RaspberryBlocks.registerLeadGrate();
    public static Pair<RegistryObject<Block>, RegistryObject<BlockItem>> WORMY_DIRT = RaspberryBlocks.registerBlock("wormy_dirt", () -> new Block(RaspberryBlocks.getTruffleProperties()), CreativeModeTab.f_40749_);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockItem>> RAKED_BLACKSTONE_GRAVEL = RaspberryBlocks.registerBlock("raked_blackstone_gravel", () -> new RakedGravelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_)), CreativeModeTab.f_40749_);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockItem>> RAKED_DEEPSLATE_GRAVEL = RaspberryBlocks.registerBlock("raked_deepslate_gravel", () -> new RakedGravelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_)), CreativeModeTab.f_40749_);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockItem>> BLACKSTONE_GRAVEL = RaspberryBlocks.registerBlock("blackstone_gravel", () -> new RaspberryGravelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_), 986379), CreativeModeTab.f_40749_);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockItem>> DEEPSLATE_GRAVEL = RaspberryBlocks.registerBlock("deepslate_gravel", () -> new RaspberryGravelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_), 2039584), CreativeModeTab.f_40749_);

    public static BlockBehaviour.Properties getTruffleProperties() {
        if (ModList.get().isLoaded("environmental")) {
            return EnvironmentalCompat.getTruffleProperties();
        }
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_);
    }

    public static Pair<RegistryObject<Block>, RegistryObject<BlockItem>> registerLeadGrate() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76281_).m_60955_().m_60913_(5.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56743_);
        if (ModList.get().isLoaded("copperandtuffbackport")) {
            return CopperBackportCompat.registerGrateBlock(properties);
        }
        return RaspberryBlocks.registerBlock("lead_grate", () -> new Block(properties), CreativeModeTab.f_40749_);
    }

    public static Pair<RegistryObject<Block>, RegistryObject<BlockItem>> registerBlock(String blockID, Supplier<Block> blockSupplier, CreativeModeTab tab) {
        RegistryObject block = BLOCKS.register(blockID, blockSupplier);
        RegistryObject item = RaspberryItems.ITEMS.register(blockID, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
        return new Pair((Object)block, (Object)item);
    }

    @NotNull
    public static Block getBlock(Pair<RegistryObject<Block>, RegistryObject<BlockItem>> block) {
        return (Block)((RegistryObject)block.getA()).get();
    }

    @NotNull
    public static Item getItem(Pair<RegistryObject<Block>, RegistryObject<BlockItem>> block) {
        return (Item)((RegistryObject)block.getB()).get();
    }
}

