/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelightemi.integration.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.utility.ClientRenderUtils;
import vectorwing.farmersdelightemi.integration.emi.FDRecipeCategories;

public class CookingPotEmiRecipe
implements EmiRecipe {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("farmersdelight", "textures/gui/cooking_pot.png");
    private final ResourceLocation id;
    private final List<EmiIngredient> inputs;
    private final EmiStack output;
    private final EmiStack container;
    private final int cookTime;
    private final float experience;
    private final List<ClientTooltipComponent> tooltipComponents;

    public CookingPotEmiRecipe(ResourceLocation id, List<EmiIngredient> inputs, EmiStack output, EmiStack container, int cookTime, float experience) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.container = container;
        this.cookTime = cookTime;
        this.experience = experience;
        this.tooltipComponents = this.createTooltipComponents();
    }

    private List<ClientTooltipComponent> createTooltipComponents() {
        ArrayList<ClientTooltipComponent> tooltipStrings = new ArrayList<ClientTooltipComponent>();
        if (this.cookTime > 0) {
            int cookTimeSeconds = this.cookTime / 20;
            tooltipStrings.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"emi.cooking.time", (Object[])new Object[]{cookTimeSeconds}).m_7532_()));
        }
        if (this.experience > 0.0f) {
            tooltipStrings.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"emi.cooking.experience", (Object[])new Object[]{Float.valueOf(this.experience)}).m_7532_()));
        }
        return tooltipStrings;
    }

    public EmiRecipeCategory getCategory() {
        return FDRecipeCategories.COOKING;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(this.container);
    }

    public int getDisplayWidth() {
        return 117;
    }

    public int getDisplayHeight() {
        return 56;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, 116, 56, 29, 16);
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 3; ++column) {
                int inputIndex = row * 3 + column;
                if (inputIndex >= this.inputs.size()) continue;
                this.addSlot(widgets, this.inputs.get(inputIndex), column * borderSlotSize, row * borderSlotSize);
            }
        }
        this.addSlot(widgets, (EmiIngredient)this.output, 94, 9);
        this.addSlot(widgets, (EmiIngredient)this.container, 62, 38);
        this.addSlot(widgets, (EmiIngredient)this.output, 94, 38).recipeContext((EmiRecipe)this);
        widgets.addAnimatedTexture(BACKGROUND, 60, 9, 24, 17, 176, 15, 10000, true, false, false);
        widgets.addTexture(BACKGROUND, 18, 39, 17, 15, 176, 0);
        widgets.addTexture(BACKGROUND, 64, 2, 8, 11, 176, 32);
        if (this.experience > 0.0f) {
            widgets.addTexture(BACKGROUND, 63, 21, 9, 9, 176, 43);
        }
        widgets.addTooltip((mouseX, mouseY) -> {
            if (ClientRenderUtils.isCursorInsideBounds((int)60, (int)2, (int)22, (int)28, (double)mouseX.intValue(), (double)mouseY.intValue())) {
                return this.tooltipComponents;
            }
            return List.of();
        }, 0, 0, widgets.getWidth(), widgets.getHeight());
    }

    private SlotWidget addSlot(WidgetHolder widgets, EmiIngredient ingredient, int x, int y) {
        return widgets.addSlot(ingredient, x, y).drawBack(false);
    }
}

