/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelightemi.integration.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ClientRenderUtils;
import vectorwing.farmersdelightemi.integration.emi.FDRecipeCategories;
import vectorwing.farmersdelightemi.integration.emi.FDRecipeWorkstations;

public class DecompositionEmiRecipe
implements EmiRecipe {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("farmersdelight", "textures/gui/jei/decomposition.png");
    private static final EmiStack RICH_SOIL = EmiStack.of((ItemLike)((ItemLike)ModItems.RICH_SOIL.get()));
    private static final EmiIngredient ACCELERATORS = EmiIngredient.of((TagKey)ModTags.COMPOST_ACTIVATORS);
    private static final ClientTooltipComponent LIGHT_TOOLTIP = DecompositionEmiRecipe.createTooltip(".light");
    private static final ClientTooltipComponent FLUID_TOOLTIP = DecompositionEmiRecipe.createTooltip(".fluid");
    private static final ClientTooltipComponent ACCELERATORS_TOOLTIP = DecompositionEmiRecipe.createTooltip(".accelerators");

    public EmiRecipeCategory getCategory() {
        return FDRecipeCategories.DECOMPOSITION;
    }

    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation("farmersdelightemi", "decomposition/dummy");
    }

    public List<EmiIngredient> getInputs() {
        return List.of(FDRecipeWorkstations.ORGANIC_COMPOST);
    }

    public List<EmiStack> getOutputs() {
        return List.of(RICH_SOIL);
    }

    public int getDisplayWidth() {
        return 102;
    }

    public int getDisplayHeight() {
        return 62;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, 102, 41, 8, 9);
        this.addSlot(widgets, (EmiIngredient)FDRecipeWorkstations.ORGANIC_COMPOST, 0, 16);
        this.addSlot(widgets, (EmiIngredient)RICH_SOIL, 84, 16).recipeContext((EmiRecipe)this);
        this.addSlot(widgets, ACCELERATORS, 55, 44);
        widgets.addTooltip((mouseX, mouseY) -> {
            if (ClientRenderUtils.isCursorInsideBounds((int)32, (int)30, (int)11, (int)11, (double)mouseX.intValue(), (double)mouseY.intValue())) {
                return List.of(LIGHT_TOOLTIP);
            }
            if (ClientRenderUtils.isCursorInsideBounds((int)45, (int)30, (int)11, (int)11, (double)mouseX.intValue(), (double)mouseY.intValue())) {
                return List.of(FLUID_TOOLTIP);
            }
            if (ClientRenderUtils.isCursorInsideBounds((int)59, (int)30, (int)11, (int)11, (double)mouseX.intValue(), (double)mouseY.intValue())) {
                return List.of(ACCELERATORS_TOOLTIP);
            }
            return List.of();
        }, 0, 0, widgets.getWidth(), widgets.getHeight());
    }

    private SlotWidget addSlot(WidgetHolder widgets, EmiIngredient ingredient, int x, int y) {
        return widgets.addSlot(ingredient, x, y).backgroundTexture(BACKGROUND, 119, 0);
    }

    private static ClientTooltipComponent createTooltip(@NotNull String suffix) {
        return ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237115_((String)("farmersdelightemi.jei.decomposition" + suffix)).m_7532_());
    }
}

