package cc.cassian.raspberry.blocks;

import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.*;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

import java.util.Map;

// This is just a tidied up copy of WallBlock because changing the VoxelShape size wasn't possible with inheritance
public class FineWoodWall extends Block implements SimpleWaterloggedBlock {
    public static final BooleanProperty UP;
    public static final EnumProperty<WallSide> EAST_WALL;
    public static final EnumProperty<WallSide> NORTH_WALL;
    public static final EnumProperty<WallSide> SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST_WALL;
    public static final BooleanProperty WATERLOGGED;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final VoxelShape POST_TEST;
    private static final VoxelShape NORTH_TEST;
    private static final VoxelShape SOUTH_TEST;
    private static final VoxelShape WEST_TEST;
    private static final VoxelShape EAST_TEST;

    public FineWoodWall(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_(this.f_49792_.m_61090_()
                .m_61124_(UP, true)
                .m_61124_(NORTH_WALL, WallSide.NONE)
                .m_61124_(EAST_WALL, WallSide.NONE)
                .m_61124_(SOUTH_WALL, WallSide.NONE)
                .m_61124_(WEST_WALL, WallSide.NONE)
                .m_61124_(WATERLOGGED, false)
        );
        this.shapeByIndex = this.makeShapes(4.0F, 4.0F, 16.0F, 0.0F, 16.0F, 16.0F);
        this.collisionShapeByIndex = this.makeShapes(4.0F, 4.0F, 24.0F, 0.0F, 24.0F, 24.0F);
    }

    private static VoxelShape applyWallShape(VoxelShape baseShape, WallSide height, VoxelShape lowShape, VoxelShape tallShape) {
        if (height == WallSide.TALL) {
            return Shapes.m_83110_(baseShape, tallShape);
        } else {
            return height == WallSide.LOW ? Shapes.m_83110_(baseShape, lowShape) : baseShape;
        }
    }

    private Map<BlockState, VoxelShape> makeShapes(float width, float depth, float wallPostHeight, float wallMinY, float wallLowHeight, float wallTallHeight) {
        float f = 8.0F - width;
        float g = 8.0F + width;
        float h = 8.0F - depth;
        float i = 8.0F + depth;
        VoxelShape voxelShape = Block.m_49796_(f, 0.0F, f, g, wallPostHeight, g);
        VoxelShape voxelShape2 = Block.m_49796_(h, wallMinY, 0.0F, i, wallLowHeight, i);
        VoxelShape voxelShape3 = Block.m_49796_(h, wallMinY, h, i, wallLowHeight, 16.0F);
        VoxelShape voxelShape4 = Block.m_49796_(0.0F, wallMinY, h, i, wallLowHeight, i);
        VoxelShape voxelShape5 = Block.m_49796_(h, wallMinY, h, 16.0F, wallLowHeight, i);
        VoxelShape voxelShape6 = Block.m_49796_(h, wallMinY, 0.0F, i, wallTallHeight, i);
        VoxelShape voxelShape7 = Block.m_49796_(h, wallMinY, h, i, wallTallHeight, 16.0F);
        VoxelShape voxelShape8 = Block.m_49796_(0.0F, wallMinY, h, i, wallTallHeight, i);
        VoxelShape voxelShape9 = Block.m_49796_(h, wallMinY, h, 16.0F, wallTallHeight, i);
        ImmutableMap.Builder<BlockState, VoxelShape> builder = ImmutableMap.builder();

        for(Boolean boolean_ : UP.m_6908_()) {
            for(WallSide wallSide : EAST_WALL.m_6908_()) {
                for(WallSide wallSide2 : NORTH_WALL.m_6908_()) {
                    for(WallSide wallSide3 : WEST_WALL.m_6908_()) {
                        for(WallSide wallSide4 : SOUTH_WALL.m_6908_()) {
                            VoxelShape voxelShape10 = Shapes.m_83040_();
                            voxelShape10 = applyWallShape(voxelShape10, wallSide, voxelShape5, voxelShape9);
                            voxelShape10 = applyWallShape(voxelShape10, wallSide3, voxelShape4, voxelShape8);
                            voxelShape10 = applyWallShape(voxelShape10, wallSide2, voxelShape2, voxelShape6);
                            voxelShape10 = applyWallShape(voxelShape10, wallSide4, voxelShape3, voxelShape7);
                            if (boolean_) {
                                voxelShape10 = Shapes.m_83110_(voxelShape10, voxelShape);
                            }

                            BlockState blockState = this.m_49966_().m_61124_(UP, boolean_).m_61124_(EAST_WALL, wallSide).m_61124_(WEST_WALL, wallSide3).m_61124_(NORTH_WALL, wallSide2).m_61124_(SOUTH_WALL, wallSide4);
                            builder.put(blockState.m_61124_(WATERLOGGED, false), voxelShape10);
                            builder.put(blockState.m_61124_(WATERLOGGED, true), voxelShape10);
                        }
                    }
                }
            }
        }

        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeByIndex.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.collisionShapeByIndex.get(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    private boolean connectsTo(BlockState state, boolean sideSolid, Direction direction) {
        Block block = state.m_60734_();
        boolean bl = block instanceof FenceGateBlock && FenceGateBlock.m_53378_(state, direction);
        return state.m_204336_(BlockTags.f_13032_) || !m_152463_(state) && sideSolid || block instanceof IronBarsBlock || bl;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        LevelReader levelReader = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos blockPos2 = blockPos.m_122012_();
        BlockPos blockPos3 = blockPos.m_122029_();
        BlockPos blockPos4 = blockPos.m_122019_();
        BlockPos blockPos5 = blockPos.m_122024_();
        BlockPos blockPos6 = blockPos.m_7494_();
        BlockState blockState = levelReader.m_8055_(blockPos2);
        BlockState blockState2 = levelReader.m_8055_(blockPos3);
        BlockState blockState3 = levelReader.m_8055_(blockPos4);
        BlockState blockState4 = levelReader.m_8055_(blockPos5);
        BlockState blockState5 = levelReader.m_8055_(blockPos6);
        boolean bl = this.connectsTo(blockState, blockState.m_60783_(levelReader, blockPos2, Direction.SOUTH), Direction.SOUTH);
        boolean bl2 = this.connectsTo(blockState2, blockState2.m_60783_(levelReader, blockPos3, Direction.WEST), Direction.WEST);
        boolean bl3 = this.connectsTo(blockState3, blockState3.m_60783_(levelReader, blockPos4, Direction.NORTH), Direction.NORTH);
        boolean bl4 = this.connectsTo(blockState4, blockState4.m_60783_(levelReader, blockPos5, Direction.EAST), Direction.EAST);
        BlockState blockState6 = this.m_49966_().m_61124_(WATERLOGGED, fluidState.m_76152_() == Fluids.f_76193_);
        return this.updateShape(levelReader, blockState6, blockPos6, blockState5, bl, bl2, bl3, bl4);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (state.m_61143_(WATERLOGGED)) {
            level.m_186469_(currentPos, Fluids.f_76193_, Fluids.f_76193_.m_6718_(level));
        }

        if (direction == Direction.DOWN) {
            return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        } else {
            return direction == Direction.UP ? this.topUpdate(level, state, neighborPos, neighborState) : this.sideUpdate(level, currentPos, state, neighborPos, neighborState, direction);
        }
    }

    private static boolean isConnected(BlockState state, Property<WallSide> heightProperty) {
        return state.m_61143_(heightProperty) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape firstShape, VoxelShape secondShape) {
        return !Shapes.m_83157_(secondShape, firstShape, BooleanOp.f_82685_);
    }

    private BlockState topUpdate(LevelReader level, BlockState state, BlockPos pos, BlockState secondState) {
        boolean bl = isConnected(state, NORTH_WALL);
        boolean bl2 = isConnected(state, EAST_WALL);
        boolean bl3 = isConnected(state, SOUTH_WALL);
        boolean bl4 = isConnected(state, WEST_WALL);
        return this.updateShape(level, state, pos, secondState, bl, bl2, bl3, bl4);
    }

    private BlockState sideUpdate(LevelReader level, BlockPos firstPos, BlockState firstState, BlockPos secondPos, BlockState secondState, Direction dir) {
        Direction direction = dir.m_122424_();
        boolean bl = dir == Direction.NORTH ? this.connectsTo(secondState, secondState.m_60783_(level, secondPos, direction), direction) : isConnected(firstState, NORTH_WALL);
        boolean bl2 = dir == Direction.EAST ? this.connectsTo(secondState, secondState.m_60783_(level, secondPos, direction), direction) : isConnected(firstState, EAST_WALL);
        boolean bl3 = dir == Direction.SOUTH ? this.connectsTo(secondState, secondState.m_60783_(level, secondPos, direction), direction) : isConnected(firstState, SOUTH_WALL);
        boolean bl4 = dir == Direction.WEST ? this.connectsTo(secondState, secondState.m_60783_(level, secondPos, direction), direction) : isConnected(firstState, WEST_WALL);
        BlockPos blockPos = firstPos.m_7494_();
        BlockState blockState = level.m_8055_(blockPos);
        return this.updateShape(level, firstState, blockPos, blockState, bl, bl2, bl3, bl4);
    }

    private BlockState updateShape(LevelReader level, BlockState state, BlockPos pos, BlockState neighbour, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection) {
        VoxelShape voxelShape = neighbour.m_60812_(level, pos).m_83263_(Direction.DOWN);
        BlockState blockState = this.updateSides(state, northConnection, eastConnection, southConnection, westConnection, voxelShape);
        return blockState.m_61124_(UP, this.shouldRaisePost(blockState, neighbour, voxelShape));
    }

    private boolean shouldRaisePost(BlockState state, BlockState neighbour, VoxelShape shape) {
        boolean bl = neighbour.m_60734_() instanceof net.minecraft.world.level.block.WallBlock && neighbour.m_61143_(UP);
        if (bl) {
            return true;
        } else {
            WallSide wallSide = state.m_61143_(NORTH_WALL);
            WallSide wallSide2 = state.m_61143_(SOUTH_WALL);
            WallSide wallSide3 = state.m_61143_(EAST_WALL);
            WallSide wallSide4 = state.m_61143_(WEST_WALL);
            boolean bl2 = wallSide2 == WallSide.NONE;
            boolean bl3 = wallSide4 == WallSide.NONE;
            boolean bl4 = wallSide3 == WallSide.NONE;
            boolean bl5 = wallSide == WallSide.NONE;
            boolean bl6 = bl5 && bl2 && bl3 && bl4 || bl5 != bl2 || bl3 != bl4;
            if (bl6) {
                return true;
            } else {
                boolean bl7 = wallSide == WallSide.TALL && wallSide2 == WallSide.TALL || wallSide3 == WallSide.TALL && wallSide4 == WallSide.TALL;
                if (bl7) {
                    return false;
                } else {
                    return neighbour.m_204336_(BlockTags.f_13081_) || isCovered(shape, POST_TEST);
                }
            }
        }
    }

    private BlockState updateSides(BlockState state, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection, VoxelShape wallShape) {
        return state.m_61124_(NORTH_WALL, this.makeWallState(northConnection, wallShape, NORTH_TEST)).m_61124_(EAST_WALL, this.makeWallState(eastConnection, wallShape, EAST_TEST)).m_61124_(SOUTH_WALL, this.makeWallState(southConnection, wallShape, SOUTH_TEST)).m_61124_(WEST_WALL, this.makeWallState(westConnection, wallShape, WEST_TEST));
    }

    private WallSide makeWallState(boolean allowConnection, VoxelShape shape, VoxelShape neighbourShape) {
        if (allowConnection) {
            return isCovered(shape, neighbourShape) ? WallSide.TALL : WallSide.LOW;
        } else {
            return WallSide.NONE;
        }
    }

    public FluidState m_5888_(BlockState state) {
        return state.m_61143_(WATERLOGGED) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return !state.m_61143_(WATERLOGGED);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(UP, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180 -> {
                return (((state.m_61124_(NORTH_WALL, state.m_61143_(SOUTH_WALL))).m_61124_(EAST_WALL, state.m_61143_(WEST_WALL))).m_61124_(SOUTH_WALL, state.m_61143_(NORTH_WALL))).m_61124_(WEST_WALL, state.m_61143_(EAST_WALL));
            }
            case COUNTERCLOCKWISE_90 -> {
                return (((state.m_61124_(NORTH_WALL, state.m_61143_(EAST_WALL))).m_61124_(EAST_WALL, state.m_61143_(SOUTH_WALL))).m_61124_(SOUTH_WALL, state.m_61143_(WEST_WALL))).m_61124_(WEST_WALL, state.m_61143_(NORTH_WALL));
            }
            case CLOCKWISE_90 -> {
                return (((state.m_61124_(NORTH_WALL, state.m_61143_(WEST_WALL))).m_61124_(EAST_WALL, state.m_61143_(NORTH_WALL))).m_61124_(SOUTH_WALL, state.m_61143_(EAST_WALL))).m_61124_(WEST_WALL, state.m_61143_(SOUTH_WALL));
            }
            default -> {
                return state;
            }
        }
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT -> {
                return (state.m_61124_(NORTH_WALL, state.m_61143_(SOUTH_WALL))).m_61124_(SOUTH_WALL, state.m_61143_(NORTH_WALL));
            }
            case FRONT_BACK -> {
                return (state.m_61124_(EAST_WALL, state.m_61143_(WEST_WALL))).m_61124_(WEST_WALL, state.m_61143_(EAST_WALL));
            }
            default -> {
                return super.m_6943_(state, mirror);
            }
        }
    }

    static {
        UP = BlockStateProperties.f_61366_;
        EAST_WALL = BlockStateProperties.f_61378_;
        NORTH_WALL = BlockStateProperties.f_61379_;
        SOUTH_WALL = BlockStateProperties.f_61380_;
        WEST_WALL = BlockStateProperties.f_61381_;
        WATERLOGGED = BlockStateProperties.f_61362_;
        POST_TEST = Block.m_49796_(7.0F, 0.0F, 7.0F, 9.0F, 16.0F, 9.0F);
        NORTH_TEST = Block.m_49796_(7.0F, 0.0F, 0.0F, 9.0F, 16.0F, 9.0F);
        SOUTH_TEST = Block.m_49796_(7.0F, 0.0F, 7.0F, 9.0F, 16.0F, 16.0F);
        WEST_TEST = Block.m_49796_(0.0F, 0.0F, 7.0F, 9.0F, 16.0F, 9.0F);
        EAST_TEST = Block.m_49796_(7.0F, 0.0F, 7.0F, 16.0F, 16.0F, 9.0F);
    }
}
