package cc.cassian.raspberry.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.*;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FlowerPetalParticle extends TextureSheetParticle {
    private final float yRot;
    private final float yOffset;

    protected FlowerPetalParticle(ClientLevel level, double x, double y, double z,
                                  double vx, double vy, double vz) {
        super(level, x, y, z, vx, vy, vz);
        this.f_107225_ = 100 + this.f_107223_.m_188503_(20);
        this.f_107226_ = 0.01F;
        this.f_107216_ = -0.08F;
        this.f_107215_ = (-0.5 + this.f_107223_.m_188501_()) / 10;
        this.f_107217_ = (-0.5 + this.f_107223_.m_188501_()) / 10;
        this.f_107663_ = 0.5F;
        this.yOffset = this.f_107223_.m_188501_() / 10;
        this.yRot = (float) (Math.PI / 2 * this.f_107223_.m_188503_(4)); // 0, 90°, 180°, 270°
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        // Add slight movement wandering
        this.f_107215_ = Mth.m_14008_(this.f_107215_ + this.f_107223_.m_188501_() / 1000.0F * (this.f_107223_.m_188499_() ? 1 : -1), -0.05F, 0.05F);
        this.f_107217_ = Mth.m_14008_(this.f_107217_ + this.f_107223_.m_188501_() / 1000.0F * (this.f_107223_.m_188499_() ? 1 : -1), -0.05F, 0.05F);
    }

    @Override
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @Override
    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 pos = new Vec3(
            Mth.m_14139_(partialTicks, this.f_107209_, this.f_107212_) - camera.m_90583_().f_82479_,
            Mth.m_14139_(partialTicks, this.f_107210_, this.f_107213_) - camera.m_90583_().f_82480_,
            Mth.m_14139_(partialTicks, this.f_107211_, this.f_107214_) - camera.m_90583_().f_82481_
        );

        float half = this.f_107663_ * 0.5F;
        Vector3f[] corners = new Vector3f[]{
            new Vector3f(-half, 0, -half),
            new Vector3f(-half, 0, half),
            new Vector3f(half, 0, half),
            new Vector3f(half, 0, -half)
        };

        float cos = Mth.m_14089_(yRot);
        float sin = Mth.m_14031_(yRot);
        for (Vector3f corner : corners) {
            float xOld = corner.m_122239_();
            float zOld = corner.m_122269_();
            // Set rotation
            corner.m_122245_(xOld * cos - zOld * sin, corner.m_122260_(), xOld * sin + zOld * cos);
            // Set position
            corner.m_122272_((float)pos.f_82479_, (float)pos.f_82480_ + yOffset, (float)pos.f_82481_);
        }

        int light = this.m_6355_(partialTicks);
        float u0 = this.m_5970_(), u1 = this.m_5952_();
        float v0 = this.m_5951_(), v1 = this.m_5950_();

        buffer.m_5483_(corners[0].m_122239_(), corners[0].m_122260_(), corners[0].m_122269_()).m_7421_(u1, v1).m_85950_(f_107227_, f_107228_, f_107229_, f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_(corners[1].m_122239_(), corners[1].m_122260_(), corners[1].m_122269_()).m_7421_(u1, v0).m_85950_(f_107227_, f_107228_, f_107229_, f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_(corners[2].m_122239_(), corners[2].m_122260_(), corners[2].m_122269_()).m_7421_(u0, v0).m_85950_(f_107227_, f_107228_, f_107229_, f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_(corners[3].m_122239_(), corners[3].m_122260_(), corners[3].m_122269_()).m_7421_(u0, v1).m_85950_(f_107227_, f_107228_, f_107229_, f_107230_).m_85969_(light).m_5752_();
    }

    @OnlyIn(Dist.CLIENT)
    public static class Provider implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) { this.sprites = sprites; }

        public Particle createParticle(SimpleParticleType type, ClientLevel level,
                                       double x, double y, double z,
                                       double vx, double vy, double vz) {
            FlowerPetalParticle p = new FlowerPetalParticle(level, x, y, z, vx, vy, vz);
            p.m_108335_(sprites);
            return p;
        }
    }
}