package cc.cassian.raspberry.compat;

import cc.cassian.raspberry.registry.RaspberryTags;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class AquacultureCompat {
    public static void checkAndAddTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().m_41720_() instanceof AquaFishingRodItem) {
            ItemStack bait = AquaFishingRodItem.getBait(event.getItemStack());
            if (!bait.m_41720_().equals(Items.f_41852_))
                event.getToolTip().add(1, Component.m_237115_(bait.m_41778_()).m_7220_(checkAndAddCount(bait.m_41613_())).m_130940_(checkAndAddStyle(bait)));
        }
    }

    public static MutableComponent checkAndAddCount(int count) {
        if (count != 1)
            return Component.m_237113_(" x"+count);
        else return Component.m_237119_();
    }

    public static ChatFormatting checkAndAddStyle(ItemStack bait) {
        if (bait.m_204117_(RaspberryTags.BAD_BAIT)) {
            return ChatFormatting.RED;
        } else if (bait.m_204117_(RaspberryTags.MID_BAIT)) {
            return ChatFormatting.GREEN;
        } else if (bait.m_204117_(RaspberryTags.GOOD_BAIT)) {
            return ChatFormatting.GOLD;
        } else return ChatFormatting.WHITE;
    }
}
