package com.simibubi.create.compat.emi.recipes.fan;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.emi.CreateEmiAnimations;
import com.simibubi.create.compat.emi.CreateEmiPlugin;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.block.Blocks;

public class FanSmokingEmiRecipe extends FanEmiRecipe<SmokingRecipe> {

	public FanSmokingEmiRecipe(SmokingRecipe recipe) {
		super(CreateEmiPlugin.FAN_SMOKING, recipe);
		ResourceLocation rid = recipe.m_6423_();
		this.id = new ResourceLocation("emi", "create/fan_smoking/" + rid.m_135827_() + "/" + rid.m_135815_());
	}

	@Override
	protected void renderAttachedBlock(PoseStack matrices) {
		GuiGameElement.of(Blocks.f_50083_.m_49966_())
			.scale(SCALE)
			.atLocal(0, 0, 2)
			.lighting(CreateEmiAnimations.DEFAULT_LIGHTING)
			.render(matrices);
	}
}
