/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.client;

import cc.cassian.raspberry.ModCompat;
import cc.cassian.raspberry.RaspberryMod;
import cc.cassian.raspberry.client.config.ModConfigFactory;
import cc.cassian.raspberry.client.entity.renderer.SwapArrowRenderer;
import cc.cassian.raspberry.client.registry.RaspberryItemProperties;
import cc.cassian.raspberry.events.FlowerGarlandEvent;
import cc.cassian.raspberry.registry.BlockSupplier;
import cc.cassian.raspberry.registry.RaspberryBlocks;
import cc.cassian.raspberry.registry.RaspberryEntityTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="raspberry", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RaspberryModClient {
    public static void init(FMLJavaModLoadingContext context) {
        RaspberryModClient.registerModsPage(context);
        MinecraftForge.EVENT_BUS.addListener(RaspberryModClient::clickTick);
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        for (BlockSupplier block : RaspberryBlocks.FOLIAGE_BLOCKS) {
            event.register((state, view, pos, tintIndex) -> {
                if (view == null || pos == null) {
                    return 9551193;
                }
                return BiomeColors.m_108804_((BlockAndTintGetter)view, (BlockPos)pos);
            }, new Block[]{block.getBlock()});
        }
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)RaspberryEntityTypes.ASHBALL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)RaspberryEntityTypes.ROSE_GOLD_BOMB.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)RaspberryEntityTypes.SWAP_ARROW.get(), SwapArrowRenderer::new);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)RaspberryBlocks.TEMPORARY_COBWEB.get(), (RenderType)RenderType.m_110463_()));
        RaspberryItemProperties.register();
    }

    public static void clickTick(TickEvent.ClientTickEvent event) {
        FlowerGarlandEvent.tick(Minecraft.m_91087_());
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.RegisterAdditional event) {
        event.register(RaspberryMod.locate("block/cheery_wildflowers_potted"));
        event.register(RaspberryMod.locate("block/moody_wildflowers_potted"));
        event.register(RaspberryMod.locate("block/playful_wildflowers_potted"));
        event.register(RaspberryMod.locate("block/hopeful_wildflowers_potted"));
        event.register(RaspberryMod.locate("block/clovers_potted"));
    }

    public static void registerModsPage(FMLJavaModLoadingContext context) {
        if (ModCompat.CLOTH_CONFIG) {
            context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(ModConfigFactory::createScreen));
        }
    }
}

