/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.emi;

import cc.cassian.raspberry.compat.emi.EmiBeaconBaseRecipe;
import cc.cassian.raspberry.compat.emi.EmiCompat;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EmiBeaconPaymentRecipe
extends EmiBeaconBaseRecipe {
    public static final Map<String, Integer> BEACON_PAYMENTS = Map.ofEntries(Map.entry("additionaladditions:rose_gold_alloy", 45), Map.entry("alloyed:bronze_ingot", 45), Map.entry("alloyed:steel_ingot", 45), Map.entry("caverns_and_chasms:necromium_ingot", 125), Map.entry("create:andesite_alloy", 0), Map.entry("create:brass_ingot", 45), Map.entry("create:zinc_ingot", 15), Map.entry("minecraft:amethyst_shard", 7), Map.entry("minecraft:copper_ingot", 0), Map.entry("minecraft:diamond", 60), Map.entry("minecraft:echo_shard", 75), Map.entry("minecraft:ender_pearl", 60), Map.entry("minecraft:gold_ingot", 30), Map.entry("minecraft:iron_ingot", 15), Map.entry("minecraft:netherite_ingot", 150), Map.entry("oreganized:electrum_ingot", 100), Map.entry("oreganized:lead_ingot", 15), Map.entry("oreganized:silver_ingot", 85), Map.entry("spelunkery:cinnabar", 7));
    private static final List<EmiIngredient> BLOCKS;

    @Override
    public EmiRecipeCategory getCategory() {
        return EmiCompat.BEACON_PAYMENT;
    }

    @Override
    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation("raspberry", "/beacon_payment");
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return BLOCKS;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(this.getInputs().get(0), 54, 0);
        int x = 0;
        int y = 25;
        int i = 1;
        for (Map.Entry<String, Integer> s : BEACON_PAYMENTS.entrySet()) {
            widgets.addSlot(this.ingredient(s.getKey()), x, y).recipeContext((EmiRecipe)this).appendTooltip((Component)Component.m_237110_((String)"emi.raspberry.beacon_payment.amplifier", (Object[])new Object[]{s.getValue()}).m_130940_(ChatFormatting.YELLOW));
            if (i != 7) {
                x += 18;
            } else {
                x = 0;
                y += 18;
                i = 0;
            }
            ++i;
        }
    }

    private EmiIngredient ingredient(String s) {
        return EmiBeaconPaymentRecipe.ingredient(Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s))));
    }

    public static EmiIngredient ingredient(Item item) {
        return EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{item.m_7968_()}));
    }

    public static void addBeaconRecipe(EmiRegistry emiRegistry) {
        emiRegistry.addRecipe((EmiRecipe)new EmiBeaconPaymentRecipe());
    }

    static {
        ArrayList<EmiIngredient> blocks = new ArrayList<EmiIngredient>();
        Set<String> strings = BEACON_PAYMENTS.keySet();
        for (String string : strings) {
            Item value = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)string));
            if (value == null) continue;
            blocks.add(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{value.m_7968_()})));
        }
        BLOCKS = blocks;
    }
}

