/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.oreganized;

import cc.cassian.raspberry.config.ModConfig;
import cc.cassian.raspberry.registry.RaspberryAttributes;
import cc.cassian.raspberry.registry.RaspberryParticleTypes;
import cc.cassian.raspberry.registry.RaspberrySoundEvents;
import cc.cassian.raspberry.registry.RaspberryTags;
import com.google.common.collect.Multimap;
import galena.oreganized.content.item.SilverMirrorItem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OreganizedEvents {
    @SubscribeEvent
    public static void onItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        Multimap mods = event.getModifiers();
        if (event.getSlotType() != EquipmentSlot.MAINHAND) {
            return;
        }
        if (stack.m_204117_(RaspberryTags.HAS_KINETIC_DAMAGE) && !mods.containsKey(RaspberryAttributes.KINETIC_DAMAGE.get())) {
            float f;
            Item item = stack.m_41720_();
            if (item instanceof DiggerItem) {
                DiggerItem item2 = (DiggerItem)item;
                f = item2.m_41008_();
            } else {
                item = stack.m_41720_();
                if (item instanceof SwordItem) {
                    SwordItem item3 = (SwordItem)item;
                    f = item3.m_43299_();
                } else {
                    f = 2.0f;
                }
            }
            float damage = f;
            event.addModifier((Attribute)RaspberryAttributes.KINETIC_DAMAGE.get(), new AttributeModifier(UUID.fromString("0191ff58-54d7-711d-8a94-692379277c24"), "Kinetic Damage", (double)(damage / 3.0f), AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public static void onHurtEvent(LivingAttackEvent event) {
        LivingEntity victim = event.getEntity();
        Entity entity = event.getSource().m_7640_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player perp = (Player)entity;
        if (!victim.m_21222_()) {
            return;
        }
        if (!(perp.m_21205_().m_41720_() instanceof SilverMirrorItem)) {
            return;
        }
        Level level = victim.f_19853_;
        BlockPos origin = victim.m_20183_();
        BlockPos closestSilver = OreganizedEvents.findNearestSilverBlock(level, origin);
        if (closestSilver == null) {
            return;
        }
        Vec3 targetPos = Vec3.m_82512_((Vec3i)closestSilver);
        Vec3 velocity = targetPos.m_82546_(victim.m_20182_()).m_82541_();
        level.m_6263_((Player)null, perp.m_20185_(), perp.m_20186_(), perp.m_20189_(), (SoundEvent)RaspberrySoundEvents.SILVER_HIT.get(), perp.m_5720_(), (float)ModConfig.get().mirrorVolumeModifier, 1.0f + (float)(perp.m_217043_().m_188583_() * 0.35));
        for (int i = 0; i < 8; ++i) {
            double offsetX = (victim.m_217043_().m_188500_() - 0.5 * (double)victim.m_20205_()) * 1.5;
            double offsetY = victim.m_217043_().m_188500_() * (double)victim.m_20206_();
            double offsetZ = (victim.m_217043_().m_188500_() - 0.5 * (double)victim.m_20205_()) * 1.5;
            Vec3 finalVelocity = velocity.m_82490_(victim.m_217043_().m_188500_() * 0.225);
            Vec3 spawnPos = victim.m_20182_().m_82520_(offsetX, offsetY, offsetZ);
            level.m_7106_((ParticleOptions)RaspberryParticleTypes.MIRROR.get(), spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, finalVelocity.f_82479_, finalVelocity.f_82480_, finalVelocity.f_82481_);
        }
    }

    @Nullable
    private static BlockPos findNearestSilverBlock(Level level, BlockPos origin) {
        BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
        BlockPos closest = null;
        double closestDistSq = Double.MAX_VALUE;
        int radius = ModConfig.get().mirrorParticleSearchRadius;
        int verticalRadius = ModConfig.get().mirrorVerticalParticleSearchRadius;
        int radiusSq = radius * radius;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -verticalRadius; dy <= verticalRadius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    double distSq;
                    if (dx * dx + dy * dy + dz * dz > radiusSq) continue;
                    searchPos.m_122178_(origin.m_123341_() + dx, origin.m_123342_() + dy, origin.m_123343_() + dz);
                    if (!level.m_46749_((BlockPos)searchPos) || !level.m_8055_((BlockPos)searchPos).m_204336_(RaspberryTags.MIRROR_DETECTABLES) || !((distSq = searchPos.m_123331_((Vec3i)origin)) < closestDistSq)) continue;
                    closestDistSq = distSq;
                    closest = searchPos.m_7949_();
                }
            }
        }
        return closest;
    }
}

