/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.dynamiccrosshair;

import cc.cassian.raspberry.ModCompat;
import cc.cassian.raspberry.compat.QuarkCompat;
import cc.cassian.raspberry.registry.RaspberryTags;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.handler.VanillaBlockHandler;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.item.KnifeItem;
import vectorwing.farmersdelight.common.tag.ModTags;

@Pseudo
@Mixin(value={VanillaBlockHandler.class})
public class VanillaBlockHandlerMixin {
    @WrapOperation(method={"checkToolWithBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;isCorrectToolForDrops(Lnet/minecraft/world/level/block/state/BlockState;)Z")})
    private static boolean fixQuarkGoldTools(Item instance, BlockState state, Operation<Boolean> original) {
        DiggerItem diggerItem;
        if (ModCompat.QUARK && instance instanceof DiggerItem && (diggerItem = (DiggerItem)instance).m_43314_().equals((Object)Tiers.GOLD) && QuarkCompat.checkGold((Item)diggerItem, state)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance, state});
    }

    @Inject(method={"checkToolWithBlock"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void checkShearsTag(CrosshairContext context, CallbackInfoReturnable<Crosshair> cir) {
        if (context.getItem() instanceof ShearsItem) {
            if (context.getBlockState().m_204336_(RaspberryTags.SHEARS_SHOULD_MINE)) {
                cir.setReturnValue((Object)Crosshair.CORRECT_TOOL);
            } else if (context.getBlockState().m_204336_(RaspberryTags.SHEARS_SHOULD_USE)) {
                cir.setReturnValue((Object)Crosshair.USABLE);
            }
        } else if (context.getItem() instanceof KnifeItem) {
            if (context.getBlockState().m_204336_(RaspberryTags.KNIVES_SHOULD_USE)) {
                cir.setReturnValue((Object)Crosshair.USABLE);
            } else if (context.getBlockState().m_204336_(ModTags.MINEABLE_WITH_KNIFE)) {
                cir.setReturnValue((Object)Crosshair.CORRECT_TOOL);
            }
        } else if (context.getItem() instanceof AxeItem && context.getBlockState().m_204336_(RaspberryTags.AXES_SHOULD_USE)) {
            cir.setReturnValue((Object)Crosshair.USABLE);
        } else if (context.getItem() instanceof HoeItem && context.getBlockState().m_204336_(RaspberryTags.HOES_SHOULD_USE)) {
            cir.setReturnValue((Object)Crosshair.USABLE);
        }
    }
}

