/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.minecraft;

import cc.cassian.raspberry.config.ModConfig;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractMinecart.class})
public abstract class AbstractMinecartEntityMixin
extends Entity {
    public AbstractMinecartEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Shadow
    protected abstract boolean m_38129_(BlockPos var1);

    @Shadow
    public abstract Vec3 m_38179_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_7114_();

    @Shadow
    protected abstract double m_7097_();

    @Shadow
    public abstract AbstractMinecart.Type m_6064_();

    @Shadow
    private static Pair<Vec3i, Vec3i> m_38125_(RailShape shape) {
        return Pair.of((Object)Direction.NORTH.m_122436_(), (Object)Direction.SOUTH.m_122436_());
    }

    @Unique
    private static boolean raspberryCore$isEligibleFastRail(BlockState state) {
        return state.m_60713_(Blocks.f_50156_) || state.m_60713_(Blocks.f_50030_) && (Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_) != false;
    }

    @Unique
    private static RailShape raspberryCore$getRailShape(BlockState state) {
        Block block = state.m_60734_();
        if (!(block instanceof BaseRailBlock)) {
            throw new IllegalArgumentException("No rail shape found");
        }
        BaseRailBlock railBlock = (BaseRailBlock)block;
        return (RailShape)state.m_61143_(railBlock.m_7978_());
    }

    @Inject(at={@At(value="HEAD")}, method={"moveAlongTrack"}, cancellable=true)
    protected void moveAlongTrackOverwrite(BlockPos pos, BlockState state, CallbackInfo ci) {
        if (this.m_6064_() != AbstractMinecart.Type.RIDEABLE) {
            return;
        }
        boolean hasLivingRider = this.m_146895_() instanceof LivingEntity;
        if (!hasLivingRider) {
            return;
        }
        if (!ModConfig.get().raspberryCartEngine) {
            return;
        }
        this.raspberryCore$modifiedMoveAlongTrack(pos, state);
        ci.cancel();
    }

    @Unique
    protected void raspberryCore$modifiedMoveAlongTrack(BlockPos startPos, BlockState state) {
        double w;
        double v;
        double x;
        Entity entity;
        BlockPos exitPos2;
        boolean movementIsBackwards;
        Level level = this.m_9236_();
        double tps = 20.0;
        double maxSpeed = 1.7;
        double maxMomentum = 8.5;
        double vanillaMaxSpeed = 0.4;
        double vanillaMaxMomentum = 2.0;
        this.m_183634_();
        double thisX = this.m_20185_();
        double thisY = this.m_20186_();
        double thisZ = this.m_20189_();
        Vec3 vec3 = this.m_38179_(thisX, thisY, thisZ);
        thisY = startPos.m_123342_();
        boolean onPoweredRail = false;
        boolean onBrakeRail = false;
        if (state.m_60713_(Blocks.f_50030_)) {
            onPoweredRail = (Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_);
            onBrakeRail = !onPoweredRail;
        }
        double g = 0.0078125;
        if (this.m_20069_()) {
            g *= 0.2;
        }
        Vec3 momentum = this.m_20184_();
        RailShape railShape = AbstractMinecartEntityMixin.raspberryCore$getRailShape(state);
        boolean isAscending = railShape.m_61745_();
        boolean isDiagonal = railShape == RailShape.SOUTH_WEST || railShape == RailShape.NORTH_EAST || railShape == RailShape.SOUTH_EAST || railShape == RailShape.NORTH_WEST;
        switch (railShape) {
            case ASCENDING_EAST: {
                this.m_20256_(momentum.m_82520_(-g, 0.0, 0.0));
                thisY += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.m_20256_(momentum.m_82520_(g, 0.0, 0.0));
                thisY += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.m_20256_(momentum.m_82520_(0.0, 0.0, g));
                thisY += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.m_20256_(momentum.m_82520_(0.0, 0.0, -g));
                thisY += 1.0;
            }
        }
        momentum = this.m_20184_();
        Pair<Vec3i, Vec3i> exitPair = AbstractMinecartEntityMixin.m_38125_(railShape);
        Vec3i exitRelPos1 = (Vec3i)exitPair.getFirst();
        Vec3i exitRelPos2 = (Vec3i)exitPair.getSecond();
        double exitDiffX = exitRelPos2.m_123341_() - exitRelPos1.m_123341_();
        double exitDiffZ = exitRelPos2.m_123343_() - exitRelPos1.m_123343_();
        double exitHypotenuse = Math.sqrt(exitDiffX * exitDiffX + exitDiffZ * exitDiffZ);
        double k = momentum.f_82479_ * exitDiffX + momentum.f_82481_ * exitDiffZ;
        boolean bl = movementIsBackwards = k < 0.0;
        if (movementIsBackwards) {
            exitDiffX = -exitDiffX;
            exitDiffZ = -exitDiffZ;
        }
        double horizontalMomentum = Math.min(this.m_20184_().m_165924_(), 8.5);
        this.m_20256_(new Vec3(horizontalMomentum * exitDiffX / exitHypotenuse, momentum.f_82480_, horizontalMomentum * exitDiffZ / exitHypotenuse));
        BlockPos pos = isAscending ? startPos.m_7494_() : startPos;
        BlockPos exitPos1 = pos.m_121955_(exitRelPos1);
        if (level.m_8055_(new BlockPos(exitPos1.m_123341_(), exitPos1.m_123342_() - 1, exitPos1.m_123343_())).m_204336_(BlockTags.f_13034_)) {
            exitPos1 = exitPos1.m_7495_();
        }
        if (level.m_8055_(new BlockPos((exitPos2 = pos.m_121955_(exitRelPos2)).m_123341_(), exitPos2.m_123342_() - 1, exitPos2.m_123343_())).m_204336_(BlockTags.f_13034_)) {
            exitPos2 = exitPos2.m_7495_();
        }
        Vec3 posCenter = Vec3.m_82512_((Vec3i)pos);
        Vec3 exit1Center = Vec3.m_82512_((Vec3i)exitPos1);
        Vec3 exit2Center = Vec3.m_82512_((Vec3i)exitPos2);
        Vec3 momentumPos = posCenter.m_82549_(this.m_20184_()).m_82542_(1.0, 0.0, 1.0);
        BlockPos exitPos = momentumPos.m_82554_(exit1Center.m_82542_(1.0, 0.0, 1.0)) < momentumPos.m_82554_(exit2Center.m_82542_(1.0, 0.0, 1.0)) ? exitPos1 : exitPos2;
        BlockState exitState = level.m_8055_(exitPos);
        boolean exitIsAir = exitState.m_60713_(Blocks.f_50016_);
        ArrayList adjRailPositions = new ArrayList();
        Supplier<Double> calculateMaxSpeedForThisTick = () -> {
            double fallback = this.m_7097_();
            if (!this.m_20160_()) {
                return fallback;
            }
            if (this.m_20184_().m_165924_() < 0.4) {
                return fallback;
            }
            if (!AbstractMinecartEntityMixin.raspberryCore$isEligibleFastRail(state)) {
                return fallback;
            }
            HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
            checkedPositions.add(startPos);
            BiFunction<BlockPos, RailShape, ArrayList> checkNeighbors = (checkPos, checkRailShape) -> {
                Pair<Vec3i, Vec3i> nExitPair = AbstractMinecartEntityMixin.m_38125_(checkRailShape);
                ArrayList<Pair> newNeighbors = new ArrayList<Pair>();
                BlockPos sourcePos = checkRailShape.m_61745_() ? checkPos.m_7494_() : checkPos;
                for (Vec3i nExitRelPos : List.of((Vec3i)nExitPair.getFirst(), (Vec3i)nExitPair.getSecond())) {
                    boolean sameDiagonal;
                    BlockPos nPos = sourcePos.m_121955_(nExitRelPos);
                    if (level.m_8055_(new BlockPos(nPos.m_123341_(), nPos.m_123342_() - 1, nPos.m_123343_())).m_204336_(BlockTags.f_13034_)) {
                        nPos = nPos.m_7495_();
                    }
                    if (checkedPositions.contains(nPos)) continue;
                    BlockState nState = level.m_8055_(nPos);
                    if (!AbstractMinecartEntityMixin.raspberryCore$isEligibleFastRail(nState)) {
                        return new ArrayList();
                    }
                    RailShape nShape = AbstractMinecartEntityMixin.raspberryCore$getRailShape(nState);
                    boolean bl = sameDiagonal = railShape == RailShape.SOUTH_WEST && nShape == RailShape.NORTH_EAST || railShape == RailShape.NORTH_EAST && nShape == RailShape.SOUTH_WEST || railShape == RailShape.SOUTH_EAST && nShape == RailShape.NORTH_WEST || railShape == RailShape.NORTH_WEST && nShape == RailShape.SOUTH_EAST;
                    if (nShape != railShape && !sameDiagonal) {
                        return new ArrayList();
                    }
                    checkedPositions.add(nPos);
                    adjRailPositions.add(nPos);
                    newNeighbors.add(Pair.of((Object)nPos, (Object)nShape));
                }
                return newNeighbors;
            };
            ArrayList newNeighbors = checkNeighbors.apply(startPos, railShape);
            double checkFactor = isDiagonal || isAscending ? 2.0 : 1.0;
            int cutoffPoint = 3;
            int sizeToCheck = (int)(2.0 * (3.0 + checkFactor * 1.7));
            sizeToCheck -= sizeToCheck % 2;
            block5: while (!newNeighbors.isEmpty() && adjRailPositions.size() < sizeToCheck) {
                ArrayList tempNewNeighbors = new ArrayList(newNeighbors);
                newNeighbors.clear();
                for (Pair newNeighbor : tempNewNeighbors) {
                    ArrayList result = checkNeighbors.apply((BlockPos)newNeighbor.getFirst(), (RailShape)newNeighbor.getSecond());
                    if (result.isEmpty()) {
                        newNeighbors.clear();
                        continue block5;
                    }
                    newNeighbors.addAll(result);
                }
            }
            int railCountEachDirection = adjRailPositions.size() / 2;
            double cutoffSpeedPerSec = 20.0;
            switch (railCountEachDirection) {
                case 0: 
                case 1: {
                    return fallback;
                }
                case 2: {
                    return 0.6;
                }
                case 3: {
                    return 1.0;
                }
            }
            int railCountPastBegin = railCountEachDirection - 3;
            return (20.0 + 20.0 / checkFactor * (double)railCountPastBegin) / 20.0;
        };
        double maxSpeedForThisTick = Math.min(calculateMaxSpeedForThisTick.get(), 1.7);
        if (isDiagonal || isAscending) {
            maxSpeedForThisTick = Math.min(maxSpeedForThisTick, 1.20207);
        }
        if ((entity = this.m_146895_()) instanceof Player) {
            Vec3 playerDeltaMovement = entity.m_20184_();
            double m = playerDeltaMovement.m_165925_();
            double n = this.m_20184_().m_165925_();
            if (m > 1.0E-4 && n < 0.01) {
                this.m_20256_(this.m_20184_().m_82520_(playerDeltaMovement.f_82479_ * 0.1, 0.0, playerDeltaMovement.f_82481_ * 0.1));
                onBrakeRail = false;
            }
        }
        if (onBrakeRail) {
            momentum = this.m_20184_();
            horizontalMomentum = momentum.m_165924_();
            if (horizontalMomentum < 0.03) {
                this.m_20256_(Vec3.f_82478_);
            } else {
                if (horizontalMomentum > 0.4) {
                    double ratioToSlowdown = 0.4 / horizontalMomentum;
                    this.m_20256_(momentum.m_82542_(ratioToSlowdown, 1.0, ratioToSlowdown));
                }
                double brakeFactor = 0.59;
                this.m_20256_(this.m_20184_().m_82542_(brakeFactor, 0.0, brakeFactor));
            }
        }
        double p = (double)startPos.m_123341_() + 0.5 + (double)exitRelPos1.m_123341_() * 0.5;
        double q = (double)startPos.m_123343_() + 0.5 + (double)exitRelPos1.m_123343_() * 0.5;
        double r = (double)startPos.m_123341_() + 0.5 + (double)exitRelPos2.m_123341_() * 0.5;
        double s = (double)startPos.m_123343_() + 0.5 + (double)exitRelPos2.m_123343_() * 0.5;
        exitDiffX = r - p;
        exitDiffZ = s - q;
        if (exitDiffX == 0.0) {
            x = thisZ - (double)startPos.m_123343_();
        } else if (exitDiffZ == 0.0) {
            x = thisX - (double)startPos.m_123341_();
        } else {
            v = thisX - p;
            w = thisZ - q;
            x = (v * exitDiffX + w * exitDiffZ) * 2.0;
        }
        thisX = p + exitDiffX * x;
        thisZ = q + exitDiffZ * x;
        v = this.m_20160_() ? 0.75 : 1.0;
        w = maxSpeedForThisTick;
        momentum = this.m_20184_();
        Vec3 movement = new Vec3(Mth.m_14008_((double)(v * momentum.f_82479_), (double)(-w), (double)w), 0.0, Mth.m_14008_((double)(v * momentum.f_82481_), (double)(-w), (double)w));
        double extraY = 0.0;
        if (railShape.m_61745_() && exitPos.m_123342_() > startPos.m_123342_()) {
            extraY = (int)(0.5 + movement.m_165924_());
            thisY += extraY;
        }
        this.m_6034_(thisX, thisY, thisZ);
        this.m_6478_(MoverType.SELF, movement);
        if (railShape.m_61745_() && !level.m_8055_(new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()))).m_204336_(BlockTags.f_13034_) && !level.m_8055_(new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()))).m_204336_(BlockTags.f_13034_)) {
            if (level.m_8055_(new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 2.0)), Mth.m_14107_((double)this.m_20189_()))).m_204336_(BlockTags.f_13034_)) {
                this.m_6034_(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            } else if (level.m_8055_(new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 3.0)), Mth.m_14107_((double)this.m_20189_()))).m_204336_(BlockTags.f_13034_)) {
                this.m_6034_(this.m_20185_(), this.m_20186_() - 2.0, this.m_20189_());
            }
        }
        this.m_7114_();
        Vec3 vec3d4 = this.m_38179_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (vec3d4 != null && vec3 != null) {
            double aa = (vec3.f_82480_ - vec3d4.f_82480_) * 0.05;
            momentum = this.m_20184_();
            horizontalMomentum = momentum.m_165924_();
            if (horizontalMomentum > 0.0) {
                this.m_20256_(momentum.m_82542_((horizontalMomentum + aa) / horizontalMomentum, 1.0, (horizontalMomentum + aa) / horizontalMomentum));
            }
            this.m_6034_(this.m_20185_(), vec3d4.f_82480_, this.m_20189_());
        }
        int ac = Mth.m_14107_((double)this.m_20185_());
        int ad = Mth.m_14107_((double)this.m_20189_());
        if (ac != startPos.m_123341_() || ad != startPos.m_123343_()) {
            momentum = this.m_20184_();
            horizontalMomentum = momentum.m_165924_();
            this.m_20334_(horizontalMomentum * Mth.m_14008_((double)(ac - startPos.m_123341_()), (double)-1.0, (double)1.0), momentum.f_82480_, horizontalMomentum * Mth.m_14008_((double)(ad - startPos.m_123343_()), (double)-1.0, (double)1.0));
        }
        if (onPoweredRail) {
            momentum = this.m_20184_();
            horizontalMomentum = momentum.m_165924_();
            double basisAccelerationPerTick = 0.021;
            if (horizontalMomentum > 0.01) {
                if (this.m_20160_()) {
                    double basisTicksPerSecond = 10.0;
                    double tickMovementForBasisTps = 0.1;
                    double maxSkippedBlocksToConsider = 3.0;
                    double acceleration = 0.021;
                    double distanceMovedHorizontally = movement.m_165924_();
                    if (distanceMovedHorizontally > 0.1) {
                        acceleration *= Math.min(40.0, distanceMovedHorizontally / 0.1);
                        double highspeedFactor = 1.0 + Mth.m_14008_((double)(-0.45 * (distanceMovedHorizontally / 0.1 / 10.0)), (double)-0.7, (double)2.0);
                        acceleration *= highspeedFactor;
                    }
                    this.m_20256_(momentum.m_82520_(acceleration * (momentum.f_82479_ / horizontalMomentum), 0.0, acceleration * (momentum.f_82481_ / horizontalMomentum)));
                } else {
                    this.m_20256_(momentum.m_82520_(momentum.f_82479_ / horizontalMomentum * 0.06, 0.0, momentum.f_82481_ / horizontalMomentum * 0.06));
                }
            } else {
                momentum = this.m_20184_();
                double ah = momentum.f_82479_;
                double ai = momentum.f_82481_;
                double railStopperAcceleration = 0.336;
                if (railShape == RailShape.EAST_WEST) {
                    if (this.m_38129_(startPos.m_122024_())) {
                        ah = 0.336;
                    } else if (this.m_38129_(startPos.m_122029_())) {
                        ah = -0.336;
                    }
                } else {
                    if (railShape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.m_38129_(startPos.m_122012_())) {
                        ai = 0.336;
                    } else if (this.m_38129_(startPos.m_122019_())) {
                        ai = -0.336;
                    }
                }
                this.m_20334_(ah, momentum.f_82480_, ai);
            }
        }
    }
}

