/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.toms_storage;

import cc.cassian.raspberry.compat.toms_storage.StorageTerminalHelper;
import cc.cassian.raspberry.compat.toms_storage.filters.AnyFilter;
import cc.cassian.raspberry.compat.toms_storage.filters.ModIdFilter;
import cc.cassian.raspberry.compat.toms_storage.filters.TagFilter;
import cc.cassian.raspberry.compat.toms_storage.filters.TooltipFilter;
import cc.cassian.raspberry.compat.toms_storage.tooltips.TooltipCacheLoader;
import cc.cassian.raspberry.config.ModConfig;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.tom.storagemod.gui.AbstractStorageTerminalScreen;
import com.tom.storagemod.gui.PlatformEditBox;
import com.tom.storagemod.gui.StorageTerminalMenu;
import com.tom.storagemod.util.IAutoFillTerminal;
import com.tom.storagemod.util.StoredItemStack;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractStorageTerminalScreen.class}, remap=false)
public abstract class AbstractStorageTerminalScreenMixin {
    @Shadow
    private PlatformEditBox searchField;
    @Shadow
    private boolean refreshItemList;
    @Shadow
    private String searchLast;
    @Shadow
    private StoredItemStack.IStoredItemStackComparator comparator;
    @Shadow
    private Comparator<StoredItemStack> sortComp;
    @Shadow
    private float currentScroll;
    @Shadow
    private int searchType;
    private static final ListeningExecutorService tooltipLoadingExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newWorkStealingPool());
    private static final CacheLoader<StoredItemStack, List<String>> cacheLoader = CacheLoader.asyncReloading((CacheLoader)new TooltipCacheLoader(), (Executor)tooltipLoadingExecutor);
    private static final LoadingCache<StoredItemStack, List<String>> betterTooltipCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(5L)).build(cacheLoader);
    private static final Predicate<StoredItemStack> DEFAULT_PREDICATE = stack -> true;

    @Shadow
    protected abstract void onUpdateSearch(String var1);

    @Shadow
    public abstract void receive(CompoundTag var1);

    @Nullable
    private static Pattern queryToRegex(String regex) {
        try {
            return Pattern.compile(regex, 2);
        }
        catch (PatternSyntaxException e) {
            try {
                return Pattern.compile(Pattern.quote(regex), 2);
            }
            catch (PatternSyntaxException e2) {
                return null;
            }
        }
    }

    @Nonnull
    private static Predicate<StoredItemStack> getStoredItemStackPredicate(String queryPart) {
        Pattern simplePattern = AbstractStorageTerminalScreenMixin.queryToRegex(queryPart);
        Pattern prefixPattern = AbstractStorageTerminalScreenMixin.queryToRegex(queryPart.substring(1));
        Predicate<StoredItemStack> newPredicate = queryPart.startsWith("@") ? new ModIdFilter(prefixPattern) : (queryPart.startsWith("#") ? new TagFilter(prefixPattern) : (queryPart.startsWith("$") ? new TooltipFilter(betterTooltipCache, prefixPattern) : new AnyFilter(betterTooltipCache, simplePattern)));
        return newPredicate;
    }

    private void resetScroll(StorageTerminalMenu menu, String query) {
        menu.scrollTo(0.0f);
        this.currentScroll = 0.0f;
        if ((this.searchType & 4) > 0) {
            IAutoFillTerminal.sync((String)query);
        }
        if ((this.searchType & 2) > 0) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("s", query);
            menu.sendMessage(nbt);
        }
        this.onUpdateSearch(query);
    }

    private Predicate<StoredItemStack> buildQueryPredicate(String query) {
        return Arrays.stream(query.split(" ")).filter(part -> !part.isEmpty()).map(String::toLowerCase).map(AbstractStorageTerminalScreenMixin::getStoredItemStackPredicate).reduce(DEFAULT_PREDICATE, Predicate::and);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildSortedItemList(StorageTerminalMenu menu, String query) {
        Predicate<StoredItemStack> queryPredicate = this.buildQueryPredicate(query);
        menu.itemListClientSorted.clear();
        List syncedList = Collections.synchronizedList(new ArrayList());
        TooltipCacheLoader.setFakeShiftLock(true);
        menu.itemListClient.parallelStream().filter(queryPredicate).forEach(syncedList::add);
        TooltipCacheLoader.setFakeShiftLock(false);
        syncedList.sort(menu.noSort ? this.sortComp : this.comparator);
        ReentrantReadWriteLock.WriteLock writeLock = StorageTerminalHelper.rwLock.writeLock();
        try {
            writeLock.lock();
            menu.itemListClientSorted = syncedList;
        }
        finally {
            writeLock.unlock();
        }
        if (!this.searchLast.equals(query)) {
            this.resetScroll(menu, query);
        } else {
            menu.scrollTo(this.currentScroll);
        }
        this.refreshItemList = false;
        this.searchLast = query;
    }

    @Inject(method={"updateSearch()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateSearch(CallbackInfo ci) {
        ci.cancel();
        String query = this.searchField.m_94155_();
        if (!this.refreshItemList && this.searchLast.equals(query)) {
            return;
        }
        AbstractStorageTerminalScreen screen = (AbstractStorageTerminalScreen)this;
        StorageTerminalMenu menu = (StorageTerminalMenu)screen.m_6262_();
        this.rebuildSortedItemList(menu, query);
    }

    @WrapOperation(method={"render"}, at={@At(value="FIELD", target="Lcom/tom/storagemod/gui/StorageTerminalMenu;beaconLvl:I", remap=false, opcode=180)}, remap=true)
    private int fakeBeaconLevel(StorageTerminalMenu instance, Operation<Integer> original) {
        if (ModConfig.get().toms_hideBeacon) {
            return 0;
        }
        return (Integer)original.call(new Object[]{instance});
    }
}

