/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.mixin.vc_gliders;

import cc.cassian.raspberry.config.ModConfig;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.venturecraft.gliders.util.GliderUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GliderUtil.class})
public class GliderUtilMixin {
    @WrapOperation(method={"onTickPlayerGlide"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;setDamageValue(I)V")})
    private static void fixUnbreaking(ItemStack instance, int damage, Operation<Void> original, @Local ServerPlayer player, @Local int damageAmount) {
        instance.m_41622_(damageAmount, (LivingEntity)player, player1 -> player1.m_21166_(EquipmentSlot.CHEST));
    }

    @WrapOperation(method={"lightningLogic"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isRainingAt(Lnet/minecraft/core/BlockPos;)Z")})
    private static boolean disableLightningStrikes(Level instance, BlockPos blockPos, Operation<Boolean> original) {
        if (ModConfig.get().gliders_disableLightning) {
            return false;
        }
        return (Boolean)original.call(new Object[]{instance, blockPos});
    }

    @WrapOperation(method={"handleNetherLogic"}, remap=false, at={@At(value="INVOKE", target="Lnet/venturecraft/gliders/common/item/GliderItem;hasNetherUpgrade(Lnet/minecraft/world/item/ItemStack;)Z")})
    private static boolean disableNetherDamage(ItemStack itemStack, Operation<Boolean> original) {
        if (ModConfig.get().gliders_disableNetherDamage) {
            return true;
        }
        return (Boolean)original.call(new Object[]{itemStack});
    }

    @WrapOperation(method={"onTickPlayerGlide"}, remap=false, at={@At(value="INVOKE", target="Lnet/venturecraft/gliders/common/item/GliderItem;hasNetherUpgrade(Lnet/minecraft/world/item/ItemStack;)Z")})
    private static boolean disableGlideNetherDamage(ItemStack itemStack, Operation<Boolean> original) {
        if (ModConfig.get().gliders_disableNetherDamage) {
            return true;
        }
        return (Boolean)original.call(new Object[]{itemStack});
    }

    @Inject(method={"isGlidingWithActiveGlider"}, remap=false, at={@At(value="TAIL")}, cancellable=true)
    private static void theDeadCantGlide(LivingEntity livingEntity, CallbackInfoReturnable<Boolean> cir) {
        if (!livingEntity.m_6084_() || livingEntity.m_20159_()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"canDeployHere"}, remap=false, at={@At(value="TAIL")}, cancellable=true)
    private static void noBoatDeploy(LivingEntity livingEntity, CallbackInfoReturnable<Boolean> cir) {
        if (livingEntity.m_20159_()) {
            cir.setReturnValue((Object)false);
        }
    }
}

