/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.registry;

import cc.cassian.raspberry.ModCompat;
import cc.cassian.raspberry.blocks.AshBlock;
import cc.cassian.raspberry.blocks.BrickCounterBlock;
import cc.cassian.raspberry.blocks.DirectionalSlabBlock;
import cc.cassian.raspberry.blocks.FineWoodWall;
import cc.cassian.raspberry.blocks.FlowerBedBlock;
import cc.cassian.raspberry.blocks.FlowerGarlandBlock;
import cc.cassian.raspberry.blocks.GravitationalSnowLayerBlock;
import cc.cassian.raspberry.blocks.LemonPancakeBlock;
import cc.cassian.raspberry.blocks.RaspberryCakeBlock;
import cc.cassian.raspberry.blocks.RaspberryGravelBlock;
import cc.cassian.raspberry.blocks.RedMossBlock;
import cc.cassian.raspberry.blocks.TemporaryCobwebBlock;
import cc.cassian.raspberry.compat.CopperBackportCompat;
import cc.cassian.raspberry.compat.EnvironmentalCompat;
import cc.cassian.raspberry.registry.BlockSupplier;
import cc.cassian.raspberry.registry.RaspberryItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RakedGravelBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class RaspberryBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"raspberry");
    public static final Map<ResourceLocation, RegistryObject<Block>> POTTED_PLANTS = new HashMap<ResourceLocation, RegistryObject<Block>>();
    public static final Supplier<Block> TEMPORARY_COBWEB = RaspberryBlocks.registerBlock("temporary_cobweb", () -> new TemporaryCobwebBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50033_)));
    public static BlockSupplier SILT_STOVE = RaspberryBlocks.registerBlock("silt_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModBlocks.STOVE.get()))), FarmersDelight.CREATIVE_TAB);
    public static BlockSupplier ASH_STOVE = RaspberryBlocks.registerBlock("ash_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModBlocks.STOVE.get()))), FarmersDelight.CREATIVE_TAB);
    public static BlockSupplier LEAD_GRATE = RaspberryBlocks.registerLeadGrate();
    public static BlockSupplier WORMY_DIRT = RaspberryBlocks.registerBlock("wormy_dirt", () -> new Block(RaspberryBlocks.getTruffleProperties()), CreativeModeTab.f_40749_);
    public static BlockSupplier RAKED_BLACKSTONE_GRAVEL = RaspberryBlocks.registerBlock("raked_blackstone_gravel", () -> new RakedGravelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_)), CreativeModeTab.f_40749_);
    public static BlockSupplier RAKED_DEEPSLATE_GRAVEL = RaspberryBlocks.registerBlock("raked_deepslate_gravel", () -> new RakedGravelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_)), CreativeModeTab.f_40749_);
    public static BlockSupplier BLACKSTONE_GRAVEL = RaspberryBlocks.registerBlock("blackstone_gravel", () -> new RaspberryGravelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_), 986379), CreativeModeTab.f_40749_);
    public static BlockSupplier DEEPSLATE_GRAVEL = RaspberryBlocks.registerBlock("deepslate_gravel", () -> new RaspberryGravelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_), 2039584), CreativeModeTab.f_40749_);
    public static BlockSupplier CHEERFUL_WILDFLOWERS = RaspberryBlocks.registerBlock("cheery_wildflowers", () -> new FlowerBedBlock(RaspberryBlocks.flowerBedProperties(false)), CreativeModeTab.f_40750_);
    public static BlockSupplier PINK_PETALS = RaspberryBlocks.registerBlock("pink_petals", () -> new FlowerBedBlock(RaspberryBlocks.flowerBedProperties(false)), CreativeModeTab.f_40750_);
    public static BlockSupplier CLOVERS = RaspberryBlocks.registerBlock("clovers", () -> new FlowerBedBlock(RaspberryBlocks.flowerBedProperties(true)), CreativeModeTab.f_40750_);
    public static BlockSupplier MOODY_WILDFLOWERS = RaspberryBlocks.registerBlock("moody_wildflowers", () -> new FlowerBedBlock(RaspberryBlocks.flowerBedProperties(false)), CreativeModeTab.f_40750_);
    public static BlockSupplier HOPEFUL_WILDFLOWERS = RaspberryBlocks.registerBlock("hopeful_wildflowers", () -> new FlowerBedBlock(RaspberryBlocks.flowerBedProperties(false)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> POTTED_CHEERY_WILDFLOWERS = RaspberryBlocks.registerPottedPlant(CHEERFUL_WILDFLOWERS);
    public static final RegistryObject<Block> POTTED_HOPEFUL_WILDFLOWERS = RaspberryBlocks.registerPottedPlant(HOPEFUL_WILDFLOWERS);
    public static final RegistryObject<Block> POTTED_PLAYFUL_WILDFLOWERS = RaspberryBlocks.registerPottedPlant(PINK_PETALS);
    public static final RegistryObject<Block> POTTED_MOODY_WILDFLOWERS = RaspberryBlocks.registerPottedPlant(MOODY_WILDFLOWERS);
    public static final RegistryObject<Block> POTTED_CLOVERS = RaspberryBlocks.registerPottedPlant(CLOVERS);
    public static RegistryObject<Block> CHEERY_WILDFLOWER_GARLAND = BLOCKS.register("cheery_wildflower_garland", () -> new FlowerGarlandBlock(RaspberryBlocks.flowerBedProperties(false)));
    public static RegistryObject<Block> HOPEFUL_WILDFLOWER_GARLAND = BLOCKS.register("hopeful_wildflower_garland", () -> new FlowerGarlandBlock(RaspberryBlocks.flowerBedProperties(false)));
    public static RegistryObject<Block> PLAYFUL_WILDFLOWER_GARLAND = BLOCKS.register("playful_wildflower_garland", () -> new FlowerGarlandBlock(RaspberryBlocks.flowerBedProperties(false)));
    public static RegistryObject<Block> MOODY_WILDFLOWER_GARLAND = BLOCKS.register("moody_wildflower_garland", () -> new FlowerGarlandBlock(RaspberryBlocks.flowerBedProperties(false)));
    public static BlockSupplier CAKE = RaspberryBlocks.registerBlock("cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "farmersdelight:cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier CHOCOLATE_CAKE = RaspberryBlocks.registerBlock("chocolate_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "abnormals_delight:chocolate_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier STRAWBERRY_CAKE = RaspberryBlocks.registerBlock("strawberry_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "abnormals_delight:strawberry_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier BANANA_CAKE = RaspberryBlocks.registerBlock("banana_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "abnormals_delight:banana_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier MINT_CAKE = RaspberryBlocks.registerBlock("mint_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "abnormals_delight:mint_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier VANILLA_CAKE = RaspberryBlocks.registerBlock("vanilla_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "abnormals_delight:vanilla_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier CHERRY_CAKE = RaspberryBlocks.registerBlock("cherry_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "abnormals_delight:adzuki_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier MAGMA_CAKE = RaspberryBlocks.registerBlock("magma_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "mynethersdelight:magma_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier GREEN_TEA_CAKE = RaspberryBlocks.registerBlock("green_tea_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "respiteful:green_tea_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier YELLOW_TEA_CAKE = RaspberryBlocks.registerBlock("yellow_tea_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "respiteful:yellow_tea_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier BLACK_TEA_CAKE = RaspberryBlocks.registerBlock("black_tea_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "respiteful:black_tea_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier COFFEE_CAKE = RaspberryBlocks.registerBlock("coffee_cake", () -> new RaspberryCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), "farmersrespite:coffee_cake_slice"), CreativeModeTab.f_40750_);
    public static BlockSupplier SNOW_LAYER = RaspberryBlocks.registerBlock("snow", () -> new GravitationalSnowLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50125_)), CreativeModeTab.f_40750_);
    public static BlockSupplier ASH_BLOCK = RaspberryBlocks.registerBlock("ash_block", () -> new AshBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModRegistry.ASH_BLOCK.get()))), CreativeModeTab.f_40749_);
    public static BlockSupplier RED_MOSS = RaspberryBlocks.registerBlock("red_moss_block", () -> new RedMossBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152544_).m_155949_(MaterialColor.f_76364_)), CreativeModeTab.f_40749_);
    public static BlockSupplier BRICK_COUNTER = RaspberryBlocks.registerBlock("brick_counter", () -> new BrickCounterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_)), CreativeModeTab.f_40749_);
    public static BlockSupplier SILT_BRICK_COUNTER = RaspberryBlocks.registerBlock("silt_brick_counter", () -> new BrickCounterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_)), CreativeModeTab.f_40749_);
    public static BlockSupplier ASH_BRICK_COUNTER = RaspberryBlocks.registerBlock("ash_brick_counter", () -> new BrickCounterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_)), CreativeModeTab.f_40749_);
    public static BlockSupplier RED_MOSS_CARPET = RaspberryBlocks.registerBlock("red_moss_carpet", () -> new CarpetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152544_).m_155949_(MaterialColor.f_76364_)), CreativeModeTab.f_40749_);
    public static Supplier<Block> LEMON_PANCAKE = RaspberryBlocks.registerBlock("lemon_pancake", () -> new LemonPancakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModRegistry.PANCAKE.get()))));
    public static BlockSupplier FINE_WOOD = RaspberryBlocks.registerBlock("fine_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50372_)), CreativeModeTab.f_40749_);
    public static BlockSupplier FINE_WOOD_STAIRS = RaspberryBlocks.registerBlock("fine_wood_stairs", () -> new ModStairBlock(FINE_WOOD.getBlockSupplier(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50372_)), CreativeModeTab.f_40749_);
    public static BlockSupplier FINE_WOOD_SLAB = RaspberryBlocks.registerBlock("fine_wood_slab", () -> new DirectionalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50372_)), CreativeModeTab.f_40749_);
    public static BlockSupplier FINE_WOOD_WALL = RaspberryBlocks.registerBlock("fine_wood_wall", () -> new FineWoodWall(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50372_)), CreativeModeTab.f_40749_);
    public static final ArrayList<BlockSupplier> FOLIAGE_BLOCKS = new ArrayList();

    private static BlockBehaviour.Properties flowerBedProperties(boolean replaceable) {
        Material material = Material.f_76300_;
        if (replaceable) {
            material = Material.f_76302_;
        }
        return BlockBehaviour.Properties.m_60939_((Material)material).m_60910_().m_60918_(SoundType.f_154667_);
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        FOLIAGE_BLOCKS.add(CHEERFUL_WILDFLOWERS);
        FOLIAGE_BLOCKS.add(PINK_PETALS);
        FOLIAGE_BLOCKS.add(MOODY_WILDFLOWERS);
        FOLIAGE_BLOCKS.add(HOPEFUL_WILDFLOWERS);
    }

    public static BlockBehaviour.Properties getTruffleProperties() {
        if (ModCompat.ENVIRONMENTAL) {
            return EnvironmentalCompat.getTruffleProperties();
        }
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_);
    }

    public static BlockSupplier registerLeadGrate() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76281_).m_60955_().m_60913_(5.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56743_);
        if (ModCompat.COPPER_BACKPORT) {
            return CopperBackportCompat.registerGrateBlock(properties);
        }
        return RaspberryBlocks.registerBlock("lead_grate", () -> new Block(properties), CreativeModeTab.f_40749_);
    }

    public static BlockSupplier registerBlock(String blockID, Supplier<Block> blockSupplier, CreativeModeTab tab) {
        RegistryObject block = BLOCKS.register(blockID, blockSupplier);
        RegistryObject item = RaspberryItems.ITEMS.register(blockID, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
        return new BlockSupplier(blockID, (RegistryObject<Block>)block, (RegistryObject<BlockItem>)item);
    }

    public static Supplier<Block> registerBlock(String blockID, Supplier<Block> blockSupplier) {
        return BLOCKS.register(blockID, blockSupplier);
    }

    public static void addPottedPlants() {
        POTTED_PLANTS.forEach((arg_0, arg_1) -> ((FlowerPotBlock)((FlowerPotBlock)Blocks.f_50276_)).addPlant(arg_0, arg_1));
    }

    public static RegistryObject<Block> registerPottedPlant(BlockSupplier block) {
        RegistryObject pottedBlock = BLOCKS.register("potted_" + block.getID(), () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, block.getBlockSupplier(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
        POTTED_PLANTS.put(block.getItemSupplier().getId(), (RegistryObject<Block>)pottedBlock);
        return pottedBlock;
    }
}

