/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.registry;

import cc.cassian.raspberry.client.particle.FlowerPetalParticle;
import cc.cassian.raspberry.client.particle.SwapArrowPortalParticle;
import net.minecraft.client.particle.PlayerCloudParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="raspberry", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RaspberryParticleTypes {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"raspberry");
    public static final RegistryObject<SimpleParticleType> MIRROR = RaspberryParticleTypes.registerSimpleParticleType(true, "mirror");
    public static final RegistryObject<SimpleParticleType> CHEERY_PETAL = RaspberryParticleTypes.registerSimpleParticleType(true, "cheery_petal");
    public static final RegistryObject<SimpleParticleType> PLAYFUL_PETAL = RaspberryParticleTypes.registerSimpleParticleType(true, "playful_petal");
    public static final RegistryObject<SimpleParticleType> HOPEFUL_PETAL = RaspberryParticleTypes.registerSimpleParticleType(true, "hopeful_petal");
    public static final RegistryObject<SimpleParticleType> MOODY_PETAL = RaspberryParticleTypes.registerSimpleParticleType(true, "moody_petal");
    public static final RegistryObject<SimpleParticleType> SWAP_ARROW_PORTAL = RaspberryParticleTypes.registerSimpleParticleType(true, "swap_arrow_portal");

    private static RegistryObject<SimpleParticleType> registerSimpleParticleType(boolean alwaysShow, String name) {
        return PARTICLE_TYPES.register(name, () -> new SimpleParticleType(alwaysShow));
    }

    @Mod.EventBusSubscriber(modid="raspberry", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class RegisterParticles {
        @SubscribeEvent
        public static void registerParticleTypes(RegisterParticleProvidersEvent event) {
            event.register((ParticleType)MIRROR.get(), PlayerCloudParticle.Provider::new);
            event.register((ParticleType)CHEERY_PETAL.get(), FlowerPetalParticle.Provider::new);
            event.register((ParticleType)PLAYFUL_PETAL.get(), FlowerPetalParticle.Provider::new);
            event.register((ParticleType)HOPEFUL_PETAL.get(), FlowerPetalParticle.Provider::new);
            event.register((ParticleType)MOODY_PETAL.get(), FlowerPetalParticle.Provider::new);
            event.register((ParticleType)SWAP_ARROW_PORTAL.get(), SwapArrowPortalParticle.Provider::new);
        }
    }
}

