/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.emi;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.kinetics.deployer.DeployerBlock;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.gui.CustomLightingSettings;
import com.simibubi.create.foundation.gui.ILightingSettings;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class CreateEmiAnimations {
    private static final BlockState WHEEL = (BlockState)AllBlocks.CRUSHING_WHEEL.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
    public static final ILightingSettings DEFAULT_LIGHTING = CustomLightingSettings.builder().firstLightRotation(12.5f, 45.0f).secondLightRotation(-20.0f, 50.0f).build();

    public static GuiGameElement.GuiRenderBuilder defaultBlockElement(BlockState state) {
        return GuiGameElement.of((BlockState)state).lighting(DEFAULT_LIGHTING);
    }

    public static GuiGameElement.GuiRenderBuilder defaultBlockElement(PartialModel partial) {
        return GuiGameElement.of((PartialModel)partial).lighting(DEFAULT_LIGHTING);
    }

    public static float getCurrentAngle() {
        return AnimationTickHolder.getRenderTime() * 4.0f % 360.0f;
    }

    public static BlockState shaft(Direction.Axis axis) {
        return (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
    }

    public static PartialModel cogwheel() {
        return AllPartialModels.SHAFTLESS_COGWHEEL;
    }

    public static GuiGameElement.GuiRenderBuilder blockElement(BlockState state) {
        return CreateEmiAnimations.defaultBlockElement(state);
    }

    public static GuiGameElement.GuiRenderBuilder blockElement(PartialModel partial) {
        return CreateEmiAnimations.defaultBlockElement(partial);
    }

    public static void addPress(WidgetHolder widgets, int x, int y, boolean basin) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> CreateEmiAnimations.renderPress(matrices, 0, basin));
    }

    public static void renderPress(PoseStack matrices, int offset, boolean basin) {
        matrices.m_85837_(0.0, 0.0, 200.0);
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(-15.5f));
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(22.5f));
        int scale = basin ? 23 : 24;
        CreateEmiAnimations.blockElement(CreateEmiAnimations.shaft(Direction.Axis.Z)).rotateBlock(0.0, 0.0, (double)CreateEmiAnimations.getCurrentAngle()).scale((double)scale).render(matrices);
        CreateEmiAnimations.blockElement(AllBlocks.MECHANICAL_PRESS.getDefaultState()).scale((double)scale).render(matrices);
        CreateEmiAnimations.blockElement(AllPartialModels.MECHANICAL_PRESS_HEAD).atLocal(0.0, (double)(-CreateEmiAnimations.getAnimatedHeadOffset(offset)), 0.0).scale((double)scale).render(matrices);
        if (basin) {
            CreateEmiAnimations.blockElement(AllBlocks.BASIN.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale((double)scale).render(matrices);
        }
    }

    private static float getAnimatedHeadOffset(int offset) {
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(offset * 8)) % 30.0f;
        if (cycle < 10.0f) {
            float progress = cycle / 10.0f;
            return -(progress * progress * progress);
        }
        if (cycle < 15.0f) {
            return -1.0f;
        }
        if (cycle < 20.0f) {
            return -1.0f + (1.0f - (20.0f - cycle) / 5.0f);
        }
        return 0.0f;
    }

    public static void addBlazeBurner(WidgetHolder widgets, int x, int y, BlazeBurnerBlock.HeatLevel heatLevel) {
        widgets.addDrawable(x, y, 0, 0, (matrixStack, mouseX, mouseY, delta) -> {
            matrixStack.m_85837_(0.0, 0.0, 200.0);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-15.5f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(22.5f));
            int scale = 23;
            float offset = (Mth.m_14031_((float)(AnimationTickHolder.getRenderTime() / 16.0f)) + 0.5f) / 16.0f;
            CreateEmiAnimations.blockElement(AllBlocks.BLAZE_BURNER.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale((double)scale).render(matrixStack);
            PartialModel blaze = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_SUPER : AllPartialModels.BLAZE_ACTIVE;
            PartialModel rods2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
            CreateEmiAnimations.blockElement(blaze).atLocal(1.0, 1.8, 1.0).rotate(0.0, 180.0, 0.0).scale((double)scale).render(matrixStack);
            CreateEmiAnimations.blockElement(rods2).atLocal(1.0, 1.7 + (double)offset, 1.0).rotate(0.0, 180.0, 0.0).scale((double)scale).render(matrixStack);
            matrixStack.m_85841_((float)scale, (float)(-scale), (float)scale);
            matrixStack.m_85837_(0.0, -1.8, 0.0);
            SpriteShiftEntry spriteShift = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            float spriteWidth = spriteShift.getTarget().m_118410_() - spriteShift.getTarget().m_118409_();
            float spriteHeight = spriteShift.getTarget().m_118412_() - spriteShift.getTarget().m_118411_();
            float time = AnimationTickHolder.getRenderTime((LevelAccessor)Minecraft.m_91087_().f_91073_);
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            Minecraft mc = Minecraft.m_91087_();
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            VertexConsumer vb = buffer.m_6299_(RenderType.m_110457_());
            CachedBufferer.partial((PartialModel)AllPartialModels.BLAZE_BURNER_FLAME, (BlockState)Blocks.f_50016_.m_49966_()).shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll).light(0xF000F0).renderInto(matrixStack, vb);
        });
    }

    public static void addMixer(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            matrices.m_85837_(0.0, 0.0, 200.0);
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(-15.5f));
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(22.5f));
            int scale = 23;
            CreateEmiAnimations.blockElement(CreateEmiAnimations.cogwheel()).rotateBlock(0.0, (double)(CreateEmiAnimations.getCurrentAngle() * 2.0f), 0.0).atLocal(0.0, 0.0, 0.0).scale((double)scale).render(matrices);
            CreateEmiAnimations.blockElement(AllBlocks.MECHANICAL_MIXER.getDefaultState()).atLocal(0.0, 0.0, 0.0).scale((double)scale).render(matrices);
            float animation = (Mth.m_14031_((float)(AnimationTickHolder.getRenderTime() / 32.0f)) + 1.0f) / 5.0f + 0.5f;
            CreateEmiAnimations.blockElement(AllPartialModels.MECHANICAL_MIXER_POLE).atLocal(0.0, (double)animation, 0.0).scale((double)scale).render(matrices);
            CreateEmiAnimations.blockElement(AllPartialModels.MECHANICAL_MIXER_HEAD).rotateBlock(0.0, (double)(CreateEmiAnimations.getCurrentAngle() * 4.0f), 0.0).atLocal(0.0, (double)animation, 0.0).scale((double)scale).render(matrices);
            CreateEmiAnimations.blockElement(AllBlocks.BASIN.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale((double)scale).render(matrices);
        });
    }

    public static void addSaw(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> CreateEmiAnimations.renderSaw(matrices, 0));
    }

    public static void renderSaw(PoseStack matrices, int offset) {
        matrices.m_85837_(0.0, 0.0, 200.0);
        matrices.m_85837_(2.0, 22.0, 0.0);
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(-15.5f));
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(112.5f));
        int scale = 25;
        CreateEmiAnimations.blockElement(CreateEmiAnimations.shaft(Direction.Axis.X)).rotateBlock((double)(-CreateEmiAnimations.getCurrentAngle()), 0.0, 0.0).scale((double)scale).render(matrices);
        CreateEmiAnimations.blockElement((BlockState)AllBlocks.MECHANICAL_SAW.getDefaultState().m_61124_((Property)SawBlock.FACING, (Comparable)Direction.UP)).rotateBlock(0.0, 0.0, 0.0).scale((double)scale).render(matrices);
        CreateEmiAnimations.blockElement(AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE).rotateBlock(0.0, -90.0, -90.0).scale((double)scale).render(matrices);
    }

    public static void addMillstone(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            int scale = 22;
            CreateEmiAnimations.blockElement(AllPartialModels.MILLSTONE_COG).rotateBlock(22.5, (double)(CreateEmiAnimations.getCurrentAngle() * 2.0f), 0.0).scale((double)scale).render(matrices);
            CreateEmiAnimations.blockElement(AllBlocks.MILLSTONE.getDefaultState()).rotateBlock(22.5, 22.5, 0.0).scale((double)scale).render(matrices);
        });
    }

    public static void addCrushingWheels(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            matrices.m_85837_(0.0, 0.0, 100.0);
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(-22.5f));
            int scale = 22;
            CreateEmiAnimations.blockElement(WHEEL).rotateBlock(0.0, 90.0, (double)(-CreateEmiAnimations.getCurrentAngle())).scale((double)scale).render(matrices);
            CreateEmiAnimations.blockElement(WHEEL).rotateBlock(0.0, 90.0, (double)CreateEmiAnimations.getCurrentAngle()).atLocal(2.0, 0.0, 0.0).scale((double)scale).render(matrices);
        });
    }

    public static void addFan(WidgetHolder widgets, int x, int y, Consumer<PoseStack> renderAttachedBlock) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            matrices.m_85837_(0.0, 0.0, 200.0);
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(-12.5f));
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(22.5f));
            int scale = 24;
            CreateEmiAnimations.defaultBlockElement(AllPartialModels.ENCASED_FAN_INNER).rotateBlock(180.0, 0.0, (double)(CreateEmiAnimations.getCurrentAngle() * 16.0f)).scale((double)scale).render(matrices);
            CreateEmiAnimations.defaultBlockElement(AllBlocks.ENCASED_FAN.getDefaultState()).rotateBlock(0.0, 180.0, 0.0).atLocal(0.0, 0.0, 0.0).scale((double)scale).render(matrices);
            renderAttachedBlock.accept(matrices);
        });
    }

    public static void addDeployer(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> CreateEmiAnimations.renderDeployer(matrices, 0));
    }

    public static void renderDeployer(PoseStack matrices, int offset) {
        matrices.m_85837_(0.0, 0.0, 100.0);
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(-15.5f));
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(22.5f));
        int scale = 20;
        CreateEmiAnimations.blockElement(CreateEmiAnimations.shaft(Direction.Axis.Z)).rotateBlock(0.0, 0.0, (double)CreateEmiAnimations.getCurrentAngle()).scale((double)scale).render(matrices);
        CreateEmiAnimations.blockElement((BlockState)((BlockState)AllBlocks.DEPLOYER.getDefaultState().m_61124_((Property)DeployerBlock.FACING, (Comparable)Direction.DOWN)).m_61124_((Property)DeployerBlock.AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(false))).scale((double)scale).render(matrices);
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(offset * 8)) % 30.0f;
        float off = cycle < 10.0f ? cycle / 10.0f : (cycle < 20.0f ? (20.0f - cycle) / 10.0f : 0.0f);
        matrices.m_85836_();
        matrices.m_85837_(0.0, (double)(off * 17.0f), 0.0);
        CreateEmiAnimations.blockElement(AllPartialModels.DEPLOYER_POLE).rotateBlock(90.0, 0.0, 0.0).scale((double)scale).render(matrices);
        CreateEmiAnimations.blockElement(AllPartialModels.DEPLOYER_HAND_HOLDING).rotateBlock(90.0, 0.0, 0.0).scale((double)scale).render(matrices);
        matrices.m_85849_();
        CreateEmiAnimations.blockElement(AllBlocks.DEPOT.getDefaultState()).atLocal(0.0, 2.0, 0.0).scale((double)scale).render(matrices);
    }

    public static void addSpout(WidgetHolder widgets, int x, int y, List<FluidStack> fluids) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> CreateEmiAnimations.renderSpout(matrices, 0, fluids));
    }

    public static void renderSpout(PoseStack matrices, int offset, List<FluidStack> fluids) {
        matrices.m_85837_(0.0, 0.0, 100.0);
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(-15.5f));
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(22.5f));
        int scale = 20;
        CreateEmiAnimations.blockElement(AllBlocks.SPOUT.getDefaultState()).scale((double)scale).render(matrices);
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(offset * 8)) % 30.0f;
        float squeeze = cycle < 20.0f ? Mth.m_14031_((float)((float)((double)(cycle / 20.0f) * Math.PI))) : 0.0f;
        matrices.m_85836_();
        CreateEmiAnimations.blockElement(AllPartialModels.SPOUT_TOP).scale((double)scale).render(matrices);
        matrices.m_85837_(0.0, (double)(-3.0f * (squeeze *= 20.0f) / 32.0f), 0.0);
        CreateEmiAnimations.blockElement(AllPartialModels.SPOUT_MIDDLE).scale((double)scale).render(matrices);
        matrices.m_85837_(0.0, (double)(-3.0f * squeeze / 32.0f), 0.0);
        CreateEmiAnimations.blockElement(AllPartialModels.SPOUT_BOTTOM).scale((double)scale).render(matrices);
        matrices.m_85837_(0.0, (double)(-3.0f * squeeze / 32.0f), 0.0);
        matrices.m_85849_();
        CreateEmiAnimations.blockElement(AllBlocks.DEPOT.getDefaultState()).atLocal(0.0, 2.0, 0.0).scale((double)scale).render(matrices);
        DEFAULT_LIGHTING.applyLighting();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrices.m_85836_();
        UIRenderHelper.flipForGuiRender((PoseStack)matrices);
        matrices.m_85841_(16.0f, 16.0f, 16.0f);
        float from = 0.1875f;
        float to = 1.0625f;
        FluidRenderer.renderFluidBox((FluidStack)fluids.get(0), (float)from, (float)from, (float)from, (float)to, (float)to, (float)to, (MultiBufferSource)buffer, (PoseStack)matrices, (int)0xF000F0, (boolean)false);
        matrices.m_85849_();
        float width = 0.0078125f * squeeze;
        matrices.m_85837_((double)((float)scale / 2.0f), (double)((float)scale * 1.5f), (double)((float)scale / 2.0f));
        UIRenderHelper.flipForGuiRender((PoseStack)matrices);
        matrices.m_85841_(16.0f, 16.0f, 16.0f);
        matrices.m_85837_(-0.5, 0.0, -0.5);
        from = -width / 2.0f + 0.5f;
        to = width / 2.0f + 0.5f;
        FluidRenderer.renderFluidBox((FluidStack)fluids.get(0), (float)from, (float)0.0f, (float)from, (float)to, (float)2.0f, (float)to, (MultiBufferSource)buffer, (PoseStack)matrices, (int)0xF000F0, (boolean)false);
        buffer.m_109911_();
        Lighting.m_84931_();
    }

    public static void addDrain(WidgetHolder widgets, int x, int y, FluidStack fluid) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            matrices.m_85837_(0.0, 0.0, 100.0);
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(-15.5f));
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(22.5f));
            int scale = 20;
            CreateEmiAnimations.blockElement(AllBlocks.ITEM_DRAIN.getDefaultState()).scale((double)scale).render(matrices);
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            UIRenderHelper.flipForGuiRender((PoseStack)matrices);
            matrices.m_85841_((float)scale, (float)scale, (float)scale);
            float from = 0.125f;
            float to = 1.0f - from;
            FluidRenderer.renderFluidBox((FluidStack)fluid, (float)from, (float)from, (float)from, (float)to, (float)0.75f, (float)to, (MultiBufferSource)buffer, (PoseStack)matrices, (int)0xF000F0, (boolean)false);
            buffer.m_109911_();
        });
    }

    public static void addCrafter(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(-15.5f));
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(-22.5f));
            int scale = 22;
            CreateEmiAnimations.blockElement(CreateEmiAnimations.cogwheel()).rotateBlock(90.0, 0.0, (double)CreateEmiAnimations.getCurrentAngle()).scale((double)scale).render(matrices);
            CreateEmiAnimations.blockElement(AllBlocks.MECHANICAL_CRAFTER.getDefaultState()).rotateBlock(0.0, 180.0, 0.0).scale((double)scale).render(matrices);
        });
    }
}

