/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.emi.recipes;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.compat.emi.EmiSequencedAssemblySubCategory;
import com.simibubi.create.compat.emi.recipes.SequencedAssemblyEmiRecipe;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Pair;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public abstract class CreateEmiRecipe<T extends Recipe<?>>
implements EmiRecipe {
    protected final EmiRecipeCategory category;
    protected final T recipe;
    protected ResourceLocation id;
    protected List<EmiIngredient> input;
    protected List<EmiStack> output;
    protected int width;
    protected int height;

    public CreateEmiRecipe(EmiRecipeCategory category, T recipe, int width, int height) {
        this.category = category;
        this.recipe = recipe;
        this.id = recipe.m_6423_();
        this.width = width;
        this.height = height;
        if (recipe instanceof BasinRecipe) {
            BasinRecipe basin = (BasinRecipe)recipe;
            ImmutableList.Builder input = ImmutableList.builder();
            ImmutableList.Builder output = ImmutableList.builder();
            for (Pair pair : ItemHelper.condenseIngredients((NonNullList)recipe.m_7527_())) {
                input.add((Object)EmiIngredient.of((Ingredient)((Ingredient)pair.getFirst()), (long)((MutableInt)pair.getSecond()).getValue().intValue()));
            }
            for (FluidIngredient ingredient : basin.getFluidIngredients()) {
                List fluids = ingredient.getMatchingFluidStacks();
                if (fluids.isEmpty()) continue;
                input.add((Object)CreateEmiRecipe.fluidStack((FluidStack)fluids.get(0)));
            }
            for (ItemStack stack : basin.getRollableResultsAsItemStacks()) {
                output.add((Object)EmiStack.of((ItemStack)stack));
            }
            for (ItemStack stack : basin.getFluidResults()) {
                output.add((Object)CreateEmiRecipe.fluidStack((FluidStack)stack));
            }
            this.input = input.build();
            this.output = output.build();
        } else if (recipe instanceof SequencedAssemblyRecipe) {
            SequencedAssemblyRecipe sequenced = (SequencedAssemblyRecipe)recipe;
            this.output = List.of(EmiStack.of((ItemStack)recipe.m_8043_()).setChance(sequenced.getOutputChance()));
            int loops = sequenced.getLoops();
            ImmutableList.Builder input = ImmutableList.builder();
            input.add((Object)EmiIngredient.of((Ingredient)sequenced.getIngredient()));
            for (SequencedRecipe sequence : sequenced.getSequence()) {
                EmiStack stack;
                EmiSequencedAssemblySubCategory subCategory = SequencedAssemblyEmiRecipe.getSubCategory(sequence);
                EmiIngredient ingredient = subCategory.getAppliedIngredient(sequence);
                if (ingredient == null) continue;
                input.add((Object)ingredient);
                if (ingredient instanceof EmiStack && (stack = (EmiStack)ingredient).getRemainder() == stack) continue;
                ingredient.setAmount(ingredient.getAmount() * (long)loops);
            }
            this.input = input.build();
        } else {
            this.input = recipe.m_7527_().stream().map(EmiIngredient::of).toList();
            if (recipe instanceof ProcessingRecipe) {
                ProcessingRecipe processing = (ProcessingRecipe)recipe;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (ProcessingOutput output : processing.getRollableResults()) {
                    builder.add((Object)EmiStack.of((ItemStack)output.getStack()).setChance(output.getChance()));
                }
                this.output = builder.build();
            } else {
                this.output = List.of(EmiStack.of((ItemStack)recipe.m_8043_()));
            }
        }
    }

    public CreateEmiRecipe(EmiRecipeCategory category, T recipe, int width, int height, Consumer<CreateEmiRecipe<T>> setup) {
        this.category = category;
        this.recipe = recipe;
        this.id = recipe.m_6423_();
        this.width = width;
        this.height = height;
        setup.accept(this);
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public static SlotWidget addSlot(WidgetHolder widgets, EmiIngredient stack, int x, int y) {
        AllGuiTextures texture = stack.getChance() == 1.0f ? AllGuiTextures.JEI_SLOT : AllGuiTextures.JEI_CHANCE_SLOT;
        return CreateEmiRecipe.addSlot(widgets, stack, x, y, texture);
    }

    public static SlotWidget addSlot(WidgetHolder widgets, EmiIngredient stack, int x, int y, AllGuiTextures texture) {
        return ((SlotWidget)widgets.add((Widget)new SlotWidget(stack, x, y))).backgroundTexture(texture.location, texture.startX, texture.startY);
    }

    public static EmiStack fluidStack(FluidStack stack) {
        return EmiStack.of((Fluid)stack.getFluid(), (CompoundTag)stack.getTag(), (long)stack.getAmount());
    }

    public static TextureWidget addTexture(WidgetHolder widgets, AllGuiTextures texture, int x, int y) {
        return widgets.addTexture(texture.location, x, y, texture.width, texture.height, texture.startX, texture.startY);
    }

    public static <T, U> U firstOrElse(List<T> list, U empty, Function<T, U> function) {
        return list.isEmpty() ? empty : function.apply(list.get(0));
    }

    public static EmiIngredient firstIngredientOrEmpty(List<Ingredient> ingredients) {
        return CreateEmiRecipe.firstOrElse(ingredients, EmiStack.EMPTY, EmiIngredient::of);
    }

    public static EmiStack firstFluidOrEmpty(List<FluidStack> fluids) {
        return CreateEmiRecipe.firstOrElse(fluids, EmiStack.EMPTY, CreateEmiRecipe::fluidStack);
    }

    public static EmiStack firstResultOrEmpty(List<ProcessingOutput> outputs) {
        return CreateEmiRecipe.firstOrElse(outputs, EmiStack.EMPTY, output -> EmiStack.of((ItemStack)output.getStack()));
    }
}

