/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.emi.recipes;

import com.simibubi.create.compat.emi.CreateEmiPlugin;
import com.simibubi.create.compat.emi.EmiSequencedAssemblySubCategory;
import com.simibubi.create.compat.emi.recipes.CreateEmiRecipe;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.crafting.Ingredient;

public class SequencedAssemblyEmiRecipe
extends CreateEmiRecipe<SequencedAssemblyRecipe> {
    public static final String[] ROMAN = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII", "XIX", "XX", "XXI", "XXII", "XXIII", "XXIV", "XXV", "XXVI", "XXVII", "XXVIII", "XXIX", "-"};
    private final int margin = 3;
    private int width;

    public SequencedAssemblyEmiRecipe(SequencedAssemblyRecipe recipe) {
        super(CreateEmiPlugin.SEQUENCED_ASSEMBLY, recipe, 180, 120);
        for (SequencedRecipe r : recipe.getSequence()) {
            this.width += SequencedAssemblyEmiRecipe.getSubCategory(r).getWidth() + 3;
        }
        this.width -= 3;
    }

    @Override
    public int getDisplayWidth() {
        return Math.max(150, this.width);
    }

    public void addWidgets(WidgetHolder widgets) {
        int sx;
        int xOff = ((SequencedAssemblyRecipe)this.recipe).getOutputChance() == 1.0f ? 0 : -7;
        int mid = widgets.getWidth() / 2;
        SequencedAssemblyEmiRecipe.addTexture(widgets, AllGuiTextures.JEI_LONG_ARROW, mid - 38 + xOff, 94);
        widgets.addDrawable(mid - 38 + xOff, 94, AllGuiTextures.JEI_LONG_ARROW.width, 20, (matrices, mx, my, delta) -> {}).tooltip((mouseX, mouseY) -> List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Lang.translateDirect((String)"recipe.assembly.repeat", (Object[])new Object[]{((SequencedAssemblyRecipe)this.recipe).getLoops()}).m_7532_())));
        if (((SequencedAssemblyRecipe)this.recipe).getOutputChance() != 1.0f) {
            float chance = ((SequencedAssemblyRecipe)this.recipe).getOutputChance();
            SequencedAssemblyEmiRecipe.addTexture(widgets, AllGuiTextures.JEI_CHANCE_SLOT, mid + 60 + xOff, 90).tooltip((mouseX, mouseY) -> List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Lang.translateDirect((String)"recipe.assembly.junk", (Object[])new Object[0]).m_7532_()), ClientTooltipComponent.m_169948_((FormattedCharSequence)Components.translatable((String)"tooltip.emi.chance.produce", (Object[])new Object[]{(double)chance > 0.99 ? "<1" : Integer.valueOf(100 - (int)(chance * 100.0f))}).m_130940_(ChatFormatting.GOLD).m_7532_())));
        }
        SequencedAssemblyEmiRecipe.addSlot(widgets, EmiIngredient.of((Ingredient)((SequencedAssemblyRecipe)this.recipe).getIngredient()), mid - 64 + xOff, 90);
        SequencedAssemblyEmiRecipe.addSlot(widgets, (EmiIngredient)this.output.get(0), mid + 41 + xOff, 90).recipeContext((EmiRecipe)this);
        int x = sx = this.width / -2 + mid;
        int index = 0;
        for (SequencedRecipe recipe : ((SequencedAssemblyRecipe)this.recipe).getSequence()) {
            EmiSequencedAssemblySubCategory category = SequencedAssemblyEmiRecipe.getSubCategory(recipe);
            category.addWidgets(widgets, x, 0, recipe, index++);
            x += category.getWidth() + 3;
        }
        widgets.addDrawable(0, 0, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            Minecraft client = Minecraft.m_91087_();
            matrices.m_85836_();
            matrices.m_85837_(0.0, 15.0, 0.0);
            if (((SequencedAssemblyRecipe)this.recipe).getOutputChance() != 1.0f) {
                client.f_91062_.m_92750_(matrices, "?", (float)(mid + 69 + xOff - client.f_91062_.m_92895_("?") / 2), 80.0f, 0xEFEFEF);
            }
            if (((SequencedAssemblyRecipe)this.recipe).getLoops() > 1) {
                matrices.m_85836_();
                matrices.m_85837_(15.0, 9.0, 0.0);
                AllIcons.I_SEQ_REPEAT.render(matrices, mid - 40 + xOff, 75);
                client.f_91062_.m_92750_(matrices, "x" + ((SequencedAssemblyRecipe)this.recipe).getLoops(), (float)(mid - 24 + xOff), 80.0f, 0x888888);
                matrices.m_85849_();
            }
            matrices.m_85849_();
            int cx = sx;
            for (int i = 0; i < ((SequencedAssemblyRecipe)this.recipe).getSequence().size(); ++i) {
                String text = ROMAN[Math.min(i, ROMAN.length)];
                int w = SequencedAssemblyEmiRecipe.getSubCategory((SequencedRecipe)((SequencedAssemblyRecipe)this.recipe).getSequence().get(i)).getWidth();
                int off = w / 2 - client.f_91062_.m_92895_(text) / 2;
                client.f_91062_.m_92750_(matrices, text, (float)(cx + off), 2.0f, 0x888888);
                cx += w + 3;
            }
        });
    }

    public static EmiSequencedAssemblySubCategory getSubCategory(SequencedRecipe<?> recipe) {
        SequencedAssemblySubCategory sequencedAssemblySubCategory = (SequencedAssemblySubCategory)((Supplier)recipe.getAsAssemblyRecipe().getJEISubCategory().get()).get();
        if (sequencedAssemblySubCategory instanceof SequencedAssemblySubCategory.AssemblyPressing) {
            SequencedAssemblySubCategory.AssemblyPressing assemblyPressing = (SequencedAssemblySubCategory.AssemblyPressing)sequencedAssemblySubCategory;
            return new EmiSequencedAssemblySubCategory.AssemblyPressing();
        }
        if (sequencedAssemblySubCategory instanceof SequencedAssemblySubCategory.AssemblySpouting) {
            SequencedAssemblySubCategory.AssemblySpouting assemblyPressing = (SequencedAssemblySubCategory.AssemblySpouting)sequencedAssemblySubCategory;
            return new EmiSequencedAssemblySubCategory.AssemblySpouting();
        }
        if (sequencedAssemblySubCategory instanceof SequencedAssemblySubCategory.AssemblyDeploying) {
            SequencedAssemblySubCategory.AssemblyDeploying assemblyPressing = (SequencedAssemblySubCategory.AssemblyDeploying)sequencedAssemblySubCategory;
            return new EmiSequencedAssemblySubCategory.AssemblyDeploying();
        }
        if (sequencedAssemblySubCategory instanceof SequencedAssemblySubCategory.AssemblyCutting) {
            SequencedAssemblySubCategory.AssemblyCutting assemblyPressing = (SequencedAssemblySubCategory.AssemblyCutting)sequencedAssemblySubCategory;
            return new EmiSequencedAssemblySubCategory.AssemblyCutting();
        }
        return null;
    }
}

