/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.emi.recipes.fan;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.emi.CreateEmiAnimations;
import com.simibubi.create.compat.emi.recipes.CreateEmiRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public abstract class FanEmiRecipe<T extends Recipe<?>>
extends CreateEmiRecipe<T> {
    protected static final int SCALE = 24;

    public FanEmiRecipe(EmiRecipeCategory type, T recipe) {
        super(type, recipe, 134, 76);
    }

    protected abstract void renderAttachedBlock(PoseStack var1);

    public void addWidgets(WidgetHolder widgets) {
        FanEmiRecipe.addTexture(widgets, AllGuiTextures.JEI_SHADOW, 24, 29);
        FanEmiRecipe.addTexture(widgets, AllGuiTextures.JEI_LONG_ARROW, 32, 51);
        FanEmiRecipe.addTexture(widgets, AllGuiTextures.JEI_SHADOW, 43, 39);
        FanEmiRecipe.addSlot(widgets, (EmiIngredient)this.input.get(0), 2, 48);
        FanEmiRecipe.addSlot(widgets, (EmiIngredient)this.output.get(0), 114, 48).recipeContext((EmiRecipe)this);
        CreateEmiAnimations.addFan(widgets, 34, 33, this::renderAttachedBlock);
    }

    public static EmiStack getFan(String name) {
        return EmiStack.of((ItemStack)AllBlocks.ENCASED_FAN.asStack().m_41714_((Component)Lang.translateDirect((String)("recipe." + name + ".fan"), (Object[])new Object[0]).m_130938_(style -> style.m_131155_(Boolean.valueOf(false)))));
    }

    public static abstract class MultiOutput<T extends ProcessingRecipe<?>>
    extends FanEmiRecipe<T> {
        public MultiOutput(EmiRecipeCategory type, T recipe) {
            super(type, recipe);
            if (this.output.size() > 1) {
                this.width = 178;
            }
        }

        @Override
        public void addWidgets(WidgetHolder widgets) {
            if (this.output.size() == 1) {
                super.addWidgets(widgets);
                return;
            }
            int size = this.output.size();
            int xOff = 1 - Math.min(3, size);
            MultiOutput.addSlot(widgets, (EmiIngredient)this.input.get(0), 21 + 5 * xOff, 48);
            MultiOutput.addTexture(widgets, AllGuiTextures.JEI_LONG_ARROW, 54 + 7 * xOff, 51);
            xOff = 9 * xOff;
            int yOff = 0;
            if (this.output.size() > 3) {
                yOff -= 12 + 16 * ((this.output.size() - 4) / 3);
            }
            for (int i = 0; i < size; ++i) {
                int x = i % 3 * 19 + xOff;
                int y = i / 3 * 19 + yOff;
                MultiOutput.addSlot(widgets, (EmiIngredient)this.output.get(i), 140 + x, 47 + y).recipeContext((EmiRecipe)this);
            }
            CreateEmiAnimations.addFan(widgets, 56, 33, this::renderAttachedBlock);
        }
    }
}

