/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.misc.toms_storage.filters;

import cc.cassian.raspberry.misc.toms_storage.filters.ModIdFilter;
import cc.cassian.raspberry.misc.toms_storage.filters.NameFilter;
import cc.cassian.raspberry.misc.toms_storage.filters.TagFilter;
import cc.cassian.raspberry.misc.toms_storage.filters.TooltipFilter;
import com.google.common.cache.LoadingCache;
import com.tom.storagemod.util.StoredItemStack;
import dev.emi.emi.config.EmiConfig;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class AnyFilter
implements Predicate<StoredItemStack> {
    private final NameFilter nameFilter;
    private final ModIdFilter modIdFilter;
    private final TagFilter tagFilter;
    private final TooltipFilter tooltipFilter;

    public AnyFilter(LoadingCache<StoredItemStack, List<String>> tooltipCache, Pattern pattern) {
        this.nameFilter = new NameFilter(pattern);
        this.modIdFilter = EmiConfig.searchModNameByDefault ? new ModIdFilter(pattern) : null;
        this.tagFilter = EmiConfig.searchTagsByDefault ? new TagFilter(pattern) : null;
        this.tooltipFilter = EmiConfig.searchTooltipByDefault ? new TooltipFilter(tooltipCache, pattern) : null;
    }

    @Override
    public boolean test(StoredItemStack storedItemStack) {
        if (this.nameFilter.test(storedItemStack)) {
            return true;
        }
        if (this.modIdFilter != null && this.modIdFilter.test(storedItemStack)) {
            return true;
        }
        if (this.tagFilter != null && this.tagFilter.test(storedItemStack)) {
            return true;
        }
        return this.tooltipFilter != null && this.tooltipFilter.test(storedItemStack);
    }
}

