/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.misc.toms_storage.filters;

import com.google.common.cache.LoadingCache;
import com.tom.storagemod.util.StoredItemStack;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class TooltipFilter
implements Predicate<StoredItemStack> {
    private final Pattern pattern;
    private final LoadingCache<StoredItemStack, List<String>> tooltipCache;

    public TooltipFilter(LoadingCache<StoredItemStack, List<String>> tooltipCache, Pattern pattern) {
        this.tooltipCache = tooltipCache;
        this.pattern = pattern;
    }

    @Nonnull
    private List<String> lookupTooltips(StoredItemStack stack) {
        List tooltips;
        try {
            tooltips = (List)this.tooltipCache.get((Object)stack);
        }
        catch (ExecutionException e) {
            return List.of();
        }
        return tooltips.isEmpty() ? tooltips : tooltips.subList(1, tooltips.size());
    }

    @Override
    public boolean test(StoredItemStack storedItemStack) {
        List<String> tooltips = this.lookupTooltips(storedItemStack);
        return tooltips.stream().anyMatch(tooltip -> this.pattern.matcher(tooltip.toLowerCase()).find());
    }
}

