/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.misc.toms_storage.tooltips;

import cc.cassian.raspberry.misc.toms_storage.tooltips.StringifyFormattedCharSink;
import com.google.common.cache.CacheLoader;
import com.tom.storagemod.util.StoredItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.ForgeHooksClient;

public class TooltipCacheLoader
extends CacheLoader<StoredItemStack, List<String>> {
    private static final AtomicBoolean isFakeShifting = new AtomicBoolean(false);
    private static boolean fakeShiftIsLocked = false;

    public static void setFakeShiftLock(boolean value) {
        fakeShiftIsLocked = value;
    }

    public static boolean isFakeShifting() {
        return fakeShiftIsLocked || isFakeShifting.get();
    }

    private static List<ClientTooltipComponent> getClientTooltips(StoredItemStack storedStack) {
        Minecraft client = Minecraft.m_91087_();
        ItemStack stack = storedStack.getStack();
        isFakeShifting.set(true);
        List defaultTooltips = stack.m_41651_((Player)client.f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL);
        List components = ForgeHooksClient.gatherTooltipComponents((ItemStack)stack, (List)defaultTooltips, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, null, (Font)client.f_91062_);
        isFakeShifting.set(false);
        return components;
    }

    private static List<String> stringifyTooltips(List<ClientTooltipComponent> components) {
        ArrayList<String> tooltipLines = new ArrayList<String>();
        for (ClientTooltipComponent component : components) {
            if (!(component instanceof ClientTextTooltip)) continue;
            ClientTextTooltip textTooltip = (ClientTextTooltip)component;
            StringifyFormattedCharSink sink = new StringifyFormattedCharSink();
            textTooltip.f_169936_.m_13731_((FormattedCharSink)sink);
            tooltipLines.add(sink.toString());
        }
        return tooltipLines;
    }

    @Nonnull
    public List<String> load(@Nonnull StoredItemStack storedStack) {
        List<ClientTooltipComponent> tooltips = TooltipCacheLoader.getClientTooltips(storedStack);
        List<String> tooltipLines = TooltipCacheLoader.stringifyTooltips(tooltips);
        if (tooltipLines.isEmpty()) {
            return tooltipLines;
        }
        return tooltipLines.subList(1, tooltipLines.size());
    }
}

