package com.github.wyzzard225.settingsmanager.client;

import net.fabricmc.api.ClientModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsmanagerClient implements ClientModInitializer {
	 public final Logger console = LoggerFactory.getLogger("SettingsManager");
	 public static Settings settings;

	 @Override
	 public void onInitializeClient() {
			settings = new Settings().setup("Example Mod","examplemod");
			settings.loadFromFile();
			settings.addColor("guiBackgroundColor","Example Settings", "Example Color", net.minecraft.class_8012.field_44941, "Gui Background Color", "This text will appear as a tooltip when you click on the option.");
			settings.add("doGuiOverlay", "Example Settings", "Example Boolean", true, "Render Gui Overlay", "This text will appear as a tooltip when you click on the option.", Settings.BooleanFormat.ONOFF);
			settings = settings.cleanup();
			console.info("SettingsManager is now loaded!");
	 }
}
