/*
 * Decompiled with CFR 0.152.
 */
package com.github.wyzzard225.settingsmanager.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumDropdownControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Settings {
    public String modName;
    public String modId;
    private transient Logger modConsole = LoggerFactory.getLogger((String)"SettingsManagerLib ERROR: SETTINGS NOT SETUP");
    private HashMap<String, Object> settings = new HashMap();
    private final transient HashMap<String, HashMap<String, HashMap<String, Object[]>>> configInfo = new HashMap();
    public transient HashMap<String, Object> defaultSettings = this.resetSettings();
    private final transient HashMap<String, String> configLocs = new HashMap();
    private final transient HashMap<String, List<String>> groupOrders = new HashMap();

    public HashMap<String, Object> resetSettings() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        for (String id : this.settings.keySet()) {
            String[] idPath = Objects.requireNonNull(this.configLocs).get(id).split("\\.");
            defaults.put(id, this.configInfo.get(idPath[0]).get(idPath[1]).get(idPath[2])[2]);
        }
        return defaults;
    }

    public Settings setup(String name, String id) {
        this.modConsole = LoggerFactory.getLogger((String)(id + " | SettingsManagerLib"));
        this.modName = name;
        this.modId = id;
        return this;
    }

    public Settings cleanup() {
        String[] refSettings = this.settings.keySet().toArray(new String[0]);
        for (String page : this.configInfo.keySet()) {
            for (String group : this.configInfo.get(page).keySet()) {
                for (String id : this.configInfo.get(page).get(group).keySet()) {
                    for (int i = 0; i < refSettings.length; ++i) {
                        if (!id.equals(refSettings[i])) continue;
                        refSettings[i] = null;
                    }
                }
            }
        }
        for (String id : refSettings) {
            if (id == null) continue;
            this.settings.remove(id);
        }
        return this;
    }

    public Settings orderGroups(String page, String[] groupOrder) {
        if (!this.groupOrders.containsKey(page)) {
            this.modConsole.error("Error while ordering groups:Page " + page + " does not exist!");
            return this;
        }
        ArrayList<String> finalOrder = new ArrayList<String>(Arrays.stream(groupOrder).toList());
        for (String group : this.groupOrders.get(page)) {
            if (finalOrder.contains(group)) continue;
            finalOrder.add(group);
        }
        this.groupOrders.put(page, finalOrder);
        return this;
    }

    private Settings registerValue(String idPath, String name, Object defaultValue, @Nullable String descr, Object min, Object max, Object step, String additionalData) {
        String[] newId;
        if (descr == null) {
            descr = "";
        }
        if (!this.configInfo.containsKey((newId = idPath.split("\\."))[0])) {
            this.configInfo.put(newId[0], new HashMap());
        }
        if (!this.configInfo.get(newId[0]).containsKey(newId[1])) {
            this.configInfo.get(newId[0]).put(newId[1], new HashMap());
        }
        this.configInfo.get(newId[0]).get(newId[1]).put(newId[2], new Object[]{newId[2], name, defaultValue, descr, additionalData, min, max, step});
        if (!this.settings.containsKey(newId[2])) {
            this.settings.put(newId[2], defaultValue);
        }
        this.configLocs.put(newId[2], idPath);
        if (!this.groupOrders.containsKey(newId[0])) {
            this.groupOrders.put(newId[0], new ArrayList());
        }
        if (!this.groupOrders.get(newId[0]).contains(newId[1])) {
            this.groupOrders.get(newId[0]).add(newId[1]);
        }
        return this;
    }

    private Settings registerValue(String idPath, String name, Object defaultValue, @Nullable String descr, String additionalData) {
        String[] newId;
        if (descr == null) {
            descr = "";
        }
        if (!this.configInfo.containsKey((newId = idPath.split("\\."))[0])) {
            this.configInfo.put(newId[0], new HashMap());
        }
        if (!this.configInfo.get(newId[0]).containsKey(newId[1])) {
            this.configInfo.get(newId[0]).put(newId[1], new HashMap());
        }
        this.configInfo.get(newId[0]).get(newId[1]).put(newId[2], new Object[]{newId[2], name, defaultValue, descr, additionalData});
        if (!this.settings.containsKey(newId[2])) {
            this.settings.put(newId[2], defaultValue);
        }
        this.configLocs.put(newId[2], idPath);
        if (!this.groupOrders.containsKey(newId[0])) {
            this.groupOrders.put(newId[0], new ArrayList());
        }
        if (!this.groupOrders.get(newId[0]).contains(newId[1])) {
            this.groupOrders.get(newId[0]).add(newId[1]);
        }
        return this;
    }

    private <E extends Enum<E>> Settings registerValue(String idPath, String name, E defaultValue, @Nullable String descr, String additionalData, Class<E> enumClass) {
        String[] newId;
        if (descr == null) {
            descr = "";
        }
        if (!this.configInfo.containsKey((newId = idPath.split("\\."))[0])) {
            this.configInfo.put(newId[0], new HashMap());
        }
        if (!this.configInfo.get(newId[0]).containsKey(newId[1])) {
            this.configInfo.get(newId[0]).put(newId[1], new HashMap());
        }
        this.configInfo.get(newId[0]).get(newId[1]).put(newId[2], new Object[]{newId[2], name, defaultValue, descr, additionalData, enumClass});
        if (!this.settings.containsKey(newId[2])) {
            this.settings.put(newId[2], defaultValue);
        }
        this.configLocs.put(newId[2], idPath);
        if (!this.groupOrders.containsKey(newId[0])) {
            this.groupOrders.put(newId[0], new ArrayList());
        }
        if (!this.groupOrders.get(newId[0]).contains(newId[1])) {
            this.groupOrders.get(newId[0]).add(newId[1]);
        }
        return this;
    }

    public Settings add(String id, String page, @Nullable String group, float defaultValue, String name, @Nullable String description, float min, float max, float step) {
        this.registerValue(page + "." + group + "." + id, name, Float.valueOf(defaultValue), description, Float.valueOf(min), Float.valueOf(max), Float.valueOf(step), "");
        return this;
    }

    public Settings add(String id, String page, @Nullable String group, int defaultValue, String name, @Nullable String description, int min, int max, int step) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, min, max, step, "");
        return this;
    }

    public Settings addSlider(String id, String page, @Nullable String group, float defaultValue, String name, @Nullable String description, float min, float max, float step) {
        this.registerValue(page + "." + group + "." + id, name, Float.valueOf(defaultValue), description, Float.valueOf(min), Float.valueOf(max), Float.valueOf(step), "isSlider");
        return this;
    }

    public Settings addSlider(String id, String page, @Nullable String group, int defaultValue, String name, @Nullable String description, int min, int max, int step) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, min, max, step, "isSlider");
        return this;
    }

    public Settings add(String id, String page, @Nullable String group, boolean defaultValue, String name, @Nullable String description) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, "");
        return this;
    }

    public Settings add(String id, String page, @Nullable String group, boolean defaultValue, String name, @Nullable String description, BooleanFormat visualFormat) {
        id = page + "." + group + "." + (String)id;
        if (visualFormat == BooleanFormat.TICKBOX) {
            this.registerValue((String)id, name, defaultValue, description, "isTickbox");
        } else if (visualFormat == BooleanFormat.YESNO) {
            this.registerValue((String)id, name, defaultValue, description, "isYesNo");
        } else if (visualFormat == BooleanFormat.ONOFF) {
            this.registerValue((String)id, name, defaultValue, description, "isOnOff");
        } else {
            this.registerValue((String)id, name, defaultValue, description, "");
        }
        return this;
    }

    public Settings addColor(String id, String page, @Nullable String group, int defaultValue, String name, @Nullable String description) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, "isColor");
        return this;
    }

    public Settings add(String id, String page, @Nullable String group, String defaultValue, String name, @Nullable String description) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, "");
        return this;
    }

    public <E extends Enum<E>> Settings add(String id, String page, @Nullable String group, E defaultValue, String name, @Nullable String description, Class<E> enumClass, EnumDisplayType displayType) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, "isEnum." + displayType.toString(), enumClass);
        return this;
    }

    @Nullable
    public Boolean get(String id, boolean none) {
        Object val = this.settings.get(id);
        if (val instanceof Boolean) {
            return (boolean)((Boolean)val);
        }
        this.modConsole.error("Error getting boolean value: " + id + ". Invalid value type: " + String.valueOf(val.getClass()));
        return null;
    }

    @Nullable
    public Float get(String id, float none) {
        Object val = this.settings.get(id);
        if (val instanceof Float) {
            return Float.valueOf(((Float)val).floatValue());
        }
        if (val instanceof Double) {
            Double f = (Double)val;
            return Float.valueOf(f.floatValue());
        }
        this.modConsole.error("Error getting float value: " + id + ". Invalid value type: " + String.valueOf(val.getClass()));
        return null;
    }

    @Nullable
    public Integer get(String id, int none) {
        Object val = this.settings.get(id);
        if (val instanceof Integer) {
            return (int)((Integer)val);
        }
        if (val instanceof Float) {
            Float f = (Float)val;
            return f.intValue();
        }
        if (val instanceof Double) {
            Double f = (Double)val;
            return f.intValue();
        }
        this.modConsole.error("Error getting int value: " + id + ". Invalid value type: " + String.valueOf(val.getClass()));
        return null;
    }

    @Nullable
    public String get(String id, String none) {
        Object val = this.settings.get(id);
        if (val instanceof String) {
            return (String)val;
        }
        this.modConsole.error("Error getting string value: " + id + ". Invalid value type: " + String.valueOf(val.getClass()));
        return null;
    }

    @Nullable
    public <E extends Enum<E>> E get(String id, Class<E> enumClass) {
        Object val = this.settings.get(id);
        try {
            return Enum.valueOf(enumClass, val.toString());
        }
        catch (IllegalArgumentException e) {
            this.modConsole.error("Error getting enum value: " + id + ". Invalid value type: " + String.valueOf(val.getClass()) + ". Value: " + String.valueOf(val) + ". Target enum class: " + String.valueOf(enumClass));
            return null;
        }
    }

    public Settings loadFromFile() {
        File CONFIG_FILE = new File("config/" + this.modId + ".json");
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Gson gson = new GsonBuilder().create();
                Settings newSettings = (Settings)gson.fromJson((Reader)reader, Settings.class);
                if (newSettings != null) {
                    for (String key : newSettings.settings.keySet()) {
                        this.settings.put(key, newSettings.settings.get(key));
                    }
                }
            }
            catch (IOException e) {
                this.modConsole.error("Failed to load config! Error source: " + Arrays.toString(e.getStackTrace()));
            }
        }
        return this;
    }

    public Settings saveToFile() {
        File CONFIG_FILE = new File("config/" + this.modId + ".json");
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            Gson gson = new GsonBuilder().create();
            Settings settings = new Settings().importSettings(this.settings);
            gson.toJson((Object)settings, (Appendable)writer);
            this.modConsole.info("Saved Config!");
        }
        catch (IOException e) {
            this.modConsole.error("Failed to save config! Error source: " + Arrays.toString(e.getStackTrace()));
        }
        return this;
    }

    public Settings set(String id, Object value, @Nullable String page, @Nullable String group) {
        this.settings.put(id, value);
        return this;
    }

    public int getChroma() {
        @Nullable Float chromaDuration = this.get("chromaDuration", 1.0f);
        if (chromaDuration == null) {
            chromaDuration = Float.valueOf(4.0f);
        }
        double chromaPhase = (double)System.nanoTime() / 1.0E9 % (double)chromaDuration.floatValue() / (double)chromaDuration.floatValue();
        return Color.HSBtoRGB((float)chromaPhase, 1.0f, 1.0f);
    }

    public Settings importSettings(HashMap<String, Object> newSettings) {
        this.settings = newSettings;
        return this;
    }

    public class_437 getConfig(class_437 parentScreen) {
        YetAnotherConfigLib.Builder output = YetAnotherConfigLib.createBuilder();
        String[] pages = this.configInfo.keySet().toArray(new String[0]);
        output.title((class_2561)class_2561.method_43470((String)(this.modName + " Settings"))).save(this::saveToFile);
        for (int i = 0; i < pages.length; ++i) {
            ConfigCategory.Builder category = ConfigCategory.createBuilder();
            String curPage = pages[i];
            category.name((class_2561)class_2561.method_43470((String)curPage));
            for (int j = 0; j < this.groupOrders.get(curPage).size(); ++j) {
                String groupName = this.groupOrders.get(curPage).get(j);
                OptionGroup.Builder group = OptionGroup.createBuilder();
                group.name((class_2561)class_2561.method_43470((String)groupName));
                String[] optionInfo = this.configInfo.get(curPage).get(groupName).keySet().toArray(new String[0]);
                block11: for (int k = 0; k < optionInfo.length; ++k) {
                    String optionId = optionInfo[k];
                    Object[] optionData = this.configInfo.get(curPage).get(groupName).get(optionId);
                    List<String> additionalData = List.of(((String)optionData[4]).split("\\."));
                    if (!(this.settings.get((String)optionData[0]).getClass() == optionData[2].getClass() || this.settings.get((String)optionData[0]) instanceof Double && (optionData[2] instanceof Integer || optionData[2] instanceof Float))) {
                        if (!(this.settings.get((String)optionData[0]) instanceof String) || !additionalData.contains("isEnum")) {
                            this.modConsole.warn("Setting: " + String.valueOf(optionData[0]) + " has the wrong type. Expected: " + String.valueOf(optionData[2].getClass()) + ". Given: " + String.valueOf(this.settings.get((String)optionData[0]).getClass()) + ". This may be due to a recent update in " + this.modName + ". The setting has been reverted to its default. Previous value: " + String.valueOf(this.settings.get((String)optionData[0])));
                            this.settings.put((String)optionData[0], optionData[2]);
                        } else {
                            try {
                                Enum.valueOf(optionData[5].getClass().asSubclass(Enum.class), (String)this.settings.get((String)optionData[0]));
                            }
                            catch (ClassCastException e) {
                                this.modConsole.warn("Setting: " + String.valueOf(optionData[0]) + " has the wrong type. Expected: " + String.valueOf(optionData[2].getClass()) + ". Given: " + String.valueOf(this.settings.get((String)optionData[0]).getClass()) + ". This may be due to a recent update in " + this.modName + ". The setting has been reverted to its default. Previous value: " + String.valueOf(this.settings.get((String)optionData[0])));
                                this.settings.put((String)optionData[0], optionData[2]);
                            }
                        }
                    }
                    Object object = optionData[2];
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Float.class, Integer.class, Enum.class, String.class}, (Object)object, n)) {
                        case 0: {
                            Boolean b = (Boolean)object;
                            Option.Builder option = Option.createBuilder();
                            option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
                            option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
                            if (additionalData.contains("isTickbox")) {
                                option.controller(TickBoxControllerBuilder::create);
                            } else if (additionalData.contains("isYesNo")) {
                                option.controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).yesNoFormatter());
                            } else if (additionalData.contains("isOnOff")) {
                                option.controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).onOffFormatter());
                            } else {
                                option.controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).trueFalseFormatter());
                            }
                            option.binding((Object)b, () -> Objects.requireNonNull(this.get((String)optionData[0], true)), newValue -> this.set((String)optionData[0], newValue, curPage, groupName));
                            if (groupName.isEmpty() || groupName.equals("none")) {
                                category.option(option.build());
                                continue block11;
                            }
                            group.option(option.build());
                            continue block11;
                        }
                        case 1: {
                            Float v = (Float)object;
                            Option.Builder option = Option.createBuilder();
                            option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
                            option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
                            if (additionalData.contains("isSlider")) {
                                option.controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)((Float)optionData[5]), (Number)((Float)optionData[6]))).step((Number)((Float)optionData[7])));
                            } else {
                                option.controller(opt -> FloatFieldControllerBuilder.create((Option)opt).range((Number)((Float)optionData[5]), (Number)((Float)optionData[6])));
                            }
                            option.binding((Object)v, () -> Objects.requireNonNull(this.get((String)optionData[0], 1.0f)), newValue -> this.set((String)optionData[0], newValue, curPage, groupName));
                            if (groupName.isEmpty() || groupName.equals("none")) {
                                category.option(option.build());
                                continue block11;
                            }
                            group.option(option.build());
                            continue block11;
                        }
                        case 2: {
                            Option.Builder option;
                            Integer integer = (Integer)object;
                            if (additionalData.contains("isColor")) {
                                option = Option.createBuilder();
                                option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
                                option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
                                option.controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(true));
                                option.binding((Object)new Color(integer, true), () -> new Color(Objects.requireNonNull(this.get((String)optionData[0], 1)), true), newValue -> this.set((String)optionData[0], newValue.getRGB(), curPage, groupName));
                                if (groupName.isEmpty() || groupName.equals("none")) {
                                    category.option(option.build());
                                    continue block11;
                                }
                                group.option(option.build());
                                continue block11;
                            }
                            option = Option.createBuilder();
                            option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
                            option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
                            if (additionalData.contains("isSlider")) {
                                option.controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)((Integer)optionData[5]), (Number)((Integer)optionData[6]))).step((Number)((Integer)optionData[7])));
                            } else {
                                option.controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).range((Number)((Integer)optionData[5]), (Number)((Integer)optionData[6])));
                            }
                            option.binding((Object)integer, () -> Objects.requireNonNull(this.get((String)optionData[0], 1)), newValue -> this.set((String)optionData[0], newValue, curPage, groupName));
                            if (groupName.isEmpty() || groupName.equals("none")) {
                                category.option(option.build());
                                continue block11;
                            }
                            group.option(option.build());
                            continue block11;
                        }
                        case 3: {
                            Enum anEnum = (Enum)object;
                            if (groupName.isEmpty() || groupName.equals("none")) {
                                if (additionalData.contains("DROPDOWN")) {
                                    category.option(this.createEnumOption(optionData, curPage, groupName, EnumDisplayType.DROPDOWN));
                                    continue block11;
                                }
                                category.option(this.createEnumOption(optionData, curPage, groupName, EnumDisplayType.CYCLE));
                                continue block11;
                            }
                            if (additionalData.contains("DROPDOWN")) {
                                group.option(this.createEnumOption(optionData, curPage, groupName, EnumDisplayType.DROPDOWN));
                                continue block11;
                            }
                            group.option(this.createEnumOption(optionData, curPage, groupName, EnumDisplayType.CYCLE));
                            continue block11;
                        }
                        case 4: {
                            String s = (String)object;
                            Option.Builder option = Option.createBuilder();
                            option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
                            option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
                            option.controller(StringControllerBuilder::create);
                            option.binding((Object)s, () -> Objects.requireNonNull(this.get((String)optionData[0], "")), newValue -> this.set((String)optionData[0], newValue, curPage, groupName));
                            if (groupName.isEmpty() || groupName.equals("none")) {
                                category.option(option.build());
                                continue block11;
                            }
                            group.option(option.build());
                            continue block11;
                        }
                        default: {
                            this.modConsole.error("Error creating config option: " + String.valueOf(optionData[1]) + ". Invalid default value type.");
                        }
                    }
                }
                if (groupName.isEmpty() || groupName.equals("none")) continue;
                category.group(group.build());
            }
            output.category(category.build());
        }
        return output.build().generateScreen(parentScreen);
    }

    private <E extends Enum<E>> Option<E> createEnumOption(Object[] optionData, String curPage, String groupName, EnumDisplayType displayType) {
        Option.Builder option = Option.createBuilder();
        option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
        if (displayType == EnumDisplayType.DROPDOWN) {
            option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)(String.valueOf(optionData[3]) + "\n\n\n\nTo change the value, delete the current value and click the new value"))}));
        } else {
            option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
        }
        if (displayType == EnumDisplayType.DROPDOWN) {
            option.controller(EnumDropdownControllerBuilder::create);
        } else {
            option.controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass((Class)optionData[5]));
        }
        option.binding((Object)((Enum)optionData[2]), () -> (Enum)Objects.requireNonNull(this.get((String)optionData[0], (Class)optionData[5])), newValue -> this.set((String)optionData[0], newValue, curPage, groupName));
        return option.build();
    }

    public static enum BooleanFormat {
        YESNO,
        TRUEFALSE,
        ONOFF,
        TICKBOX;

    }

    public static enum EnumDisplayType {
        DROPDOWN,
        CYCLE;

    }
}

