/*
 * Decompiled with CFR 0.152.
 */
package com.github.wyzzard225.settingsmanager.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Settings {
    public String modName;
    public String modId;
    private transient Logger modConsole = LoggerFactory.getLogger((String)"SettingsManagerLib ERROR: SETTINGS NOT SETUP");
    private HashMap<String, Object> settings = new HashMap();
    private final transient HashMap<String, HashMap<String, HashMap<String, Object[]>>> configInfo = new HashMap();
    public transient HashMap<String, Object> defaultSettings = this.resetSettings();
    private final transient HashMap<String, String> configLocs = new HashMap();

    public HashMap<String, Object> resetSettings() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        for (String id : this.settings.keySet()) {
            String[] idPath = Objects.requireNonNull(this.configLocs).get(id).split("\\.");
            defaults.put(id, this.configInfo.get(idPath[0]).get(idPath[1]).get(idPath[2])[2]);
        }
        return defaults;
    }

    public Settings setup(String name, String id) {
        this.modConsole = LoggerFactory.getLogger((String)(id + " | SettingsManagerLib"));
        this.modName = name;
        this.modId = id;
        return this;
    }

    private Settings registerValue(String idPath, String name, Object defaultValue, @Nullable String descr, Object min, Object max, Object step, String additionalData) {
        if (descr == null) {
            descr = "";
        }
        String[] newId = idPath.split("\\.");
        if (this.configInfo.containsKey(idPath) || this.settings.containsKey(newId[2])) {
            this.modConsole.warn("[" + this.modName + ".SettingsManagerLib] " + newId[2] + " is already registered! This may be due to importing settings before creating the config.");
        }
        if (!this.configInfo.containsKey(newId[0])) {
            this.configInfo.put(newId[0], new HashMap());
        }
        if (!this.configInfo.get(newId[0]).containsKey(newId[1])) {
            this.configInfo.get(newId[0]).put(newId[1], new HashMap());
        }
        this.configInfo.get(newId[0]).get(newId[1]).put(newId[2], new Object[]{newId[2], name, defaultValue, descr, additionalData, min, max, step});
        this.settings.put(newId[2], defaultValue);
        this.configLocs.put(newId[2], idPath);
        return this;
    }

    private Settings registerValue(String idPath, String name, Object defaultValue, @Nullable String descr, String additionalData) {
        if (descr == null) {
            descr = "";
        }
        String[] newId = idPath.split("\\.");
        if (this.configInfo.containsKey(idPath) || this.settings.containsKey(newId[2])) {
            this.modConsole.warn("[" + this.modName + ".SettingsManagerLib] " + newId[2] + " is already registered! This may be due to importing settings before creating the config.");
        }
        if (!this.configInfo.containsKey(newId[0])) {
            this.configInfo.put(newId[0], new HashMap());
        }
        if (!this.configInfo.get(newId[0]).containsKey(newId[1])) {
            this.configInfo.get(newId[0]).put(newId[1], new HashMap());
        }
        this.configInfo.get(newId[0]).get(newId[1]).put(newId[2], new Object[]{newId[2], name, defaultValue, descr, additionalData});
        this.settings.put(newId[2], defaultValue);
        this.configLocs.put(newId[2], idPath);
        return this;
    }

    private <E extends Enum<E>> Settings registerValue(String idPath, String name, E defaultValue, @Nullable String descr, String additionalData, Class<E> enumClass) {
        if (descr == null) {
            descr = "";
        }
        String[] newId = idPath.split("\\.");
        if (this.configInfo.containsKey(idPath) || this.settings.containsKey(newId[2])) {
            this.modConsole.warn("[" + this.modName + ".SettingsManagerLib] " + newId[2] + " is already registered! This may be due to importing settings before creating the config.");
        }
        if (!this.configInfo.containsKey(newId[0])) {
            this.configInfo.put(newId[0], new HashMap());
        }
        if (!this.configInfo.get(newId[0]).containsKey(newId[1])) {
            this.configInfo.get(newId[0]).put(newId[1], new HashMap());
        }
        this.configInfo.get(newId[0]).get(newId[1]).put(newId[2], new Object[]{newId[2], name, defaultValue, descr, additionalData});
        this.settings.put(newId[2], defaultValue);
        this.configLocs.put(newId[2], idPath);
        return this;
    }

    public Settings add(String id, String page, @Nullable String group, float defaultValue, String name, @Nullable String description, float min, float max, float step) {
        this.registerValue(page + "." + group + "." + id, name, Float.valueOf(defaultValue), description, Float.valueOf(min), Float.valueOf(max), Float.valueOf(step), "");
        return this;
    }

    public Settings add(String id, String page, @Nullable String group, int defaultValue, String name, @Nullable String description, int min, int max, int step) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, min, max, step, "");
        return this;
    }

    public Settings addSlider(String id, String page, @Nullable String group, float defaultValue, String name, @Nullable String description, float min, float max, float step) {
        this.registerValue(page + "." + group + "." + id, name, Float.valueOf(defaultValue), description, Float.valueOf(min), Float.valueOf(max), Float.valueOf(step), "isSlider");
        return this;
    }

    public Settings addSlider(String id, String page, @Nullable String group, int defaultValue, String name, @Nullable String description, int min, int max, int step) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, min, max, step, "isSlider");
        return this;
    }

    public Settings add(String id, String page, @Nullable String group, boolean defaultValue, String name, @Nullable String description) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, "");
        return this;
    }

    public Settings add(String id, String page, @Nullable String group, boolean defaultValue, String name, @Nullable String description, BooleanFormat visualFormat) {
        id = page + "." + group + "." + (String)id;
        if (visualFormat == BooleanFormat.TICKBOX) {
            this.registerValue((String)id, name, defaultValue, description, "isTickbox");
        } else if (visualFormat == BooleanFormat.YESNO) {
            this.registerValue((String)id, name, defaultValue, description, "isYesNo");
        } else if (visualFormat == BooleanFormat.ONOFF) {
            this.registerValue((String)id, name, defaultValue, description, "isOnOff");
        } else {
            this.registerValue((String)id, name, defaultValue, description, "");
        }
        return this;
    }

    public Settings addColor(String id, String page, @Nullable String group, int defaultValue, String name, @Nullable String description) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, "isColor");
        return this;
    }

    public Settings add(String id, String page, @Nullable String group, String defaultValue, String name, @Nullable String description) {
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, "");
        return this;
    }

    public <E extends Enum<E>> Settings add(String id, String page, @Nullable String group, E defaultValue, String name, @Nullable String description, Class<E> enumClass) {
        if (this.modConsole != null) {
            this.modConsole.error("Enums are not currently supported!");
            return this;
        }
        this.registerValue(page + "." + group + "." + id, name, defaultValue, description, "isEnum", enumClass);
        return this;
    }

    @Nullable
    public Boolean get(String id, boolean none) {
        Object val = this.settings.get(id);
        if (val instanceof Boolean) {
            return (boolean)((Boolean)val);
        }
        return null;
    }

    @Nullable
    public Float get(String id, float none) {
        Object val = this.settings.get(id);
        if (val instanceof Float) {
            return Float.valueOf(((Float)val).floatValue());
        }
        return null;
    }

    @Nullable
    public Integer get(String id, int none) {
        Object val = this.settings.get(id);
        if (val instanceof Integer) {
            return (int)((Integer)val);
        }
        return null;
    }

    @Nullable
    public String get(String id, String none) {
        this.modConsole.error(String.valueOf(this.settings));
        Object val = this.settings.get(id);
        if (val instanceof String) {
            return (String)val;
        }
        return null;
    }

    public Settings loadFromFile() {
        File CONFIG_FILE = new File("config/" + this.modId + ".json");
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Gson gson = new GsonBuilder().create();
                Settings newSettings = (Settings)gson.fromJson((Reader)reader, Settings.class);
                if (newSettings != null) {
                    for (String key : newSettings.settings.keySet()) {
                        this.settings.put(key, newSettings.settings.get(key));
                    }
                }
                this.modConsole.error("After2");
            }
            catch (IOException e) {
                this.modConsole.error("IOException");
                this.modConsole.error("[" + this.modName + ".SettingsManagerLib] Failed to load config! Error source: " + Arrays.toString(e.getStackTrace()));
            }
        }
        return this;
    }

    public Settings saveToFile() {
        File CONFIG_FILE = new File("config/" + this.modId + ".json");
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            Gson gson = new GsonBuilder().create();
            Settings settings = new Settings().importSettings(this.settings);
            gson.toJson((Object)settings, (Appendable)writer);
            this.modConsole.info("[" + this.modName + "] Saved Config!");
        }
        catch (IOException e) {
            this.modConsole.error("[" + this.modName + ".SettingsManagerLib] Failed to save config! Error source: " + Arrays.toString(e.getStackTrace()));
        }
        return this;
    }

    public Settings set(String id, Object value, @Nullable String page, @Nullable String group) {
        this.settings.put(id, value);
        return this;
    }

    public int getChroma() {
        @Nullable Float chromaDuration = this.get("chromaDuration", 1.0f);
        if (chromaDuration == null) {
            chromaDuration = Float.valueOf(4.0f);
        }
        double chromaPhase = (double)System.nanoTime() / 1.0E9 % (double)chromaDuration.floatValue() / (double)chromaDuration.floatValue();
        return Color.HSBtoRGB((float)chromaPhase, 1.0f, 1.0f);
    }

    public Settings importSettings(HashMap<String, Object> newSettings) {
        this.settings = newSettings;
        return this;
    }

    public class_437 getConfig(class_437 parentScreen) {
        YetAnotherConfigLib.Builder output = YetAnotherConfigLib.createBuilder();
        String[] pages = this.configInfo.keySet().toArray(new String[0]);
        output.title((class_2561)class_2561.method_43470((String)(this.modName + " Settings"))).save(this::saveToFile);
        for (int i = 0; i < pages.length; ++i) {
            ConfigCategory.Builder category = ConfigCategory.createBuilder();
            String curPage = pages[i];
            category.name((class_2561)class_2561.method_43470((String)curPage));
            String[] groups = this.configInfo.get(curPage).keySet().toArray(new String[0]);
            for (int j = 0; j < groups.length; ++j) {
                String groupName = groups[j];
                OptionGroup.Builder group = OptionGroup.createBuilder();
                group.name((class_2561)class_2561.method_43470((String)groupName));
                String[] optionInfo = this.configInfo.get(curPage).get(groupName).keySet().toArray(new String[0]);
                block8: for (int k = 0; k < optionInfo.length; ++k) {
                    String optionId = optionInfo[k];
                    Object[] optionData = this.configInfo.get(curPage).get(groupName).get(optionId);
                    List<String> additionalData = List.of(((String)optionData[4]).split("\\."));
                    Object object = optionData[2];
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Float.class, Integer.class, String.class}, (Object)object, n)) {
                        case 0: {
                            Boolean b = (Boolean)object;
                            Option.Builder option = Option.createBuilder();
                            option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
                            option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
                            if (additionalData.contains("isTickbox")) {
                                option.controller(TickBoxControllerBuilder::create);
                            } else if (additionalData.contains("isYesNo")) {
                                option.controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).yesNoFormatter());
                            } else if (additionalData.contains("isOnOff")) {
                                option.controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).onOffFormatter());
                            } else {
                                option.controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).trueFalseFormatter());
                            }
                            option.binding((Object)b, () -> Objects.requireNonNull(this.get((String)optionData[0], true)), newValue -> this.set((String)optionData[0], newValue, curPage, groupName));
                            group.option(option.build());
                            continue block8;
                        }
                        case 1: {
                            Float v = (Float)object;
                            Option.Builder option = Option.createBuilder();
                            option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
                            option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
                            if (additionalData.contains("isSlider")) {
                                option.controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)((Float)optionData[5]), (Number)((Float)optionData[6]))).step((Number)((Float)optionData[7])));
                            } else {
                                option.controller(opt -> FloatFieldControllerBuilder.create((Option)opt).range((Number)((Float)optionData[5]), (Number)((Float)optionData[6])));
                            }
                            option.binding((Object)v, () -> Objects.requireNonNull(this.get((String)optionData[0], 1.0f)), newValue -> this.set((String)optionData[0], newValue, curPage, groupName));
                            group.option(option.build());
                            continue block8;
                        }
                        case 2: {
                            Option.Builder option;
                            Integer integer = (Integer)object;
                            if (additionalData.contains("isColor")) {
                                option = Option.createBuilder();
                                option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
                                option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
                                option.controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(true));
                                option.binding((Object)new Color(integer, true), () -> new Color(Objects.requireNonNull(this.get((String)optionData[0], 1)), true), newValue -> this.set((String)optionData[0], newValue.getRGB(), curPage, groupName));
                                group.option(option.build());
                                continue block8;
                            }
                            option = Option.createBuilder();
                            option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
                            option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
                            if (additionalData.contains("isSlider")) {
                                option.controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)((Integer)optionData[5]), (Number)((Integer)optionData[6]))).step((Number)((Integer)optionData[7])));
                            } else {
                                option.controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).range((Number)((Integer)optionData[5]), (Number)((Integer)optionData[6])));
                            }
                            option.binding((Object)integer, () -> Objects.requireNonNull(this.get((String)optionData[0], 1)), newValue -> this.set((String)optionData[0], newValue, curPage, groupName));
                            group.option(option.build());
                            continue block8;
                        }
                        case 3: {
                            String s = (String)object;
                            Option.Builder option = Option.createBuilder();
                            option.name((class_2561)class_2561.method_43470((String)optionData[1].toString()));
                            option.description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)((String)optionData[3]))}));
                            option.controller(StringControllerBuilder::create);
                            this.modConsole.warn(String.valueOf(optionData[0]));
                            this.modConsole.warn(this.get((String)optionData[0], ""));
                            option.binding((Object)s, () -> Objects.requireNonNull(this.get((String)optionData[0], "")), newValue -> this.set((String)optionData[0], newValue, curPage, groupName));
                            group.option(option.build());
                            continue block8;
                        }
                        default: {
                            this.modConsole.error("Error creating config option: " + String.valueOf(optionData[1]) + ". Invalid default value type.");
                        }
                    }
                }
                category.group(group.build());
            }
            output.category(category.build());
        }
        return output.build().generateScreen(parentScreen);
    }

    public Settings createPage(String name, String id) {
        return this;
    }

    public Settings createGroup(String name, String id, String page) {
        return this;
    }

    public static enum BooleanFormat {
        YESNO,
        TRUEFALSE,
        ONOFF,
        TICKBOX;

    }
}

