package com.github.wyzzard225.settingsmanager.client;

import net.fabricmc.api.ClientModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsmanagerClient implements ClientModInitializer {
	 public final Logger console = LoggerFactory.getLogger("SettingsManager");
	 public static Settings settings;

	 @SuppressWarnings("unused")
	 public enum ExampleEnum {
			EXAMPLE1,
			EXAMPLE2,
			EXAMPLE3,
			VALUE1,
			VALUE2
	 }
	 @Override
	 public void onInitializeClient() {
			settings = new Settings().setup("Example Mod","ExampleMod");
			settings.loadFromFile();
			settings.addColor("colorTest1","Color Test", "none", net.minecraft.class_8012.field_44941, "Test Color Name", "This text will appear as a tooltip when you click on the option.");
			settings.addColor("colorTest2","Color Test", "none", net.minecraft.class_8012.field_41758, "Test Color Name 2", "This text will appear as a tooltip when you click on the option.");
			settings.add("doGuiOverlay", "Boolean Test", "none", true, "Test Boolean Name", "This text will appear as a tooltip when you click on the option.", Settings.BooleanFormat.ONOFF);
			settings.add("example3", "String Test", "none", "Default String Value", "Test String Name", "This text will appear as a tooltip when you click on the option.");
			settings.addSlider("example4","Number Test","none",5,"Test Slider Name","Description",0,10,1);
			settings.add("exampleEnum","Enum Test","none",ExampleEnum.EXAMPLE1,"Test Dropdown Enum","Desc",ExampleEnum.class, Settings.EnumDisplayType.DROPDOWN);
			settings.add("exampleEnum2","Enum Test","none",ExampleEnum.VALUE1,"Test Cycle Enum","Desc",ExampleEnum.class, Settings.EnumDisplayType.CYCLE);
			settings.add("formattingTest1","Formatting Test","none",true,"No group","This text will appear as a tooltip when you click on the option.");
			settings.add("formattingTest2","Formatting Test","Test Group 1",true,"Group 1 Num 1","This text will appear as a tooltip when you click on the option.");
			settings.add("formattingTest3","Formatting Test","Test Group 1",true,"Group 1 Num 2","This text will appear as a tooltip when you click on the option.");
			settings.add("formattingTest4","Formatting Test","Test Group 2",true,"Group 2 Num 1","This text will appear as a tooltip when you click on the option.");
			settings.add("formattingTest5","Formatting Test","Test Group 2",true,"Group 2 Num 2","This text will appear as a tooltip when you click on the option.");
			settings.add("formattingTest6","Formatting Test","Test Group 3",true,"Group 3 Num 1","This text will appear as a tooltip when you click on the option.");
			settings.add("formattingTest7","Formatting Test","Test Group 3",true,"Group 3 Num 2","This text will appear as a tooltip when you click on the option.");
			settings.add("formattingTest8","Formatting Test","Test Group 4",true,"Group 4 Num 1","This text will appear as a tooltip when you click on the option.");
			settings.add("formattingTest9","Formatting Test","Test Group 4",true,"Group 4 Num 2","This text will appear as a tooltip when you click on the option.");
			settings.add("formattingTest10","Formatting Test","Test Group 4",true,"Group 4 Num 3","This text will appear as a tooltip when you click on the option.");
			settings.orderGroups("Formatting Test",new String[]{"Test Group 1","Test Group 2","Test Group 3","Test Group 4"});
			settings = settings.cleanup();
			console.info("SettingsManager is now loaded!");
	 }
}
