package com.jowhjy.mixin;

import com.jowhjy.ChunkGetter;
import com.jowhjy.config.FootprintConfigs;
import com.jowhjy.mixin_interfaces.IChunkWithForcedSave;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntity_Mixin extends class_1297 {

    public LivingEntity_Mixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "damage", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;isSleeping()Z"))
    public void footprint$alwaysSaveChunkOnEntityDamaged(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir)
    {
        //this is off by default because it can happen without player intervention (bat flying into lava, foxes/wolves/axolotls murdering mobs, squid suffocating, fall damage, etc...)
        if (!FootprintConfigs.ALWAYS_SAVE_ENTITY_HURT) return;

        ChunkGetter.forceSaveChunksAround(world, this.method_24515(), FootprintConfigs.ALWAYS_SAVE_ENTITY_HURT_RANGE);
    }
}
