package com.jowhjy.mixin;

import com.jowhjy.config.FootprintConfigs;
import com.jowhjy.mixin_interfaces.IChunkWithForcedSave;
import net.minecraft.class_2791;
import net.minecraft.class_3898;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3898.class)
public class ServerChunkLoadingManager_Mixin {

    @Inject(method = "save(Lnet/minecraft/world/chunk/Chunk;)Z", at = @At(value = "HEAD"), cancellable = true)
    public void footprint$chunkSavingConditions(class_2791 chunk, CallbackInfoReturnable<Boolean> cir) {

        if (chunk.method_12033() < FootprintConfigs.MIN_INHABITED_TIME
        && !((IChunkWithForcedSave)chunk).footprint$isForceSave())
            cir.setReturnValue(false);
    }

}
