package com.jowhjy.mixin;

import com.jowhjy.ChunkGetter;
import com.jowhjy.config.FootprintConfigs;
import com.jowhjy.mixin_interfaces.IChunkWithForcedSave;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3225.class)
public class ServerPlayInteractionManager_Mixin {
    @Shadow protected class_3218 world;

    @Inject(method = "tryBreakBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/Block;onBroken(Lnet/minecraft/world/WorldAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V"))
    public void footprint$forceSaveChunkOnBlockBrokenByPlayer(class_2338 pos, CallbackInfoReturnable<Boolean> cir)
    {
        if (!FootprintConfigs.ALWAYS_SAVE_BLOCK_BREAK) return;

        ChunkGetter.forceSaveChunksAround(world, pos, FootprintConfigs.ALWAYS_SAVE_BLOCK_BREAK_RANGE);
    }
}
