/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;

public abstract class ModernSelectionList<E extends Entry<E>>
extends ContainerObjectSelectionList<E> {
    private boolean doneRefresh;

    public ModernSelectionList(Minecraft minecraft, int width, int height, int y, int defaultEntryHeight) {
        super(minecraft, width, height, y, defaultEntryHeight);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.doneRefresh) {
            this.repositionEntries();
            this.doneRefresh = true;
        }
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void repositionEntries() {
        this.setScrollAmount(this.scrollAmount());
    }

    protected boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        return this.mouseClicked(mouseButtonEvent.x(), mouseButtonEvent.y(), mouseButtonEvent.button());
    }

    protected boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
    }

    public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
        return this.mouseReleased(mouseButtonEvent.x(), mouseButtonEvent.y(), mouseButtonEvent.button());
    }

    protected boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        return super.mouseDragged(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), dx, dy);
    }

    public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double dx, double dy) {
        return this.mouseDragged(mouseButtonEvent.x(), mouseButtonEvent.y(), mouseButtonEvent.button(), dx, dy);
    }

    protected boolean keyPressed(int key, int scancode, int modifiers) {
        return super.keyPressed(new KeyEvent(key, scancode, modifiers));
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        return this.keyPressed(keyEvent.key(), keyEvent.scancode(), keyEvent.modifiers());
    }

    protected boolean charTyped(char ch, int modifiers) {
        return super.charTyped(new CharacterEvent((int)ch, modifiers));
    }

    public boolean charTyped(CharacterEvent characterEvent) {
        return this.charTyped((char)characterEvent.codepoint(), characterEvent.modifiers());
    }

    public static abstract class Entry<E extends Entry<E>>
    extends ContainerObjectSelectionList.Entry<E> {
        protected boolean keyPressed(int key, int scancode, int modifiers) {
            return super.keyPressed(new KeyEvent(key, scancode, modifiers));
        }

        public boolean keyPressed(KeyEvent keyEvent) {
            return this.keyPressed(keyEvent.key(), keyEvent.scancode(), keyEvent.modifiers());
        }

        protected boolean charTyped(char ch, int modifiers) {
            return super.charTyped(new CharacterEvent((int)ch, modifiers));
        }

        public boolean charTyped(CharacterEvent characterEvent) {
            return this.charTyped((char)characterEvent.codepoint(), characterEvent.modifiers());
        }
    }
}

