/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import com.mojang.blaze3d.Blaze3D;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class OptionDescriptionWidget
extends AbstractWidget {
    private static final int AUTO_SCROLL_TIMER = 1500;
    private static final float AUTO_SCROLL_SPEED = 1.0f;
    @Nullable
    private DescriptionWithName description;
    private List<FormattedCharSequence> wrappedText;
    private static final Minecraft minecraft = Minecraft.getInstance();
    private static final Font font = OptionDescriptionWidget.minecraft.font;
    private Supplier<ScreenRectangle> dimensions;
    private float targetScrollAmount;
    private float currentScrollAmount;
    private int maxScrollAmount;
    private int descriptionY;
    private int lastInteractionTime;
    private boolean scrollingBackward;

    public OptionDescriptionWidget(Supplier<ScreenRectangle> dimensions, @Nullable DescriptionWithName description) {
        super(0, 0, 0, 0, (Component)(description == null ? Component.empty() : description.name()));
        this.dimensions = dimensions;
        this.setOptionDescription(description);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Style hoveredStyle;
        Object image;
        if (this.description == null) {
            return;
        }
        this.currentScrollAmount = Mth.lerp((float)(delta * 0.5f), (float)this.currentScrollAmount, (float)this.targetScrollAmount);
        ScreenRectangle dimensions = this.dimensions.get();
        this.setX(dimensions.left());
        this.setY(dimensions.top());
        this.width = dimensions.width();
        this.height = dimensions.height();
        int y = this.getY();
        int nameWidth = font.width((FormattedText)this.description.name());
        if (nameWidth > this.getWidth()) {
            Component component = this.description.name();
            int n = this.getX();
            int n2 = this.getX() + this.getWidth();
            Objects.requireNonNull(font);
            OptionDescriptionWidget.renderScrollingString((GuiGraphics)graphics, (Font)font, (Component)component, (int)n, (int)y, (int)n2, (int)(y + 9), (int)-1);
        } else {
            graphics.drawString(font, this.description.name(), this.getX(), y, -1);
        }
        Objects.requireNonNull(font);
        graphics.enableScissor(this.getX(), y += 5 + 9, this.getX() + this.getWidth(), this.getY() + this.getHeight());
        y -= (int)this.currentScrollAmount;
        if (this.description.description().image().isDone() && ((Optional)(image = this.description.description().image().join())).isPresent()) {
            y += ((ImageRenderer)((Optional)image).get()).render(graphics, this.getX(), y, this.getWidth(), delta) + 5;
        }
        if (this.wrappedText == null) {
            this.wrappedText = font.split((FormattedText)this.description.description().text(), this.getWidth());
        }
        this.descriptionY = y;
        for (FormattedCharSequence line : this.wrappedText) {
            graphics.drawString(font, line, this.getX(), y, -1);
            Objects.requireNonNull(font);
            y += 9;
        }
        graphics.disableScissor();
        this.maxScrollAmount = Math.max(0, y + (int)this.currentScrollAmount - this.getY() - this.getHeight());
        if (this.isHoveredOrFocused()) {
            this.lastInteractionTime = this.currentTimeMS();
        }
        if ((hoveredStyle = this.getDescStyle(mouseX, mouseY)) != null && hoveredStyle.getHoverEvent() != null) {
            graphics.renderComponentHoverEffect(font, hoveredStyle, mouseX, mouseY);
        }
        if (this.isFocused()) {
            graphics.submitOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), -1);
        }
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        return this.onMouseClicked(mouseButtonEvent.x(), mouseButtonEvent.y());
    }

    protected boolean onMouseClicked(double mouseX, double mouseY) {
        Style clickedStyle = this.getDescStyle((int)mouseX, (int)mouseY);
        if (clickedStyle != null && clickedStyle.getClickEvent() != null) {
            if (OptionDescriptionWidget.minecraft.screen.handleComponentClicked(clickedStyle)) {
                this.playDownSound(minecraft.getSoundManager());
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.targetScrollAmount = Mth.clamp((float)(this.targetScrollAmount - (float)((int)vertical * 10)), (float)0.0f, (float)this.maxScrollAmount);
            this.lastInteractionTime = this.currentTimeMS();
            return true;
        }
        return false;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        return this.onKeyPressed(keyEvent.key());
    }

    protected boolean onKeyPressed(int keyCode) {
        if (this.isFocused()) {
            switch (keyCode) {
                case 265: {
                    this.targetScrollAmount = Mth.clamp((float)(this.targetScrollAmount - 10.0f), (float)0.0f, (float)this.maxScrollAmount);
                    break;
                }
                case 264: {
                    this.targetScrollAmount = Mth.clamp((float)(this.targetScrollAmount + 10.0f), (float)0.0f, (float)this.maxScrollAmount);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.description != null) {
            this.description.description().image().getNow(Optional.empty()).ifPresent(ImageRenderer::tick);
        }
        Objects.requireNonNull(font);
        float pxPerTick = 0.05f * 9.0f;
        if (this.maxScrollAmount > 0 && this.currentTimeMS() - this.lastInteractionTime > 1500) {
            if (this.scrollingBackward) {
                if (this.targetScrollAmount + (pxPerTick *= -1.0f) < 0.0f) {
                    this.scrollingBackward = false;
                    this.lastInteractionTime = this.currentTimeMS();
                }
            } else if (this.targetScrollAmount + pxPerTick > (float)this.maxScrollAmount) {
                this.scrollingBackward = true;
                this.lastInteractionTime = this.currentTimeMS();
            }
            this.targetScrollAmount = Mth.clamp((float)(this.targetScrollAmount + pxPerTick), (float)0.0f, (float)this.maxScrollAmount);
        }
    }

    private Style getDescStyle(int mouseX, int mouseY) {
        boolean clicked = this.isMouseOver(mouseX, mouseY);
        if (!clicked) {
            return null;
        }
        int x = mouseX - this.getX();
        int y = mouseY - this.descriptionY;
        if (x < 0 || x > this.getX() + this.getWidth()) {
            return null;
        }
        if (y < 0 || y > this.getY() + this.getHeight()) {
            return null;
        }
        Objects.requireNonNull(font);
        int line = y / 9;
        if (line >= this.wrappedText.size()) {
            return null;
        }
        return font.getSplitter().componentStyleAtWidth(this.wrappedText.get(line), x);
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        if (this.description != null) {
            builder.add(NarratedElementType.TITLE, this.description.name());
            builder.add(NarratedElementType.HINT, this.description.description().text());
        }
    }

    public void setOptionDescription(DescriptionWithName description) {
        this.description = description;
        this.wrappedText = null;
        this.targetScrollAmount = 0.0f;
        this.currentScrollAmount = 0.0f;
        this.lastInteractionTime = this.currentTimeMS();
    }

    private int currentTimeMS() {
        return (int)(Blaze3D.getTime() * 1000.0);
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return null;
    }
}

