/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.api.utils.MutableDimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ColorController;
import dev.isxander.yacl3.gui.controllers.ControllerPopupWidget;
import dev.isxander.yacl3.gui.render.ColorGradientRenderState;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import dev.isxander.yacl3.gui.utils.WidgetUtils;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ColorPickerWidget
extends ControllerPopupWidget<ColorController> {
    public static final ResourceLocation COLOR_PICKER_SPRITE = YACLPlatform.rl("controller/colorpicker");
    public static final ResourceLocation TRANSPARENT_SPRITE = YACLPlatform.rl("controller/transparent");
    private final ColorController controller;
    private final ColorController.ColorControllerElement entryWidget;
    protected MutableDimension<Integer> colorPickerDim;
    protected MutableDimension<Integer> previewColorDim;
    protected MutableDimension<Integer> saturationLightDim;
    protected MutableDimension<Integer> hueGradientDim;
    protected MutableDimension<Integer> alphaGradientDim;
    private boolean mouseDown;
    private boolean hueSliderDown;
    private boolean satLightGradientDown;
    private boolean alphaSliderDown;
    private int hueThumbX;
    private int satLightThumbX;
    private int alphaThumbX;
    private boolean charTyped;
    private final int outline = 1;
    private final int previewPortion = 7;
    private final int sliderHeight = 7;
    private final int paddingX = 1;
    private final int paddingY = 3;
    private float[] HSL;
    private float hue;
    private float saturation;
    private float light;
    private int alpha;

    public ColorPickerWidget(ColorController control, YACLScreen screen, Dimension<Integer> dim, ColorController.ColorControllerElement entryWidget) {
        super(control, screen, dim, entryWidget);
        this.controller = control;
        this.entryWidget = entryWidget;
        this.setDimension(dim);
        this.updateHSL();
        this.setThumbX();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.updateHSL();
        int thumbWidth = 4;
        int thumbHeight = 4;
        GuiUtils.pushPose(graphics);
        GuiUtils.translateZ(graphics, 10.0f);
        GuiUtils.blitSprite(graphics, COLOR_PICKER_SPRITE, (Integer)this.colorPickerDim.x() - 5, (Integer)this.colorPickerDim.y() - 5, (Integer)this.colorPickerDim.width() + 10, (Integer)this.colorPickerDim.height() + 10);
        graphics.fill((Integer)this.previewColorDim.x() - 1, (Integer)this.previewColorDim.y() - 1, (Integer)this.previewColorDim.xLimit() + 1, (Integer)this.previewColorDim.yLimit() + 1, Color.black.getRGB());
        if (this.controller.allowAlpha()) {
            GuiUtils.blitSprite(graphics, TRANSPARENT_SPRITE, (Integer)this.previewColorDim.x(), (Integer)this.previewColorDim.y(), (Integer)this.previewColorDim.width(), (Integer)this.previewColorDim.height());
        }
        graphics.fill(((Integer)this.previewColorDim.x()).intValue(), ((Integer)this.previewColorDim.y()).intValue(), ((Integer)this.previewColorDim.xLimit()).intValue(), ((Integer)this.previewColorDim.yLimit()).intValue(), this.controller.option().pendingValue().getRGB());
        graphics.fill((Integer)this.saturationLightDim.x() - 1, (Integer)this.saturationLightDim.y() - 1, (Integer)this.saturationLightDim.xLimit() + 1, (Integer)this.saturationLightDim.yLimit() + 1, Color.black.getRGB());
        ColorGradientRenderState.createHorizontal(graphics, (Integer)this.saturationLightDim.x(), (Integer)this.saturationLightDim.y(), (Integer)this.saturationLightDim.xLimit(), (Integer)this.saturationLightDim.yLimit(), -1, GuiUtils.putAlpha((int)this.getRgbFromHueX(), 255)).submit(graphics);
        graphics.fillGradient(((Integer)this.saturationLightDim.x()).intValue(), ((Integer)this.saturationLightDim.y()).intValue(), ((Integer)this.saturationLightDim.xLimit()).intValue(), ((Integer)this.saturationLightDim.yLimit()).intValue(), 0, -16777216);
        graphics.fill(this.satLightThumbX - thumbWidth / 2 - 2, this.getSatLightThumbY() + thumbHeight / 2 + 2, this.satLightThumbX + thumbWidth / 2 + 1, this.getSatLightThumbY() - thumbHeight / 2 - 1, -12566464);
        graphics.fill(this.satLightThumbX - thumbWidth / 2 - 1, this.getSatLightThumbY() + thumbHeight / 2 + 1, this.satLightThumbX + thumbWidth / 2, this.getSatLightThumbY() - thumbHeight / 2, -1);
        graphics.fill((Integer)this.hueGradientDim.x() - 1, (Integer)this.hueGradientDim.y() - 1, (Integer)this.hueGradientDim.xLimit() + 1, (Integer)this.hueGradientDim.yLimit() + 1, Color.black.getRGB());
        this.drawRainbowGradient(graphics, (Integer)this.hueGradientDim.x(), (Integer)this.hueGradientDim.y(), (Integer)this.hueGradientDim.xLimit(), (Integer)this.hueGradientDim.yLimit());
        graphics.fill(this.hueThumbX - thumbWidth / 2 - 1, (Integer)this.hueGradientDim.y() - 1 - 1, this.hueThumbX + thumbWidth / 2 + 1, (Integer)this.hueGradientDim.yLimit() + 1 + 1, -12566464);
        graphics.fill(this.hueThumbX - thumbWidth / 2, (Integer)this.hueGradientDim.y() - 1, this.hueThumbX + thumbWidth / 2, (Integer)this.hueGradientDim.yLimit() + 1, -1);
        if (this.controller.allowAlpha()) {
            graphics.fill((Integer)this.alphaGradientDim.x() - 1, (Integer)this.alphaGradientDim.y() - 1, (Integer)this.alphaGradientDim.xLimit() + 1, (Integer)this.alphaGradientDim.yLimit() + 1, Color.black.getRGB());
            GuiUtils.blitSprite(graphics, TRANSPARENT_SPRITE, (Integer)this.alphaGradientDim.x(), (Integer)this.alphaGradientDim.y(), (Integer)this.alphaGradientDim.width(), 7);
            ColorGradientRenderState.createHorizontal(graphics, (Integer)this.alphaGradientDim.x(), (Integer)this.alphaGradientDim.y(), (Integer)this.alphaGradientDim.xLimit(), (Integer)this.alphaGradientDim.yLimit(), GuiUtils.putAlpha(this.getRgbWithoutAlpha(), 255), 0).submit(graphics);
            graphics.fill(this.alphaThumbX - thumbWidth / 2 - 1, (Integer)this.alphaGradientDim.y() - 1 - 1, this.alphaThumbX + thumbWidth / 2 + 1, (Integer)this.alphaGradientDim.yLimit() + 1 + 1, -12566464);
            graphics.fill(this.alphaThumbX - thumbWidth / 2, (Integer)this.alphaGradientDim.y() - 1, this.alphaThumbX + thumbWidth / 2, (Integer)this.alphaGradientDim.yLimit() + 1, -1);
        }
        GuiUtils.popPose(graphics);
        if (this.isHoveringHueSlider(mouseX, mouseY)) {
            graphics.requestCursor(CursorTypes.RESIZE_EW);
        } else if (this.isHoveringAlphaSlider(mouseX, mouseY)) {
            graphics.requestCursor(CursorTypes.RESIZE_EW);
        } else if (this.isHoveringSatLightGradient(mouseX, mouseY)) {
            graphics.requestCursor(CursorTypes.CROSSHAIR);
        }
    }

    private boolean isHoveringHueSlider(double mouseX, double mouseY) {
        return mouseY >= (double)((Integer)this.hueGradientDim.y()).intValue() && mouseY <= (double)((Integer)this.hueGradientDim.yLimit()).intValue() && mouseX >= (double)((Integer)this.hueGradientDim.x()).intValue() && mouseX <= (double)((Integer)this.hueGradientDim.xLimit()).intValue();
    }

    public boolean clickedHueSlider(double mouseX, double mouseY) {
        if (this.satLightGradientDown || this.alphaSliderDown) {
            return false;
        }
        if (this.isHoveringHueSlider(mouseX, mouseY)) {
            this.hueSliderDown = true;
        }
        if (this.hueSliderDown) {
            this.hueThumbX = (int)Mth.clamp((double)mouseX, (double)((Integer)this.hueGradientDim.x()).intValue(), (double)((Integer)this.hueGradientDim.xLimit()).intValue());
        }
        return this.hueSliderDown;
    }

    private boolean isHoveringSatLightGradient(double mouseX, double mouseY) {
        return mouseY >= (double)((Integer)this.saturationLightDim.y()).intValue() && mouseY <= (double)((Integer)this.saturationLightDim.yLimit()).intValue() && mouseX >= (double)((Integer)this.saturationLightDim.x()).intValue() && mouseX <= (double)((Integer)this.saturationLightDim.xLimit()).intValue();
    }

    public boolean clickedSatLightGradient(double mouseX, double mouseY) {
        if (this.hueSliderDown || this.alphaSliderDown) {
            return false;
        }
        if (this.isHoveringSatLightGradient(mouseX, mouseY)) {
            this.satLightGradientDown = true;
        }
        if (this.satLightGradientDown) {
            this.satLightThumbX = (int)Mth.clamp((double)mouseX, (double)((Integer)this.saturationLightDim.x()).intValue(), (double)((Integer)this.saturationLightDim.xLimit()).intValue());
        }
        return this.satLightGradientDown;
    }

    private boolean isHoveringAlphaSlider(double mouseX, double mouseY) {
        if (this.alphaGradientDim == null) {
            return false;
        }
        return mouseY >= (double)((Integer)this.alphaGradientDim.y()).intValue() && mouseY <= (double)((Integer)this.alphaGradientDim.yLimit()).intValue() && mouseX >= (double)((Integer)this.alphaGradientDim.x()).intValue() && mouseX <= (double)((Integer)this.alphaGradientDim.xLimit()).intValue();
    }

    public boolean clickedAlphaSlider(double mouseX, double mouseY) {
        if (this.satLightGradientDown || this.hueSliderDown) {
            return false;
        }
        if (this.isHoveringAlphaSlider(mouseX, mouseY)) {
            this.alphaSliderDown = true;
        }
        if (this.alphaSliderDown) {
            this.alphaThumbX = (int)Mth.clamp((double)mouseX, (double)((Integer)this.alphaGradientDim.x()).intValue(), (double)((Integer)this.alphaGradientDim.xLimit()).intValue());
        }
        return this.alphaSliderDown;
    }

    public void setColorFromMouseClick(double mouseX, double mouseY) {
        if (this.clickedSatLightGradient(mouseX, mouseY)) {
            this.setSatLightFromMouse(mouseX, mouseY);
        } else if (this.clickedHueSlider(mouseX, mouseY)) {
            this.setHueFromMouse(mouseX);
        } else if (this.controller.allowAlpha() && this.clickedAlphaSlider(mouseX, mouseY)) {
            this.setAlphaFromMouse(mouseX);
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.mouseDown = true;
            this.hueSliderDown = false;
            this.satLightGradientDown = false;
            this.alphaSliderDown = false;
            this.setColorFromMouseClick(mouseX, mouseY);
            return true;
        }
        if (this.entryWidget.isMouseOver(mouseX, mouseY)) {
            return WidgetUtils.mouseClicked(this.entryWidget, mouseX, mouseY, button);
        }
        this.close();
        return false;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        this.mouseDown = false;
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)((Integer)this.colorPickerDim.x() - 1 - 3) && mouseX <= (double)((Integer)this.colorPickerDim.xLimit() + 1 + 3) && mouseY >= (double)((Integer)this.colorPickerDim.y() - 1 - 3) && mouseY <= (double)((Integer)this.colorPickerDim.yLimit() + 1 + 3);
    }

    @Override
    public boolean onMouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseDown || this.isMouseOver(mouseX, mouseY)) {
            this.setColorFromMouseClick(mouseX, mouseY);
            return true;
        }
        return this.entryWidget.onMouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean onCharTyped(char chr, String cpStr, int modifiers) {
        this.charTyped = true;
        return this.entryWidget.onCharTyped(chr, cpStr, modifiers);
    }

    @Override
    public void setDimension(Dimension<Integer> dim) {
        super.setDimension(dim);
        int colorPickerHeight = dim.height() * 2 + 7;
        int colorPickerX = dim.centerX() - this.getXPadding() * 2;
        int colorPickerY = dim.y() - colorPickerHeight - 7;
        int alphaSliderHeight = 0;
        if (this.controller.allowAlpha()) {
            alphaSliderHeight = 11;
            colorPickerHeight += alphaSliderHeight;
            colorPickerY -= alphaSliderHeight;
        }
        if (colorPickerY < this.screen.tabArea.top()) {
            colorPickerY = dim.yLimit() + 7;
        }
        this.colorPickerDim = Dimension.ofInt(colorPickerX, colorPickerY, dim.xLimit() - colorPickerX, colorPickerHeight);
        this.previewColorDim = Dimension.ofInt((Integer)this.colorPickerDim.x(), (Integer)this.colorPickerDim.y(), (Integer)this.colorPickerDim.x() + (Integer)this.colorPickerDim.xLimit() / 7 - 1 - (Integer)this.colorPickerDim.x(), (Integer)this.colorPickerDim.yLimit() - 7 - 3 - (Integer)this.colorPickerDim.y() - alphaSliderHeight);
        this.saturationLightDim = Dimension.ofInt((Integer)this.colorPickerDim.x() + (Integer)this.colorPickerDim.xLimit() / 7 + 1 + 1, (Integer)this.colorPickerDim.y(), (Integer)this.colorPickerDim.xLimit() - ((Integer)this.colorPickerDim.x() + (Integer)this.colorPickerDim.xLimit() / 7 + 1 + 1), (Integer)this.colorPickerDim.yLimit() - 7 - 3 - (Integer)this.colorPickerDim.y() - alphaSliderHeight);
        this.hueGradientDim = Dimension.ofInt((Integer)this.colorPickerDim.x(), (Integer)this.colorPickerDim.yLimit() - 7 - alphaSliderHeight, (Integer)this.colorPickerDim.width(), 7);
        if (this.controller.allowAlpha()) {
            this.alphaGradientDim = Dimension.ofInt((Integer)this.hueGradientDim.x(), (Integer)this.hueGradientDim.y() + alphaSliderHeight, (Integer)this.hueGradientDim.width(), 7);
        }
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.entryWidget.hoveredOverColorPreview = this.entryWidget.isMouseOverColorPreview(mouseX, mouseY);
    }

    @Override
    public void close() {
        this.entryWidget.removeColorPicker();
    }

    @Override
    public Component popupTitle() {
        return Component.translatable((String)"yacl.control.color.color_picker_title");
    }

    public void setThumbX() {
        this.hueThumbX = this.getHueThumbX();
        this.satLightThumbX = this.getSatLightThumbX();
        if (this.controller.allowAlpha()) {
            this.alphaThumbX = this.getAlphaThumbX();
        }
    }

    protected int getHueThumbX() {
        int min = (Integer)this.hueGradientDim.x();
        int max = (Integer)this.hueGradientDim.xLimit();
        int value = (int)((float)min + (float)((Integer)this.hueGradientDim.width()).intValue() * this.hue);
        return Mth.clamp((int)value, (int)min, (int)max);
    }

    protected int getSatLightThumbX() {
        int min = (Integer)this.saturationLightDim.x();
        int max = (Integer)this.saturationLightDim.xLimit();
        int value = (int)((float)min + (float)((Integer)this.saturationLightDim.width()).intValue() * this.saturation);
        return Mth.clamp((int)value, (int)min, (int)max);
    }

    protected int getSatLightThumbY() {
        int min = (Integer)this.saturationLightDim.y();
        int max = (Integer)this.saturationLightDim.yLimit();
        int value = (int)((float)min + (float)((Integer)this.saturationLightDim.height()).intValue() * (1.0f - this.light));
        return Mth.clamp((int)value, (int)min, (int)max);
    }

    protected int getAlphaThumbX() {
        int min = (Integer)this.alphaGradientDim.x();
        int max = (Integer)this.alphaGradientDim.xLimit();
        int value = max - (Integer)this.alphaGradientDim.width() * this.alpha / 255;
        return Mth.clamp((int)value, (int)min, (int)max);
    }

    public void setHueFromMouse(double mouseX) {
        if (mouseX < (double)((Integer)this.hueGradientDim.x()).intValue()) {
            this.hue = 0.0f;
        } else if (mouseX > (double)((Integer)this.hueGradientDim.xLimit()).intValue()) {
            this.hue = 1.0f;
        } else {
            float newHue = (float)(mouseX - (double)((Integer)this.hueGradientDim.x()).intValue()) / (float)((Integer)this.hueGradientDim.width()).intValue();
            this.hue = Mth.clamp((float)newHue, (float)0.0f, (float)1.0f);
        }
        this.setColorControllerFromHSL();
    }

    public void setSatLightFromMouse(double mouseX, double mouseY) {
        if (mouseX < (double)((Integer)this.saturationLightDim.x()).intValue()) {
            this.saturation = 0.0f;
        } else if (mouseX > (double)((Integer)this.saturationLightDim.xLimit()).intValue()) {
            this.saturation = 1.0f;
        } else {
            float newSat = (float)(mouseX - (double)((Integer)this.saturationLightDim.x()).intValue()) / (float)((Integer)this.saturationLightDim.width()).intValue();
            this.saturation = Mth.clamp((float)newSat, (float)0.0f, (float)1.0f);
        }
        if (mouseY < (double)((Integer)this.saturationLightDim.y()).intValue()) {
            this.light = 1.0f;
        } else if (mouseY > (double)((Integer)this.saturationLightDim.yLimit()).intValue()) {
            this.light = 0.0f;
        } else {
            float newLight = (float)(mouseY - (double)((Integer)this.saturationLightDim.y()).intValue()) / (float)((Integer)this.saturationLightDim.height()).intValue();
            this.light = Mth.clamp((float)(1.0f - newLight), (float)0.0f, (float)1.0f);
        }
        this.setColorControllerFromHSL();
    }

    public void setAlphaFromMouse(double mouseX) {
        if (mouseX < (double)((Integer)this.alphaGradientDim.x()).intValue()) {
            this.alpha = 255;
        } else if (mouseX > (double)((Integer)this.alphaGradientDim.xLimit()).intValue()) {
            this.alpha = 0;
        } else {
            int newAlpha = (int)((mouseX - (double)((Integer)this.alphaGradientDim.xLimit()).intValue()) / (double)((Integer)this.alphaGradientDim.width()).intValue() * -255.0);
            this.alpha = Mth.clamp((int)newAlpha, (int)0, (int)255);
        }
        this.setColorControllerFromHSL();
    }

    public void setColorControllerFromHSL() {
        float trueHue = (float)(this.hueThumbX - (Integer)this.colorPickerDim.x()) / (float)((Integer)this.colorPickerDim.width()).intValue();
        Color color = Color.getHSBColor(trueHue, this.saturation, this.light);
        Color returnColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
        this.controller.option().requestSet(returnColor);
    }

    protected void updateHSL() {
        this.HSL = this.getHSL();
        this.hue = this.hue();
        this.saturation = this.saturation();
        this.light = this.light();
        this.alpha = this.getAlpha();
        if (this.charTyped) {
            this.setThumbX();
            this.charTyped = false;
        }
    }

    protected float[] getHSL() {
        Color pendingValue = this.controller.option().pendingValue();
        return Color.RGBtoHSB(pendingValue.getRed(), pendingValue.getGreen(), pendingValue.getBlue(), null);
    }

    protected float hue() {
        return this.HSL[0];
    }

    protected float saturation() {
        return this.HSL[1];
    }

    protected float light() {
        return this.HSL[2];
    }

    protected int getAlpha() {
        return this.controller.option().pendingValue().getAlpha();
    }

    protected float getRgbFromHueX() {
        float trueHue = (float)(this.hueThumbX - (Integer)this.colorPickerDim.x()) / (float)((Integer)this.colorPickerDim.width()).intValue();
        return Color.HSBtoRGB(trueHue, 1.0f, 1.0f);
    }

    protected int getRgbWithoutAlpha() {
        Color pendingColor = this.controller.option().pendingValue();
        Color returnColor = new Color(pendingColor.getRed(), pendingColor.getGreen(), pendingColor.getBlue(), 255);
        return returnColor.getRGB();
    }
}

