/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerPopupWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class PopupControllerScreen
extends Screen {
    private final YACLScreen backgroundYaclScreen;
    private final ControllerPopupWidget<?> controllerPopup;

    public PopupControllerScreen(YACLScreen backgroundYaclScreen, ControllerPopupWidget<?> controllerPopup) {
        super(controllerPopup.popupTitle());
        this.backgroundYaclScreen = backgroundYaclScreen;
        this.controllerPopup = controllerPopup;
    }

    protected void init() {
        this.addRenderableWidget(this.controllerPopup);
    }

    protected void repositionElements() {
        super.repositionElements();
        this.onClose();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.controllerPopup.renderBackground(graphics, mouseX, mouseY, delta);
        this.backgroundYaclScreen.render(graphics, -1, -1, delta);
        super.render(graphics, mouseX, mouseY, delta);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.backgroundYaclScreen.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        if (!super.mouseClicked(mouseButtonEvent, bl)) {
            this.onClose();
            return false;
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        if (this.controllerPopup.mouseScrolled(mouseX, mouseY, horizontal, vertical)) {
            return true;
        }
        this.backgroundYaclScreen.mouseScrolled(mouseX, mouseY, horizontal, vertical);
        return super.mouseScrolled(mouseX, mouseY, horizontal, vertical);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.controllerPopup.mouseMoved(mouseX, mouseY);
    }

    public boolean charTyped(CharacterEvent characterEvent) {
        return this.controllerPopup.charTyped(characterEvent);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        return this.controllerPopup.keyPressed(keyEvent);
    }

    public void tick() {
        super.tick();
        this.backgroundYaclScreen.tick();
    }

    public void onClose() {
        this.minecraft.screen = this.backgroundYaclScreen;
        this.controllerPopup.close();
    }
}

