/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.utils;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class GuiUtils {
    public static void pushPose(GuiGraphics graphics) {
        graphics.pose().pushMatrix();
    }

    public static void popPose(GuiGraphics graphics) {
        graphics.pose().popMatrix();
    }

    public static void translate2D(GuiGraphics graphics, float x, float y) {
        graphics.pose().translate(x, y);
    }

    public static void translateZ(GuiGraphics graphics, float z) {
    }

    public static void scale2D(GuiGraphics graphics, float x, float y) {
        graphics.pose().scale(x, y);
    }

    public static void rotate2D(GuiGraphics graphics, float angle) {
        graphics.pose().rotate(angle * ((float)Math.PI / 180));
    }

    public static void blitGuiTex(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height) {
        GuiUtils.blitGuiTex(graphics, texture, x, y, u, v, textureWidth, textureHeight, width, height, false);
    }

    public static void blitGuiTex(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height, boolean linearFiltering) {
        graphics.blit(GuiUtils.guiTextured(linearFiltering), texture, x, y, u, v, textureWidth, textureHeight, width, height);
    }

    public static void blitGuiTexColor(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height, int color) {
        graphics.blit(GuiUtils.guiTextured(false), texture, x, y, u, v, textureWidth, textureHeight, width, height, color);
    }

    public static void blitSprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        graphics.blitSprite(GuiUtils.guiTextured(false), sprite, x, y, width, height);
    }

    public static RenderPipeline guiTextured(boolean textureFiltering) {
        return RenderPipelines.GUI_TEXTURED;
    }

    public static MutableComponent translatableFallback(String key, Component fallback) {
        if (Language.getInstance().has(key)) {
            return Component.translatable((String)key);
        }
        return fallback.copy();
    }

    public static String shortenString(String string, Font font, int maxWidth, String suffix) {
        if (((String)string).isEmpty()) {
            return string;
        }
        boolean firstIter = true;
        while (font.width((String)string) > maxWidth) {
            string = ((String)string).substring(0, Math.max(((String)string).length() - 1 - (firstIter ? 1 : suffix.length() + 1), 0)).trim();
            if (((String)(string = (String)string + suffix)).equals(suffix)) break;
            firstIter = false;
        }
        return string;
    }

    public static void setPixelARGB(NativeImage nativeImage, int x, int y, int argb) {
        nativeImage.setPixel(x, y, argb);
    }

    public static int extractAlpha(int argb) {
        return ARGB.alpha((int)argb);
    }

    public static int putAlpha(int rgb, int alpha) {
        return ARGB.color((int)alpha, (int)rgb);
    }
}

