/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.utils;

import dev.isxander.yacl3.gui.utils.MiscUtil;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public final class ItemRegistryHelper {
    public static boolean isRegisteredItem(String identifier) {
        try {
            ResourceLocation itemResourceLocation = YACLPlatform.parseRl(identifier.toLowerCase());
            return BuiltInRegistries.ITEM.containsKey(itemResourceLocation);
        }
        catch (ResourceLocationException e) {
            return false;
        }
    }

    public static Item getItemFromName(String identifier, Item defaultItem) {
        try {
            ResourceLocation itemResourceLocation = YACLPlatform.parseRl(identifier.toLowerCase());
            if (BuiltInRegistries.ITEM.containsKey(itemResourceLocation)) {
                return (Item)MiscUtil.getFromRegistry(BuiltInRegistries.ITEM, itemResourceLocation);
            }
        }
        catch (ResourceLocationException resourceLocationException) {
            // empty catch block
        }
        return defaultItem;
    }

    public static Item getItemFromName(String identifier) {
        return ItemRegistryHelper.getItemFromName(identifier, Items.AIR);
    }

    public static Stream<ResourceLocation> getMatchingItemResourceLocations(String value) {
        Predicate<ResourceLocation> filterPredicate;
        int sep = value.indexOf(58);
        if (sep == -1) {
            filterPredicate = identifier -> identifier.getPath().contains(value) || ((Item)MiscUtil.getFromRegistry(BuiltInRegistries.ITEM, identifier)).getName().getString().toLowerCase().contains(value.toLowerCase());
        } else {
            String namespace = value.substring(0, sep);
            String path = value.substring(sep + 1);
            filterPredicate = identifier -> identifier.getNamespace().equals(namespace) && identifier.getPath().startsWith(path);
        }
        return BuiltInRegistries.ITEM.keySet().stream().filter(filterPredicate).sorted((id1, id2) -> {
            String path = (sep == -1 ? value : value.substring(sep + 1)).toLowerCase();
            boolean id1StartsWith = id1.getPath().toLowerCase().startsWith(path);
            boolean id2StartsWith = id2.getPath().toLowerCase().startsWith(path);
            if (id1StartsWith) {
                if (id2StartsWith) {
                    return id1.compareTo(id2);
                }
                return -1;
            }
            if (id2StartsWith) {
                return 1;
            }
            return id1.compareTo(id2);
        });
    }
}

