/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.CustomTabProvider;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionEventListener;
import dev.isxander.yacl3.api.PlaceholderCategory;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.api.utils.MutableDimension;
import dev.isxander.yacl3.api.utils.OptionUtils;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.OptionDescriptionWidget;
import dev.isxander.yacl3.gui.OptionListWidget;
import dev.isxander.yacl3.gui.SearchFieldWidget;
import dev.isxander.yacl3.gui.WidgetAndType;
import dev.isxander.yacl3.gui.YACLSelectionList;
import dev.isxander.yacl3.gui.controllers.ControllerPopupWidget;
import dev.isxander.yacl3.gui.controllers.PopupControllerScreen;
import dev.isxander.yacl3.gui.tab.ScrollableNavigationBar;
import dev.isxander.yacl3.gui.tab.TabExt;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class YACLScreen
extends Screen {
    public final YetAnotherConfigLib config;
    private final Screen parent;
    public final TabManager tabManager = new TabManager(x$0 -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
    }, x$0 -> this.removeWidget((GuiEventListener)x$0));
    public ScrollableNavigationBar tabNavigationBar;
    public ScreenRectangle tabArea;
    public Component saveButtonMessage;
    public Tooltip saveButtonTooltipMessage;
    private int saveButtonMessageTime;
    private boolean pendingChanges;
    public ControllerPopupWidget<?> currentPopupController = null;
    public boolean popupControllerVisible = false;

    public YACLScreen(YetAnotherConfigLib config, Screen parent) {
        super(config.title());
        this.config = config;
        this.parent = parent;
        OptionUtils.forEachOptions(config, option -> option.addEventListener((opt, event) -> {
            if (event != OptionEventListener.Event.INITIAL) {
                this.onOptionChanged(opt);
            }
        }));
    }

    protected void init() {
        int currentTab;
        this.tabArea = new ScreenRectangle(0, 23, this.width, this.height - 24 + 1);
        int n = currentTab = this.tabNavigationBar != null ? this.tabNavigationBar.getTabs().indexOf((Object)this.tabManager.getCurrentTab()) : 0;
        if (currentTab == -1) {
            currentTab = 0;
        }
        this.tabNavigationBar = new ScrollableNavigationBar(this.width, this.tabManager, this.config.categories().stream().map(category -> {
            if (category instanceof CustomTabProvider) {
                CustomTabProvider tabProvider = (CustomTabProvider)((Object)category);
                return tabProvider.createTab(this, this.tabArea);
            }
            if (category instanceof PlaceholderCategory) {
                PlaceholderCategory placeholder = (PlaceholderCategory)category;
                return new PlaceholderTab(placeholder, this);
            }
            return new CategoryTab(this, (ConfigCategory)category, this.tabArea);
        }).toList());
        this.tabNavigationBar.selectTab(currentTab, false);
        this.tabNavigationBar.arrangeElements();
        this.tabManager.setTabArea(this.tabArea);
        this.addRenderableWidget((GuiEventListener)this.tabNavigationBar);
        this.config.initConsumer().accept(this);
    }

    public void addPopupControllerWidget(ControllerPopupWidget<?> controllerPopupWidget) {
        if (this.currentPopupController != null) {
            this.clearPopupControllerWidget();
        }
        this.currentPopupController = controllerPopupWidget;
        this.popupControllerVisible = true;
        OptionListWidget optionListWidget = null;
        Tab tab = this.tabNavigationBar.getTabManager().getCurrentTab();
        if (tab instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)tab;
            optionListWidget = categoryTab.optionList.getType();
        }
        if (optionListWidget != null) {
            this.minecraft.setScreen((Screen)new PopupControllerScreen(this, controllerPopupWidget));
        }
    }

    public void clearPopupControllerWidget() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof PopupControllerScreen) {
            PopupControllerScreen popupControllerScreen = (PopupControllerScreen)screen;
            popupControllerScreen.onClose();
        }
        this.popupControllerVisible = false;
        this.currentPopupController = null;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        Tab tab = this.tabManager.getCurrentTab();
        if (tab instanceof TabExt) {
            TabExt tab2 = (TabExt)tab;
            tab2.renderBackground(guiGraphics);
        }
    }

    public void finishOrSave() {
        this.saveButtonMessage = null;
        if (this.pendingChanges()) {
            HashSet flags = new HashSet();
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.applyValue()) {
                    flags.addAll(option.flags());
                }
            });
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.changed()) {
                    option.forgetPendingValue();
                    YACLConstants.LOGGER.error("Option '{}' value mismatch after applying! Reset to binding's getter.", (Object)option.name().getString());
                }
            });
            this.config.saveFunction().run();
            flags.forEach(flag -> flag.accept(this.minecraft));
            this.pendingChanges = false;
            Tab tab = this.tabManager.getCurrentTab();
            if (tab instanceof CategoryTab) {
                CategoryTab categoryTab = (CategoryTab)tab;
                categoryTab.updateButtons();
            }
        } else {
            this.onClose();
        }
    }

    public void cancelOrReset() {
        if (this.pendingChanges()) {
            OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
            this.onClose();
        } else {
            OptionUtils.forEachOptions(this.config, Option::requestSetDefault);
        }
    }

    public void undo() {
        OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
    }

    public void tick() {
        Tab tab = this.tabManager.getCurrentTab();
        if (tab instanceof TabExt) {
            TabExt tabExt = (TabExt)tab;
            tabExt.tick();
        }
        if ((tab = this.tabManager.getCurrentTab()) instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)tab;
            if (this.saveButtonMessage != null) {
                if (this.saveButtonMessageTime > 140) {
                    this.saveButtonMessage = null;
                    this.saveButtonTooltipMessage = null;
                    this.saveButtonMessageTime = 0;
                } else {
                    ++this.saveButtonMessageTime;
                    categoryTab.saveFinishedButton.setMessage(this.saveButtonMessage);
                    if (this.saveButtonTooltipMessage != null) {
                        categoryTab.saveFinishedButton.setTooltip(this.saveButtonTooltipMessage);
                    }
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            this.setDragging(true);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.getFocused() != null && this.isDragging() && (button == 0 || button == 1) && this.getFocused().mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void setSaveButtonMessage(Component message, Component tooltip) {
        this.saveButtonMessage = message;
        this.saveButtonTooltipMessage = Tooltip.create((Component)tooltip);
        this.saveButtonMessageTime = 0;
    }

    public boolean pendingChanges() {
        return this.pendingChanges;
    }

    private void onOptionChanged(Option<?> option) {
        this.pendingChanges = false;
        OptionUtils.consumeOptions(this.config, opt -> {
            this.pendingChanges |= opt.changed();
            return this.pendingChanges;
        });
        Tab tab = this.tabManager.getCurrentTab();
        if (tab instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)tab;
            categoryTab.updateButtons();
        }
    }

    public boolean shouldCloseOnEsc() {
        if (this.pendingChanges()) {
            this.setSaveButtonMessage((Component)Component.translatable((String)"yacl.gui.save_before_exit").withStyle(ChatFormatting.RED), (Component)Component.translatable((String)"yacl.gui.save_before_exit.tooltip"));
            return false;
        }
        return true;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public static void renderMultilineTooltip(GuiGraphics graphics, Font font, MultiLineLabel text, int centerX, int yAbove, int yBelow, int screenWidth, int screenHeight) {
        if (text.getLineCount() > 0) {
            int maxWidth = text.getWidth();
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int height = text.getLineCount() * lineHeight - 1;
            int belowY = yBelow + 12;
            int aboveY = yAbove - height + 12;
            int maxBelow = screenHeight - (belowY + height);
            int minAbove = aboveY - height;
            int y = aboveY;
            if (minAbove < 8) {
                y = maxBelow > minAbove ? belowY : aboveY;
            }
            int x = Math.max(centerX - text.getWidth() / 2 - 12, -6);
            int drawX = x + 12;
            int drawY = y - 12;
            GuiUtils.pushPose(graphics);
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)drawX, (int)drawY, (int)maxWidth, (int)height, (int)400, null);
            GuiUtils.translateZ(graphics, 400.0f);
            text.renderLeftAligned(graphics, drawX, drawY, lineHeight, -1);
            GuiUtils.popPose(graphics);
        }
    }

    public static class CategoryTab
    implements TabExt {
        private static final ResourceLocation DARKER_BG = YACLPlatform.mcRl("textures/gui/menu_list_background.png");
        private final YACLScreen screen;
        private final ConfigCategory category;
        private final Tooltip tooltip;
        private WidgetAndType<OptionListWidget> optionList;
        public final Button saveFinishedButton;
        public final Button cancelResetButton;
        public final Button undoButton;
        private final SearchFieldWidget searchField;
        private OptionDescriptionWidget descriptionWidget;
        private final ScreenRectangle rightPaneDim;

        public CategoryTab(YACLScreen screen, ConfigCategory category, ScreenRectangle tabArea) {
            this.screen = screen;
            this.category = category;
            this.tooltip = Tooltip.create((Component)category.tooltip());
            int columnWidth = screen.width / 3;
            int padding = columnWidth / 20;
            columnWidth = Math.min(columnWidth, 400);
            int paddedWidth = columnWidth - padding * 2;
            this.rightPaneDim = new ScreenRectangle(screen.width / 3 * 2, tabArea.top() + 1, screen.width / 3, tabArea.height());
            MutableDimension<Integer> actionDim = Dimension.ofInt(screen.width / 3 * 2 + screen.width / 6, screen.height - padding - 20, paddedWidth, 20);
            this.saveFinishedButton = Button.builder((Component)Component.literal((String)"Done"), btn -> screen.finishOrSave()).pos((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).size(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).build();
            actionDim.expand(-((Integer)actionDim.width()).intValue() / 2 - 2, 0).move(-((Integer)actionDim.width()).intValue() / 2 - 2, -22);
            this.cancelResetButton = Button.builder((Component)Component.literal((String)"Cancel"), btn -> screen.cancelOrReset()).pos((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).size(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).build();
            actionDim.move((Integer)actionDim.width() + 4, 0);
            this.undoButton = Button.builder((Component)Component.translatable((String)"yacl.gui.undo"), btn -> screen.undo()).pos((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).size(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).tooltip(Tooltip.create((Component)Component.translatable((String)"yacl.gui.undo.tooltip"))).build();
            this.searchField = new SearchFieldWidget(screen, screen.font, screen.width / 3 * 2 + screen.width / 6 - paddedWidth / 2 + 1, this.undoButton.getY() - 22, paddedWidth - 2, 18, (Component)Component.translatable((String)"gui.recipebook.search_hint"), (Component)Component.translatable((String)"gui.recipebook.search_hint"), searchQuery -> this.optionList.getType().updateSearchQuery((String)searchQuery));
            this.optionList = YACLSelectionList.asWidget(new OptionListWidget(screen, category, screen.minecraft, 0, 0, screen.width / 3 * 2 + 1, screen.height, desc -> this.descriptionWidget.setOptionDescription((DescriptionWithName)desc)));
            this.descriptionWidget = new OptionDescriptionWidget(() -> new ScreenRectangle(screen.width / 3 * 2 + padding, tabArea.top() + padding, paddedWidth, this.searchField.getY() - 1 - tabArea.top() - padding * 2), null);
            this.updateButtons();
        }

        public Component getTabTitle() {
            return this.category.name();
        }

        public void visitChildren(Consumer<AbstractWidget> consumer) {
            consumer.accept(this.optionList.getWidget());
            consumer.accept((AbstractWidget)this.saveFinishedButton);
            consumer.accept((AbstractWidget)this.cancelResetButton);
            consumer.accept((AbstractWidget)this.undoButton);
            consumer.accept((AbstractWidget)this.searchField);
            consumer.accept(this.descriptionWidget);
        }

        @Override
        public void renderBackground(GuiGraphics graphics) {
            GuiUtils.blitGuiTex(graphics, DARKER_BG, this.rightPaneDim.left(), this.rightPaneDim.top(), this.rightPaneDim.right() + 2, this.rightPaneDim.bottom() + 2, this.rightPaneDim.width() + 2, this.rightPaneDim.height() + 2, 32, 32);
            GuiUtils.pushPose(graphics);
            GuiUtils.translateZ(graphics, 10.0f);
            GuiUtils.blitGuiTex(graphics, CreateWorldScreen.HEADER_SEPARATOR, this.rightPaneDim.left() - 1, this.rightPaneDim.top() - 2, 0.0f, 0.0f, this.rightPaneDim.width() + 1, 2, 32, 2);
            GuiUtils.popPose(graphics);
            GuiUtils.pushPose(graphics);
            GuiUtils.translate2D(graphics, this.rightPaneDim.left(), this.rightPaneDim.top() - 1);
            GuiUtils.rotate2D(graphics, 90.0f);
            GuiUtils.blitGuiTex(graphics, CreateWorldScreen.FOOTER_SEPARATOR, 0, 0, 0.0f, 0.0f, this.rightPaneDim.height() + 1, 2, 32, 2);
            GuiUtils.popPose(graphics);
        }

        public void doLayout(ScreenRectangle tabArea) {
            ScreenRectangle rect = new ScreenRectangle(tabArea.position(), tabArea.width() / 3 * 2, tabArea.height());
            this.optionList.getType().setX(rect.left());
            this.optionList.getType().setY(rect.top());
            this.optionList.getType().setWidth(rect.width());
            this.optionList.getType().setHeight(rect.height());
        }

        @Override
        public void tick() {
            this.descriptionWidget.tick();
        }

        @Override
        @Nullable
        public Tooltip getTooltip() {
            return this.tooltip;
        }

        public void updateButtons() {
            boolean pendingChanges;
            this.undoButton.active = pendingChanges = this.screen.pendingChanges();
            this.saveFinishedButton.setMessage((Component)(pendingChanges ? Component.translatable((String)"yacl.gui.save") : GuiUtils.translatableFallback("yacl.gui.done", CommonComponents.GUI_DONE)));
            this.saveFinishedButton.setTooltip(Tooltip.create((Component)(pendingChanges ? Component.translatable((String)"yacl.gui.save.tooltip") : Component.translatable((String)"yacl.gui.finished.tooltip"))));
            this.cancelResetButton.setMessage((Component)(pendingChanges ? GuiUtils.translatableFallback("yacl.gui.cancel", CommonComponents.GUI_CANCEL) : Component.translatable((String)"controls.reset")));
            this.cancelResetButton.setTooltip(Tooltip.create((Component)(pendingChanges ? Component.translatable((String)"yacl.gui.cancel.tooltip") : Component.translatable((String)"yacl.gui.reset.tooltip"))));
        }
    }

    public static class PlaceholderTab
    implements TabExt {
        private final YACLScreen screen;
        private final PlaceholderCategory category;
        private final Tooltip tooltip;

        public PlaceholderTab(PlaceholderCategory category, YACLScreen screen) {
            this.screen = screen;
            this.category = category;
            this.tooltip = Tooltip.create((Component)category.tooltip());
        }

        public Component getTabTitle() {
            return this.category.name();
        }

        public void visitChildren(Consumer<AbstractWidget> consumer) {
        }

        public void doLayout(ScreenRectangle screenRectangle) {
            this.screen.minecraft.setScreen(this.category.screen().apply(this.screen.minecraft, this.screen));
        }

        @Override
        @Nullable
        public Tooltip getTooltip() {
            return this.tooltip;
        }
    }
}

