/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.morevillagers;

import com.frikinjay.morevillagers.mixin.VillagerTypeAccessor;
import com.frikinjay.morevillagers.platform.ConfigHelper;
import com.frikinjay.morevillagers.registry.MVBlocks;
import com.frikinjay.morevillagers.registry.MVGifts;
import com.frikinjay.morevillagers.registry.MVItems;
import com.frikinjay.morevillagers.registry.MVPoiTypes;
import com.frikinjay.morevillagers.registry.MVProfessions;
import com.frikinjay.morevillagers.registry.MVTypes;
import com.frikinjay.morevillagers.util.JigsawHelper;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.slf4j.Logger;

public class MoreVillagers {
    public static final String MOD_ID = "morevillagers";
    public static final String AETHER_ID = "aether";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceKey<CreativeModeTab> TAB = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"morevillagers", (String)"tab"));

    public static void init() {
        MVBlocks.init();
        MVItems.init();
        MVPoiTypes.init();
        MVProfessions.init();
        MVGifts.init();
        MVTypes.init();
    }

    public static void registerJigsaws(MinecraftServer server) {
        RegistryAccess.Frozen registryProvider = server.registryAccess();
        HolderLookup.RegistryLookup templatePoolRegistry = registryProvider.lookupOrThrow(Registries.TEMPLATE_POOL);
        HolderLookup.RegistryLookup processorListRegistry = registryProvider.lookupOrThrow(Registries.PROCESSOR_LIST);
        ResourceLocation plainsPoolLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/plains/houses");
        ResourceLocation desertPoolLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/desert/houses");
        ResourceLocation savannaPoolLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/savanna/houses");
        ResourceLocation snowyPoolLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/snowy/houses");
        ResourceLocation taigaPoolLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/taiga/houses");
        if (ConfigHelper.generatePlainsHouses()) {
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, plainsPoolLocation, "morevillagers:village/plains/plains_woodworker", ConfigHelper.woodworkerHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, plainsPoolLocation, "morevillagers:village/plains/plains_oceanographer", ConfigHelper.oceanographerHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, plainsPoolLocation, "morevillagers:village/plains/plains_florist", ConfigHelper.floristHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, plainsPoolLocation, "morevillagers:village/plains/plains_hunter", ConfigHelper.hunterHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, plainsPoolLocation, "morevillagers:village/plains/plains_engineer", ConfigHelper.engineerHouseWeight());
        }
        if (ConfigHelper.generateTaigaHouses()) {
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, taigaPoolLocation, "morevillagers:village/taiga/taiga_woodworker", ConfigHelper.woodworkerHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, taigaPoolLocation, "morevillagers:village/taiga/taiga_oceanographer", ConfigHelper.oceanographerHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, taigaPoolLocation, "morevillagers:village/taiga/taiga_florist", ConfigHelper.floristHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, taigaPoolLocation, "morevillagers:village/taiga/taiga_hunter", ConfigHelper.hunterHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, taigaPoolLocation, "morevillagers:village/taiga/taiga_engineer", ConfigHelper.engineerHouseWeight());
        }
        if (ConfigHelper.generateSavannaHouses()) {
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, savannaPoolLocation, "morevillagers:village/savanna/savanna_woodworker", ConfigHelper.woodworkerHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, savannaPoolLocation, "morevillagers:village/savanna/savanna_oceanographer", ConfigHelper.oceanographerHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, savannaPoolLocation, "morevillagers:village/savanna/savanna_florist", ConfigHelper.floristHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, savannaPoolLocation, "morevillagers:village/savanna/savanna_hunter", ConfigHelper.hunterHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, savannaPoolLocation, "morevillagers:village/savanna/savanna_engineer", ConfigHelper.engineerHouseWeight());
        }
        if (ConfigHelper.generateSnowyHouses()) {
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, snowyPoolLocation, "morevillagers:village/snowy/snowy_woodworker", ConfigHelper.woodworkerHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, snowyPoolLocation, "morevillagers:village/snowy/snowy_oceanographer", ConfigHelper.oceanographerHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, snowyPoolLocation, "morevillagers:village/snowy/snowy_florist", ConfigHelper.floristHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, snowyPoolLocation, "morevillagers:village/snowy/snowy_hunter", ConfigHelper.hunterHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, snowyPoolLocation, "morevillagers:village/snowy/snowy_engineer", ConfigHelper.engineerHouseWeight());
        }
        if (ConfigHelper.generateDesertHouses()) {
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, desertPoolLocation, "morevillagers:village/desert/desert_woodworker", ConfigHelper.woodworkerHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, desertPoolLocation, "morevillagers:village/desert/desert_oceanographer", ConfigHelper.oceanographerHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, desertPoolLocation, "morevillagers:village/desert/desert_florist", ConfigHelper.floristHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, desertPoolLocation, "morevillagers:village/desert/desert_hunter", ConfigHelper.hunterHouseWeight());
            JigsawHelper.addBuildingToPool((HolderLookup<StructureTemplatePool>)templatePoolRegistry, (HolderLookup<StructureProcessorList>)processorListRegistry, desertPoolLocation, "morevillagers:village/desert/desert_hunter_engineer", ConfigHelper.engineerHouseWeight());
        }
    }

    public static void registerTypeMapping(MinecraftServer server) {
        Registry villagerTypeRegistry = server.registryAccess().lookupOrThrow(Registries.VILLAGER_TYPE);
        ResourceLocation badlandsVillager = MoreVillagers.getRL(MOD_ID, "badlands");
        Map<ResourceKey<Biome>, ResourceKey<VillagerType>> byBiomes = VillagerTypeAccessor.getByBiomes();
        byBiomes.put((ResourceKey<Biome>)Biomes.BADLANDS, MVTypes.BADLANDS_KEY);
        byBiomes.put((ResourceKey<Biome>)Biomes.WOODED_BADLANDS, MVTypes.BADLANDS_KEY);
        byBiomes.put((ResourceKey<Biome>)Biomes.ERODED_BADLANDS, MVTypes.BADLANDS_KEY);
    }

    public static ResourceLocation getRL(String modid, String location) {
        return ResourceLocation.fromNamespaceAndPath((String)modid, (String)location);
    }
}

