/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.morevillagers.mixin;

import com.frikinjay.morevillagers.MoreVillagers;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MerchantScreen.class})
public abstract class MerchantScreenMixin
extends AbstractContainerScreen<MerchantMenu>
implements Renderable {
    @Unique
    private static final Set<String> PROFESSION_SET = new HashSet<String>();
    @Unique
    private static boolean morevillagers$professionsLoaded = false;

    public MerchantScreenMixin(MerchantMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @Unique
    private static void morevillagers$loadProfessions() {
        if (morevillagers$professionsLoaded) {
            return;
        }
        PROFESSION_SET.clear();
        String lang = Minecraft.getInstance().getLanguageManager().getSelected();
        String langPath = "/assets/morevillagers/lang/" + lang + ".json";
        try (InputStream inputStream = MoreVillagers.class.getResourceAsStream(langPath);){
            if (inputStream != null) {
                Language.loadFromJson((InputStream)inputStream, (key, value) -> {
                    if (key.startsWith("entity.minecraft.villager.morevillagers.")) {
                        PROFESSION_SET.add(key.substring(key.lastIndexOf(46) + 1));
                    }
                });
                morevillagers$professionsLoaded = true;
            } else {
                MoreVillagers.LOGGER.warn("Could not find language file: {}", (Object)langPath);
            }
        }
        catch (IOException e) {
            MoreVillagers.LOGGER.error("Failed to load professions from language file: {}", (Object)langPath, (Object)e);
        }
        catch (JsonParseException e) {
            MoreVillagers.LOGGER.error("Failed to parse language file: {}", (Object)langPath, (Object)e);
        }
    }

    @Unique
    private Component morevillagers$modifyTitle(Component original) {
        MerchantScreenMixin.morevillagers$loadProfessions();
        String titleText = this.title.getString();
        for (String profession : PROFESSION_SET) {
            if (!titleText.toLowerCase().contains(profession)) continue;
            String translationKey = "entity.minecraft.villager.morevillagers." + profession;
            int level = ((MerchantMenu)this.menu).getTraderLevel();
            if (level <= 0 || level > 5 || !((MerchantMenu)this.menu).showProgressBar()) continue;
            return Component.translatable((String)translationKey);
        }
        return original;
    }

    @Inject(method={"renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V"}, at={@At(value="HEAD")})
    private void modifyTitleBeforeRendering(GuiGraphics guiGraphics, int mouseX, int mouseY, CallbackInfo ci) {
        Component modifiedTitle = this.morevillagers$modifyTitle(this.title);
        if (modifiedTitle != this.title) {
            this.title = modifiedTitle;
        }
    }
}

